/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class BuildConsolePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String PREF_CLEAR_CONSOLE = "clearConsole";
    private static final String PREF_CONSOLE_ON_TOP = "consoleOnTop";
    private static final String PREF_AUTO_OPEN_CONSOLE = "autoOpenConsole";
    public static final String PREF_BUILDCONSOLE_FONT = "org.eclipse.cdt.ui.buildconsole.ConsoleFont";
    public static final String PREF_BUILDCONSOLE_TAB_WIDTH = "buildConsoleTabWith";
    public static final String PREF_BUILDCONSOLE_LINES = "buildConsoleLines";
    public static final String PREF_BUILDCONSOLE_INFO_COLOR = "buildConsoleInfoStreamColor";
    public static final String PREF_BUILDCONSOLE_OUTPUT_COLOR = "buildConsoleOutputStreamColor";
    public static final String PREF_BUILDCONSOLE_ERROR_COLOR = "buildConsoleErrorStreamColor";

    public BuildConsolePreferencePage() {
        super(1);
        this.setPreferenceStore(CUIPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        BooleanFieldEditor booleanFieldEditor = new BooleanFieldEditor(PREF_CLEAR_CONSOLE, CUIPlugin.getResourceString("ConsolePreferencePage.clearConsole.label"), composite);
        this.addField((FieldEditor)booleanFieldEditor);
        BooleanFieldEditor booleanFieldEditor2 = new BooleanFieldEditor(PREF_AUTO_OPEN_CONSOLE, CUIPlugin.getResourceString("ConsolePreferencePage.autoOpenConsole.label"), composite);
        this.addField((FieldEditor)booleanFieldEditor2);
        BooleanFieldEditor booleanFieldEditor3 = new BooleanFieldEditor(PREF_CONSOLE_ON_TOP, CUIPlugin.getResourceString("ConsolePreferencePage.consoleOnTop.label"), composite);
        this.addField((FieldEditor)booleanFieldEditor3);
        IntegerFieldEditor integerFieldEditor = new IntegerFieldEditor(PREF_BUILDCONSOLE_LINES, CUIPlugin.getResourceString("ConsolePreferencePage.consoleLines.label"), composite);
        integerFieldEditor.setErrorMessage(CUIPlugin.getResourceString("ConsolePreferencePage.consoleLines.errorMessage"));
        integerFieldEditor.setValidRange(10, Integer.MAX_VALUE);
        this.addField((FieldEditor)integerFieldEditor);
        IntegerFieldEditor integerFieldEditor2 = new IntegerFieldEditor(PREF_BUILDCONSOLE_TAB_WIDTH, CUIPlugin.getResourceString("ConsolePreferencePage.tabWidth.label"), composite);
        this.addField((FieldEditor)integerFieldEditor2);
        integerFieldEditor2.setValidRange(1, 100);
        integerFieldEditor2.setErrorMessage(CUIPlugin.getResourceString("ConsolePreferencePage.tabWidth.errorMessage"));
        this.createLabel(composite, CUIPlugin.getResourceString("ConsolePreferencePage.colorSettings.label"));
        this.addField((FieldEditor)this.createColorFieldEditor(PREF_BUILDCONSOLE_OUTPUT_COLOR, CUIPlugin.getResourceString("ConsolePreferencePage.outputColor.label"), composite));
        this.addField((FieldEditor)this.createColorFieldEditor(PREF_BUILDCONSOLE_INFO_COLOR, CUIPlugin.getResourceString("ConsolePreferencePage.infoColor.label"), composite));
        this.addField((FieldEditor)this.createColorFieldEditor(PREF_BUILDCONSOLE_ERROR_COLOR, CUIPlugin.getResourceString("ConsolePreferencePage.errorColor.label"), composite));
    }

    private Label createLabel(Composite composite, String string) {
        Label label = new Label(composite, 16384);
        label.setText(string);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        return label;
    }

    private ColorFieldEditor createColorFieldEditor(String string, String string2, Composite composite) {
        ColorFieldEditor colorFieldEditor = new ColorFieldEditor(string, string2, composite);
        colorFieldEditor.setPreferencePage((PreferencePage)this);
        colorFieldEditor.setPreferenceStore(this.getPreferenceStore());
        return colorFieldEditor;
    }

    public static boolean isClearBuildConsole() {
        return CUIPlugin.getDefault().getPreferenceStore().getBoolean(PREF_CLEAR_CONSOLE);
    }

    public static boolean isAutoOpenConsole() {
        return CUIPlugin.getDefault().getPreferenceStore().getBoolean(PREF_AUTO_OPEN_CONSOLE);
    }

    public static boolean isConsoleOnTop() {
        return CUIPlugin.getDefault().getPreferenceStore().getBoolean(PREF_CONSOLE_ON_TOP);
    }

    public static int buildConsoleLines() {
        return CUIPlugin.getDefault().getPreferenceStore().getInt(PREF_BUILDCONSOLE_LINES);
    }

    public void init(IWorkbench iWorkbench) {
    }

    public static void initDefaults(IPreferenceStore iPreferenceStore) {
        iPreferenceStore.setDefault(PREF_CLEAR_CONSOLE, true);
        iPreferenceStore.setDefault(PREF_AUTO_OPEN_CONSOLE, false);
        iPreferenceStore.setDefault(PREF_CONSOLE_ON_TOP, true);
        iPreferenceStore.setDefault(PREF_BUILDCONSOLE_LINES, 500);
        iPreferenceStore.setDefault(PREF_BUILDCONSOLE_TAB_WIDTH, 4);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)PREF_BUILDCONSOLE_OUTPUT_COLOR, (RGB)new RGB(0, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)PREF_BUILDCONSOLE_INFO_COLOR, (RGB)new RGB(0, 0, 255));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)PREF_BUILDCONSOLE_ERROR_COLOR, (RGB)new RGB(255, 0, 0));
    }
}

