/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.filetype.IResolverModel;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CFileTypeDialog
extends Dialog {
    private Text fTextPattern;
    private Combo fComboType;
    private String fPattern;
    private ICFileType fType;

    public CFileTypeDialog(Shell shell) {
        super(shell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(PreferencesMessages.getString("CFileTypeDialog.title"));
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.getOkayButton().setEnabled(this.getPatternFromControl().length() > 0);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        ((GridLayout)composite2.getLayout()).numColumns = 2;
        Label label = new Label(composite2, 0);
        label.setText(PreferencesMessages.getString("CFileTypeDialog.patternLabel"));
        this.fTextPattern = new Text(composite2, 2052);
        this.fTextPattern.setLayoutData((Object)new GridData(768));
        if (this.fPattern != null) {
            this.fTextPattern.setText(this.fPattern);
        }
        this.fTextPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                CFileTypeDialog.this.getOkayButton().setEnabled(CFileTypeDialog.this.getPatternFromControl().length() > 0);
            }
        });
        Label label2 = new Label(composite2, 0);
        label2.setText(PreferencesMessages.getString("CFileTypeDialog.typeLabel"));
        this.fComboType = new Combo(composite2, 12);
        this.fComboType.setLayoutData((Object)new GridData(768));
        this.populateTypesCombo();
        return composite2;
    }

    public void setPattern(String string) {
        this.fPattern = string;
    }

    public String getPattern() {
        return this.fPattern;
    }

    public void setType(ICFileType iCFileType) {
        this.fType = iCFileType;
    }

    public ICFileType getType() {
        return this.fType;
    }

    private void populateTypesCombo() {
        ICFileType[] iCFileTypeArray = this.getResolverModel().getFileTypes();
        int n = -1;
        int n2 = 0;
        while (n2 < iCFileTypeArray.length) {
            this.fComboType.add(iCFileTypeArray[n2].getName());
            ++n2;
        }
        this.fComboType.setData((Object)iCFileTypeArray);
        if (this.fType != null) {
            n = this.fComboType.indexOf(this.fType.getName());
        }
        this.fComboType.select(n < 0 ? 0 : n);
    }

    private IResolverModel getResolverModel() {
        return CCorePlugin.getDefault().getResolverModel();
    }

    private Button getOkayButton() {
        return this.getButton(0);
    }

    private String getPatternFromControl() {
        return this.fTextPattern.getText().trim();
    }

    private ICFileType getTypeFromControl() {
        String string = null;
        int n = this.fComboType.getSelectionIndex();
        if (-1 != n) {
            String string2 = this.fComboType.getItem(n);
            ICFileType[] iCFileTypeArray = (ICFileType[])this.fComboType.getData();
            int n2 = 0;
            while (n2 < iCFileTypeArray.length) {
                if (string2.equals(iCFileTypeArray[n2].getName())) {
                    string = iCFileTypeArray[n2].getId();
                }
                ++n2;
            }
        }
        return this.getResolverModel().getFileTypeById(string);
    }

    protected void okPressed() {
        this.fPattern = this.getPatternFromControl();
        this.fType = this.getTypeFromControl();
        super.okPressed();
    }
}

