/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.filetype.ICFileTypeAssociation;
import org.eclipse.cdt.core.filetype.ICFileTypeResolver;
import org.eclipse.cdt.core.filetype.IResolverModel;
import org.eclipse.cdt.internal.ui.preferences.CFileTypeDialog;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class CFileTypesPreferenceBlock {
    private static final int COL_PATTERN = 0;
    private static final int COL_DESCRIPTION = 1;
    private static final int COL_LANGUAGE = 2;
    private ICFileTypeResolver fResolver;
    private ArrayList fAddAssoc = new ArrayList();
    private ArrayList fRemoveAssoc = new ArrayList();
    private boolean fDirty = false;
    private TableViewer fAssocViewer;
    private Button fBtnNew;
    private Button fBtnRemove;

    public CFileTypesPreferenceBlock(ICFileTypeResolver iCFileTypeResolver) {
        this.setResolver(iCFileTypeResolver);
        this.setDirty(false);
    }

    public Control createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout2 = new GridLayout();
        GridData gridData = new GridData(1808);
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout2);
        composite3.setLayoutData((Object)gridData);
        Table table = new Table(composite3, 68098);
        TableLayout tableLayout = new TableLayout();
        TableColumn tableColumn = null;
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.heightHint = SWTUtil.getTableHeightHint(table, 25);
        gridData.widthHint = new PixelConverter((Control)composite).convertWidthInCharsToPixels(60);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        table.setLayout((Layout)tableLayout);
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        tableColumn = new TableColumn(table, 16384);
        tableColumn.setText(PreferencesMessages.getString("CFileTypesPreferencePage.colTitlePattern"));
        tableColumn = new TableColumn(table, 16384);
        tableColumn.setText(PreferencesMessages.getString("CFileTypesPreferencePage.colTitleDescription"));
        tableColumn = new TableColumn(table, 16384);
        tableColumn.setText(PreferencesMessages.getString("CFileTypesPreferencePage.colTitleLanguage"));
        Composite composite4 = new Composite(composite2, 0);
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.marginHeight = 0;
        gridLayout3.marginWidth = 0;
        composite4.setLayout((Layout)gridLayout3);
        composite4.setLayoutData((Object)new GridData(2));
        this.fBtnNew = new Button(composite4, 8);
        this.fBtnNew.setText(PreferencesMessages.getString("CFileTypesPreferenceBlock.New..."));
        gridData = new GridData(768);
        gridData.widthHint = SWTUtil.getButtonWidthHint(this.fBtnNew);
        gridData.heightHint = SWTUtil.getButtonHeigthHint(this.fBtnNew);
        this.fBtnNew.setLayoutData((Object)gridData);
        this.fBtnNew.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CFileTypesPreferenceBlock.this.handleAdd();
            }
        });
        this.fBtnRemove = new Button(composite4, 8);
        this.fBtnRemove.setText(PreferencesMessages.getString("CFileTypesPreferenceBlock.Remove"));
        gridData = new GridData(768);
        gridData.widthHint = SWTUtil.getButtonWidthHint(this.fBtnRemove);
        gridData.heightHint = SWTUtil.getButtonHeigthHint(this.fBtnRemove);
        this.fBtnRemove.setLayoutData((Object)gridData);
        this.fBtnRemove.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CFileTypesPreferenceBlock.this.handleRemove();
            }
        });
        this.fAssocViewer = new TableViewer(table);
        this.fAssocViewer.setSorter((ViewerSorter)new AssocSorter());
        this.fAssocViewer.setContentProvider((IContentProvider)new AssocContentProvider());
        this.fAssocViewer.setLabelProvider((IBaseLabelProvider)new AssocLabelProvider());
        this.fAssocViewer.setInput((Object)this.getResolver().getFileTypeAssociations());
        this.fAssocViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                CFileTypesPreferenceBlock.this.handleSelectionChanged();
            }
        });
        this.handleSelectionChanged();
        return composite2;
    }

    public void setEnabled(boolean bl) {
        this.fAssocViewer.getTable().setEnabled(bl);
        this.fBtnNew.setEnabled(bl);
        this.fBtnRemove.setEnabled(bl);
        this.setDirty(bl);
    }

    public void setResolver(ICFileTypeResolver iCFileTypeResolver) {
        this.fAddAssoc.clear();
        this.fRemoveAssoc.clear();
        this.fResolver = iCFileTypeResolver.createWorkingCopy();
        if (this.fAssocViewer != null) {
            this.fAssocViewer.setInput((Object)this.fResolver.getFileTypeAssociations());
        }
        this.setDirty(true);
    }

    public ICFileTypeResolver getResolver() {
        return this.fResolver;
    }

    public void setDirty(boolean bl) {
        this.fDirty = bl;
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    public boolean performOk() {
        boolean bl = this.fDirty;
        if (this.fDirty) {
            ICFileTypeAssociation[] iCFileTypeAssociationArray = this.fAddAssoc.toArray(new ICFileTypeAssociation[this.fAddAssoc.size()]);
            ICFileTypeAssociation[] iCFileTypeAssociationArray2 = this.fRemoveAssoc.toArray(new ICFileTypeAssociation[this.fRemoveAssoc.size()]);
            this.fResolver.adjustAssociations(iCFileTypeAssociationArray, iCFileTypeAssociationArray2);
            this.fAddAssoc.clear();
            this.fRemoveAssoc.clear();
            this.setDirty(false);
        }
        return bl;
    }

    private void handleSelectionChanged() {
        IStructuredSelection iStructuredSelection = this.getSelection();
        this.fBtnRemove.setEnabled(!iStructuredSelection.isEmpty());
    }

    private IResolverModel getResolverModel() {
        return CCorePlugin.getDefault().getResolverModel();
    }

    private void handleAdd() {
        ICFileTypeAssociation iCFileTypeAssociation = null;
        CFileTypeDialog cFileTypeDialog = new CFileTypeDialog(this.fBtnNew.getParent().getShell());
        if (cFileTypeDialog.open() == 0 && (iCFileTypeAssociation = this.getResolverModel().createAssocation(cFileTypeDialog.getPattern(), cFileTypeDialog.getType())) != null) {
            this.fAssocViewer.add((Object)iCFileTypeAssociation);
            this.fAddAssoc.add(iCFileTypeAssociation);
            this.fRemoveAssoc.remove(iCFileTypeAssociation);
            this.setDirty(true);
        }
    }

    private void handleRemove() {
        IStructuredSelection iStructuredSelection = this.getSelection();
        if (iStructuredSelection != null && !iStructuredSelection.isEmpty()) {
            Iterator iterator = iStructuredSelection.iterator();
            while (iterator.hasNext()) {
                ICFileTypeAssociation iCFileTypeAssociation = (ICFileTypeAssociation)iterator.next();
                this.fAssocViewer.remove((Object)iCFileTypeAssociation);
                this.fAddAssoc.remove(iCFileTypeAssociation);
                this.fRemoveAssoc.add(iCFileTypeAssociation);
                this.setDirty(true);
            }
        }
    }

    private IStructuredSelection getSelection() {
        return (IStructuredSelection)this.fAssocViewer.getSelection();
    }

    private class AssocSorter
    extends ViewerSorter {
        AssocSorter() {
        }

        public int category(Object object) {
            if (object instanceof ICFileTypeAssociation) {
                ICFileTypeAssociation iCFileTypeAssociation = (ICFileTypeAssociation)object;
                if (-1 != iCFileTypeAssociation.getPattern().indexOf(42)) {
                    return 10;
                }
                return 20;
            }
            return 30;
        }
    }

    private class AssocContentProvider
    implements IStructuredContentProvider {
        ICFileTypeAssociation[] assocs;

        AssocContentProvider() {
        }

        public Object[] getElements(Object object) {
            return this.assocs;
        }

        public void dispose() {
            this.assocs = null;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            if (object2 instanceof ICFileTypeAssociation[]) {
                this.assocs = (ICFileTypeAssociation[])object2;
            }
        }
    }

    private class AssocLabelProvider
    implements ILabelProvider,
    ITableLabelProvider {
        private ListenerList listeners = new ListenerList();

        AssocLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            if (object instanceof ICFileTypeAssociation && n == 0) {
                return null;
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof ICFileTypeAssociation) {
                ICFileTypeAssociation iCFileTypeAssociation = (ICFileTypeAssociation)object;
                switch (n) {
                    case 0: {
                        return iCFileTypeAssociation.getPattern();
                    }
                    case 1: {
                        return iCFileTypeAssociation.getType().getName();
                    }
                    case 2: {
                        return iCFileTypeAssociation.getType().getLanguage().getName();
                    }
                }
            }
            return object.toString();
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
            this.listeners.add((Object)iLabelProviderListener);
        }

        public void dispose() {
            this.listeners.clear();
            this.listeners = null;
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
            this.listeners.remove((Object)iLabelProviderListener);
        }

        public Image getImage(Object object) {
            return this.getColumnImage(object, 0);
        }

        public String getText(Object object) {
            return this.getColumnText(object, 0);
        }
    }
}

