/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.filetype.ICFileTypeResolver;
import org.eclipse.cdt.core.filetype.IResolverModel;
import org.eclipse.cdt.internal.ui.preferences.CFileTypesPreferenceBlock;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class CFileTypesPropertyPage
extends PropertyPage {
    private Button fUseWorkspace;
    private Button fUseProject;
    private CFileTypesPreferenceBlock fPrefsBlock;

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout());
        composite3.setLayoutData((Object)new GridData(768));
        this.fUseWorkspace = new Button(composite3, 16);
        this.fUseWorkspace.setText(PreferencesMessages.getString("CFileTypesPropertyPage.useWorkspaceSettings"));
        this.fUseWorkspace.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CFileTypesPropertyPage.this.fPrefsBlock.setEnabled(false);
            }
        });
        this.fUseProject = new Button(composite3, 16);
        this.fUseProject.setText(PreferencesMessages.getString("CFileTypesPropertyPage.useProjectSettings"));
        this.fUseProject.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CFileTypesPropertyPage.this.fPrefsBlock.setEnabled(true);
            }
        });
        IProject iProject = this.getProject();
        ICFileTypeResolver iCFileTypeResolver = CCorePlugin.getDefault().getFileTypeResolver(iProject);
        IResolverModel iResolverModel = CCorePlugin.getDefault().getResolverModel();
        boolean bl = iResolverModel.getResolver() != iResolverModel.getResolver(iProject);
        Composite composite4 = new Composite(composite2, 0);
        composite4.setLayout((Layout)new GridLayout());
        composite4.setLayoutData((Object)new GridData(1808));
        this.fPrefsBlock = new CFileTypesPreferenceBlock(iCFileTypeResolver);
        this.fPrefsBlock.createControl(composite4);
        this.fUseWorkspace.setSelection(!bl);
        this.fUseProject.setSelection(bl);
        this.fPrefsBlock.setEnabled(bl);
        WorkbenchHelp.setHelp((Control)composite2, (String)"org.eclipse.cdt.ui.std_prop_file_types");
        return composite2;
    }

    protected void performDefaults() {
        this.fUseWorkspace.setSelection(true);
        this.fUseProject.setSelection(false);
        this.fPrefsBlock.setEnabled(false);
        super.performDefaults();
    }

    public boolean performOk() {
        IResolverModel iResolverModel = this.getResolverModel();
        if (this.fUseProject.getSelection()) {
            if (this.fPrefsBlock.performOk()) {
                iResolverModel.setResolver(this.getProject(), this.fPrefsBlock.getResolver());
            }
        } else {
            iResolverModel.setResolver(this.getProject(), null);
        }
        return super.performOk();
    }

    private IProject getProject() {
        IAdaptable iAdaptable = this.getElement();
        IProject iProject = null;
        if (iAdaptable != null && iAdaptable instanceof IProject) {
            iProject = (IProject)iAdaptable;
        }
        return iProject;
    }

    private IResolverModel getResolverModel() {
        return CCorePlugin.getDefault().getResolverModel();
    }
}

