/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CSearchPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Combo fExternLinks;
    private Button fExternEnabled;
    protected OverlayPreferenceStore fOverlayStore;
    private Text fTextControl;
    private static final String TIMEOUT_VALUE = "20000";

    public CSearchPreferencePage() {
        this.setPreferenceStore(CUIPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = this.createOverlayStore();
    }

    private OverlayPreferenceStore createOverlayStore() {
        ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "externMatchEnable"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "externMatchVisible"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "CDT_INDEXER_TIMEOUT"));
        OverlayPreferenceStore.OverlayKey[] overlayKeyArray = new OverlayPreferenceStore.OverlayKey[arrayList.size()];
        arrayList.toArray(overlayKeyArray);
        return new OverlayPreferenceStore(this.getPreferenceStore(), overlayKeyArray);
    }

    protected Control createContents(Composite composite) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(PreferencesMessages.getString("CSearchPreferences.ExternalSearchLinks.ExternalSearchLinksGroup"));
        this.fExternEnabled = this.createCheckButton((Composite)group, PreferencesMessages.getString("CSearchPreferences.ExternalSearchLinks.EnableMessage"));
        this.fExternEnabled.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                boolean bl = false;
                CSearchPreferencePage.this.fExternLinks.setEnabled(false);
                if (button.getSelection()) {
                    CSearchPreferencePage.this.fExternLinks.setEnabled(true);
                    bl = true;
                }
                CSearchPreferencePage.this.fOverlayStore.setValue("externMatchEnable", bl);
            }
        });
        this.fExternLinks = this.createComboBox((Composite)group, PreferencesMessages.getString("CSearchPreferences.ExternalSearchLinks.EnableMarkerLinkType"), new String[]{PreferencesMessages.getString("CSearchPreferences.ExternalSearchLinks.Invisible")}, PreferencesMessages.getString("CSearchPreferences.ExternalSearchLinks.Invisible"));
        this.fExternLinks.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                Combo combo = (Combo)selectionEvent.widget;
                CSearchPreferencePage.this.fOverlayStore.setValue("externMatchVisible", combo.getSelectionIndex());
            }
        });
        Group group2 = new Group(composite2, 0);
        group2.setLayout((Layout)new GridLayout());
        group2.setLayoutData((Object)new GridData(768));
        group2.setText(PreferencesMessages.getString("CSearchPreferences.IndexerTimeout.IndexerTimeoutGroup"));
        this.fTextControl = (Text)this.addTextField((Composite)group2, PreferencesMessages.getString("CSearchPreferences.IndexerTimeout.Timeout"), "TimeOut", 6, 0, true);
        this.initialize();
        return composite2;
    }

    private void initialize() {
        boolean bl = this.fOverlayStore.getBoolean("externMatchEnable");
        this.fExternEnabled.setSelection(bl);
        this.fExternLinks.select(this.fOverlayStore.getInt("externMatchVisible"));
        this.fExternLinks.setEnabled(bl);
        this.fTextControl.setText(this.fOverlayStore.getString("CDT_INDEXER_TIMEOUT"));
    }

    public void init(IWorkbench iWorkbench) {
    }

    private Combo createComboBox(Composite composite, String string, String[] stringArray, String string2) {
        ControlFactory.createLabel(composite, string);
        Combo combo = ControlFactory.createSelectCombo(composite, stringArray, string2);
        combo.setLayoutData((Object)new GridData());
        return combo;
    }

    private Button createCheckButton(Composite composite, String string) {
        Button button = new Button(composite, 16416);
        button.setText(string);
        GridData gridData = new GridData();
        button.setLayoutData((Object)gridData);
        return button;
    }

    private Control addTextField(Composite composite, String string, String string2, int n, int n2, boolean bl) {
        Label label = new Label(composite, 0);
        label.setText(string);
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = n2;
        label.setLayoutData((Object)gridData);
        Text text = new Text(composite, 2052);
        gridData = new GridData(32);
        gridData.widthHint = this.convertWidthInCharsToPixels(n + 1);
        text.setLayoutData((Object)gridData);
        text.setTextLimit(n);
        return text;
    }

    public boolean performOk() {
        String string = this.fTextControl.getText();
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            string = TIMEOUT_VALUE;
        }
        this.fOverlayStore.setValue("CDT_INDEXER_TIMEOUT", string);
        this.fOverlayStore.propagate();
        Preferences preferences = CCorePlugin.getDefault().getPluginPreferences();
        preferences.setValue("CDT_INDEXER_TIMEOUT", string);
        CCorePlugin.getDefault().savePluginPreferences();
        return true;
    }

    public static void initDefaults(IPreferenceStore iPreferenceStore) {
        iPreferenceStore.setDefault("externMatchEnable", false);
        iPreferenceStore.setDefault("externMatchVisible", 0);
        iPreferenceStore.setDefault("CDT_INDEXER_TIMEOUT", TIMEOUT_VALUE);
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initialize();
        super.performDefaults();
    }
}

