/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;

public abstract class OptionsConfigurationBlock {
    protected Map fWorkingValues;
    protected ArrayList fCheckBoxes;
    protected ArrayList fComboBoxes;
    protected ArrayList fTextBoxes;
    private SelectionListener fSelectionListener;
    private ModifyListener fTextModifyListener;
    protected IStatusChangeListener fContext;
    protected ICProject fProject;
    private Shell fShell;

    public OptionsConfigurationBlock(IStatusChangeListener iStatusChangeListener, ICProject iCProject) {
        this.fContext = iStatusChangeListener;
        this.fProject = iCProject;
        this.fWorkingValues = this.getOptions(true);
        this.fCheckBoxes = new ArrayList();
        this.fComboBoxes = new ArrayList();
        this.fTextBoxes = new ArrayList(2);
    }

    protected abstract String[] getAllKeys();

    protected Map getOptions(boolean bl) {
        if (this.fProject != null) {
            return this.fProject.getOptions(bl);
        }
        return CCorePlugin.getOptions();
    }

    protected Map getDefaultOptions() {
        return CCorePlugin.getDefaultOptions();
    }

    public final boolean hasProjectSpecificOptions() {
        if (this.fProject != null) {
            Map map = this.fProject.getOptions(false);
            String[] stringArray = this.getAllKeys();
            int n = 0;
            while (n < stringArray.length) {
                if (map.get(stringArray[n]) != null) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    protected final void setOptions(Map map) {
        if (this.fProject != null) {
            this.fProject.setOptions(map);
        } else {
            CCorePlugin.setOptions((HashMap)((HashMap)map));
        }
    }

    protected Shell getShell() {
        return this.fShell;
    }

    protected void setShell(Shell shell) {
        this.fShell = shell;
    }

    protected abstract Control createContents(Composite var1);

    protected void addCheckBox(Composite composite, String string, String string2, String[] stringArray, int n) {
        ControlData controlData = new ControlData(string2, stringArray);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = n;
        Button button = new Button(composite, 32);
        button.setText(string);
        button.setData((Object)controlData);
        button.setLayoutData((Object)gridData);
        button.addSelectionListener(this.getSelectionListener());
        String string3 = (String)this.fWorkingValues.get(string2);
        button.setSelection(controlData.getSelection(string3) == 0);
        this.fCheckBoxes.add(button);
    }

    protected void addComboBox(Composite composite, String string, String string2, String[] stringArray, String[] stringArray2, int n) {
        ControlData controlData = new ControlData(string2, stringArray);
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = n;
        Label label = new Label(composite, 16448);
        label.setText(string);
        label.setLayoutData((Object)gridData);
        Combo combo = new Combo(composite, 8);
        combo.setItems(stringArray2);
        combo.setData((Object)controlData);
        combo.setLayoutData((Object)new GridData(256));
        combo.addSelectionListener(this.getSelectionListener());
        String string3 = (String)this.fWorkingValues.get(string2);
        combo.select(controlData.getSelection(string3));
        this.fComboBoxes.add(combo);
    }

    protected Text addTextField(Composite composite, String string, String string2, int n, int n2) {
        Label label = new Label(composite, 0);
        label.setText(string);
        label.setLayoutData((Object)new GridData());
        Text text = new Text(composite, 2052);
        text.setData((Object)string2);
        text.setLayoutData((Object)new GridData());
        String string3 = (String)this.fWorkingValues.get(string2);
        text.setText(string3);
        text.addModifyListener(this.getTextModifyListener());
        GridData gridData = new GridData(256);
        if (n2 != 0) {
            gridData.widthHint = n2;
        }
        gridData.horizontalIndent = n;
        text.setLayoutData((Object)gridData);
        this.fTextBoxes.add(text);
        return text;
    }

    protected SelectionListener getSelectionListener() {
        if (this.fSelectionListener == null) {
            this.fSelectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    OptionsConfigurationBlock.this.controlChanged(selectionEvent.widget);
                }
            };
        }
        return this.fSelectionListener;
    }

    protected ModifyListener getTextModifyListener() {
        if (this.fTextModifyListener == null) {
            this.fTextModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    OptionsConfigurationBlock.this.textChanged((Text)modifyEvent.widget);
                }
            };
        }
        return this.fTextModifyListener;
    }

    protected void controlChanged(Widget widget) {
        ControlData controlData = (ControlData)widget.getData();
        String string = null;
        if (widget instanceof Button) {
            string = controlData.getValue(((Button)widget).getSelection());
        } else if (widget instanceof Combo) {
            string = controlData.getValue(((Combo)widget).getSelectionIndex());
        } else {
            return;
        }
        this.fWorkingValues.put(controlData.getKey(), string);
        this.validateSettings(controlData.getKey(), string);
    }

    protected void textChanged(Text text) {
        String string = (String)text.getData();
        String string2 = text.getText();
        this.fWorkingValues.put(string, string2);
        this.validateSettings(string, string2);
    }

    protected boolean checkValue(String string, String string2) {
        return string2.equals(this.fWorkingValues.get(string));
    }

    protected abstract void validateSettings(String var1, String var2);

    protected String[] getTokens(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = stringTokenizer.nextToken().trim();
            ++n2;
        }
        return stringArray;
    }

    public boolean performOk(boolean bl) {
        String string;
        String[] stringArray;
        String[] stringArray2 = this.getAllKeys();
        Map map = this.getOptions(false);
        boolean bl2 = false;
        int n = 0;
        while (n < stringArray2.length) {
            stringArray = stringArray2[n];
            string = (String)map.get(stringArray);
            String string2 = null;
            if (bl) {
                string2 = (String)this.fWorkingValues.get(stringArray);
                if (!string2.equals(string)) {
                    bl2 = true;
                    map.put(stringArray, string2);
                }
            } else if (string != null) {
                map.remove(stringArray);
                bl2 = true;
            }
            ++n;
        }
        if (bl2) {
            n = 0;
            stringArray = this.getFullReParseDialogStrings(this.fProject == null);
            if (stringArray != null) {
                string = new MessageDialog(this.getShell(), stringArray[0], null, stringArray[1], 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
                int n2 = string.open();
                if (n2 == 0) {
                    n = 1;
                } else if (n2 != 1) {
                    return false;
                }
            }
            this.setOptions(map);
            if (n != 0) {
                this.doFullReParse();
            }
        }
        return true;
    }

    protected abstract String[] getFullBuildDialogStrings(boolean var1);

    protected abstract String[] getFullReParseDialogStrings(boolean var1);

    protected void doFullBuild() {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
        try {
            progressMonitorDialog.run(true, true, new IRunnableWithProgress(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                    iProgressMonitor.beginTask("", 1);
                    try {
                        try {
                            if (OptionsConfigurationBlock.this.fProject != null) {
                                iProgressMonitor.setTaskName(PreferencesMessages.getFormattedString("OptionsConfigurationBlock.buildproject.taskname", OptionsConfigurationBlock.this.fProject.getElementName()));
                                OptionsConfigurationBlock.this.fProject.getProject().build(6, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                            } else {
                                iProgressMonitor.setTaskName(PreferencesMessages.getString("OptionsConfigurationBlock.buildall.taskname"));
                                CUIPlugin.getWorkspace().build(6, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                            }
                        }
                        catch (CoreException coreException) {
                            throw new InvocationTargetException(coreException);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        iProgressMonitor.done();
                        throw throwable;
                    }
                    {
                        Object var3_5 = null;
                    }
                    iProgressMonitor.done();
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = PreferencesMessages.getString("OptionsConfigurationBlock.builderror.title");
            String string2 = PreferencesMessages.getString("OptionsConfigurationBlock.builderror.message");
            ExceptionHandler.handle(invocationTargetException, this.getShell(), string, string2);
        }
    }

    protected void doFullReParse() {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
        try {
            progressMonitorDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                    iProgressMonitor.beginTask("", 1);
                    if (OptionsConfigurationBlock.this.fProject != null) {
                        iProgressMonitor.setTaskName(PreferencesMessages.getFormattedString("OptionsConfigurationBlock.parseproject.taskname", OptionsConfigurationBlock.this.fProject.getElementName()));
                        OptionsConfigurationBlock.this.reParseHierarchy(OptionsConfigurationBlock.this.fProject.getResource(), iProgressMonitor);
                    } else {
                        iProgressMonitor.setTaskName(PreferencesMessages.getString("OptionsConfigurationBlock.parseall.taskname"));
                        OptionsConfigurationBlock.this.reParseHierarchy((IResource)CUIPlugin.getWorkspace().getRoot(), iProgressMonitor);
                    }
                    iProgressMonitor.done();
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = PreferencesMessages.getString("OptionsConfigurationBlock.parseerror.title");
            String string2 = PreferencesMessages.getString("OptionsConfigurationBlock.parseerror.message");
            ExceptionHandler.handle(invocationTargetException, this.getShell(), string, string2);
        }
    }

    protected void reParseHierarchy(IResource iResource, final IProgressMonitor iProgressMonitor) {
        try {
            iResource.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy iResourceProxy) {
                    switch (iResourceProxy.getType()) {
                        case 1: {
                            IFile iFile = (IFile)iResourceProxy.requestResource();
                            if (CoreModel.isTranslationUnit((IFile)iFile)) {
                                CoreModel coreModel = CoreModel.getDefault();
                                ITranslationUnit iTranslationUnit = (ITranslationUnit)coreModel.create(iFile);
                                try {
                                    IWorkingCopy iWorkingCopy;
                                    IEditorInput iEditorInput = EditorUtility.getEditorInput(iFile);
                                    if (iEditorInput != null && (iWorkingCopy = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(iEditorInput)) != null) {
                                        iTranslationUnit = iWorkingCopy;
                                    }
                                    iTranslationUnit.makeConsistent(iProgressMonitor, true);
                                }
                                catch (CModelException cModelException) {}
                            }
                            return false;
                        }
                    }
                    return true;
                }
            }, 0);
        }
        catch (CoreException coreException) {}
    }

    public void performDefaults() {
        this.fWorkingValues = this.getDefaultOptions();
        this.updateControls();
        this.validateSettings(null, null);
    }

    protected void updateControls() {
        String string;
        Object object;
        Button button;
        int n = this.fCheckBoxes.size() - 1;
        while (n >= 0) {
            object = (ControlData)(button = (Button)this.fCheckBoxes.get(n)).getData();
            button.setSelection(((ControlData)object).getSelection(string = (String)this.fWorkingValues.get(((ControlData)object).getKey())) == 0);
            --n;
        }
        n = this.fComboBoxes.size() - 1;
        while (n >= 0) {
            button = (Combo)this.fComboBoxes.get(n);
            object = (ControlData)button.getData();
            string = (String)this.fWorkingValues.get(((ControlData)object).getKey());
            button.select(((ControlData)object).getSelection(string));
            --n;
        }
        n = this.fTextBoxes.size() - 1;
        while (n >= 0) {
            button = (Text)this.fTextBoxes.get(n);
            object = (String)button.getData();
            string = (String)this.fWorkingValues.get(object);
            button.setText(string);
            --n;
        }
    }

    protected static class ControlData {
        private String fKey;
        private String[] fValues;

        public ControlData(String string, String[] stringArray) {
            this.fKey = string;
            this.fValues = stringArray;
        }

        public String getKey() {
            return this.fKey;
        }

        public String getValue(boolean bl) {
            int n = bl ? 0 : 1;
            return this.fValues[n];
        }

        public String getValue(int n) {
            return this.fValues[n];
        }

        public int getSelection(String string) {
            int n = 0;
            while (n < this.fValues.length) {
                if (string.equals(this.fValues[n])) {
                    return n;
                }
                ++n;
            }
            throw new IllegalArgumentException();
        }
    }
}

