/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.preferences.TodoTaskConfigurationBlock;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class TodoTaskInputDialog
extends StatusDialog {
    private StringDialogField fNameDialogField;
    private ComboDialogField fPriorityDialogField;
    private List fExistingNames;

    public TodoTaskInputDialog(Shell shell, TodoTaskConfigurationBlock.TodoTask todoTask, List list) {
        super(shell);
        String[] stringArray;
        this.fExistingNames = new ArrayList(list.size());
        int n = 0;
        while (n < list.size()) {
            stringArray = (String[])list.get(n);
            if (!stringArray.equals(todoTask)) {
                this.fExistingNames.add(stringArray.name);
            }
            ++n;
        }
        if (todoTask == null) {
            this.setTitle(PreferencesMessages.getString("TodoTaskInputDialog.new.title"));
        } else {
            this.setTitle(PreferencesMessages.getString("TodoTaskInputDialog.edit.title"));
        }
        CompilerTodoTaskInputAdapter compilerTodoTaskInputAdapter = new CompilerTodoTaskInputAdapter();
        this.fNameDialogField = new StringDialogField();
        this.fNameDialogField.setLabelText(PreferencesMessages.getString("TodoTaskInputDialog.name.label"));
        this.fNameDialogField.setDialogFieldListener(compilerTodoTaskInputAdapter);
        this.fNameDialogField.setText(todoTask != null ? todoTask.name : "");
        stringArray = new String[]{PreferencesMessages.getString("TodoTaskInputDialog.priority.high"), PreferencesMessages.getString("TodoTaskInputDialog.priority.normal"), PreferencesMessages.getString("TodoTaskInputDialog.priority.low")};
        this.fPriorityDialogField = new ComboDialogField(8);
        this.fPriorityDialogField.setLabelText(PreferencesMessages.getString("TodoTaskInputDialog.priority.label"));
        this.fPriorityDialogField.setItems(stringArray);
        if (todoTask != null) {
            if ("HIGH".equals(todoTask.priority)) {
                this.fPriorityDialogField.selectItem(0);
            } else if ("NORMAL".equals(todoTask.priority)) {
                this.fPriorityDialogField.selectItem(1);
            } else {
                this.fPriorityDialogField.selectItem(2);
            }
        } else {
            this.fPriorityDialogField.selectItem(1);
        }
    }

    public TodoTaskConfigurationBlock.TodoTask getResult() {
        TodoTaskConfigurationBlock.TodoTask todoTask = new TodoTaskConfigurationBlock.TodoTask();
        todoTask.name = this.fNameDialogField.getText().trim();
        switch (this.fPriorityDialogField.getSelectionIndex()) {
            case 0: {
                todoTask.priority = "HIGH";
                break;
            }
            case 1: {
                todoTask.priority = "NORMAL";
                break;
            }
            default: {
                todoTask.priority = "LOW";
            }
        }
        return todoTask;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        this.fNameDialogField.doFillIntoGrid(composite3, 2);
        this.fPriorityDialogField.doFillIntoGrid(composite3, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fNameDialogField.getTextControl(null));
        LayoutUtil.setWidthHint((Control)this.fNameDialogField.getTextControl(null), this.convertWidthInCharsToPixels(45));
        this.fNameDialogField.postSetFocusOnDialogField(composite.getDisplay());
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private void doValidation() {
        StatusInfo statusInfo = new StatusInfo();
        String string = this.fNameDialogField.getText();
        if (string.length() == 0) {
            statusInfo.setError(PreferencesMessages.getString("TodoTaskInputDialog.error.enterName"));
        } else if (string.indexOf(44) != -1) {
            statusInfo.setError(PreferencesMessages.getString("TodoTaskInputDialog.error.comma"));
        } else if (this.fExistingNames.contains(string)) {
            statusInfo.setError(PreferencesMessages.getString("TodoTaskInputDialog.error.entryExists"));
        } else if (Character.isWhitespace(string.charAt(0)) || Character.isWhitespace(string.charAt(string.length() - 1))) {
            statusInfo.setError(PreferencesMessages.getString("TodoTaskInputDialog.error.noSpace"));
        }
        this.updateStatus(statusInfo);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        WorkbenchHelp.setHelp((Control)shell, (String)"org.eclipse.cdt.ui.todo_task_input_dialog_context");
    }

    private class CompilerTodoTaskInputAdapter
    implements IDialogFieldListener {
        CompilerTodoTaskInputAdapter() {
        }

        public void dialogFieldChanged(DialogField dialogField) {
            TodoTaskInputDialog.this.doValidation();
        }
    }
}

