/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.preferences.TodoTaskConfigurationBlock;
import org.eclipse.cdt.internal.ui.preferences.TodoTaskPreferencePage;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class TodoTaskPropertyPage
extends PropertyPage {
    private TodoTaskConfigurationBlock fConfigurationBlock;
    private Control fConfigurationBlockControl;
    private ControlEnableState fBlockEnableState = null;
    private SelectionButtonDialogField fUseWorkspaceSettings;
    private SelectionButtonDialogField fChangeWorkspaceSettings;
    private SelectionButtonDialogField fUseProjectSettings;
    private IStatus fBlockStatus = new StatusInfo();
    static /* synthetic */ Class class$0;

    public TodoTaskPropertyPage() {
        IDialogFieldListener iDialogFieldListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField dialogField) {
                TodoTaskPropertyPage.this.doDialogFieldChanged(dialogField);
            }
        };
        this.fUseWorkspaceSettings = new SelectionButtonDialogField(16);
        this.fUseWorkspaceSettings.setDialogFieldListener(iDialogFieldListener);
        this.fUseWorkspaceSettings.setLabelText(PreferencesMessages.getString("TodoTaskPropertyPage.useworkspacesettings.label"));
        this.fChangeWorkspaceSettings = new SelectionButtonDialogField(8);
        this.fChangeWorkspaceSettings.setLabelText(PreferencesMessages.getString("TodoTaskPropertyPage.useworkspacesettings.change"));
        this.fChangeWorkspaceSettings.setDialogFieldListener(iDialogFieldListener);
        this.fUseWorkspaceSettings.attachDialogField(this.fChangeWorkspaceSettings);
        this.fUseProjectSettings = new SelectionButtonDialogField(16);
        this.fUseProjectSettings.setDialogFieldListener(iDialogFieldListener);
        this.fUseProjectSettings.setLabelText(PreferencesMessages.getString("TodoTaskPropertyPage.useprojectsettings.label"));
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.cdt.ui.tasktags_property_page_context");
    }

    protected Control createContents(Composite composite) {
        IStatusChangeListener iStatusChangeListener = new IStatusChangeListener(){

            public void statusChanged(IStatus iStatus) {
                TodoTaskPropertyPage.this.fBlockStatus = iStatus;
                TodoTaskPropertyPage.this.doStatusChanged();
            }
        };
        this.fConfigurationBlock = new TodoTaskConfigurationBlock(iStatusChangeListener, this.getProject());
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        this.fUseWorkspaceSettings.doFillIntoGrid(composite2, 1);
        LayoutUtil.setHorizontalGrabbing((Control)this.fUseWorkspaceSettings.getSelectionButton(null));
        this.fChangeWorkspaceSettings.doFillIntoGrid(composite2, 1);
        GridData gridData = (GridData)this.fChangeWorkspaceSettings.getSelectionButton(null).getLayoutData();
        gridData.horizontalIndent = this.convertWidthInCharsToPixels(3);
        gridData.horizontalAlignment = 1;
        this.fUseProjectSettings.doFillIntoGrid(composite2, 1);
        gridData = new GridData(272);
        gridData.horizontalSpan = 1;
        gridData.horizontalIndent = this.convertWidthInCharsToPixels(2);
        this.fConfigurationBlockControl = this.fConfigurationBlock.createContents(composite2);
        this.fConfigurationBlockControl.setLayoutData((Object)gridData);
        boolean bl = this.fConfigurationBlock.hasProjectSpecificOptions();
        this.fUseProjectSettings.setSelection(bl);
        this.fUseWorkspaceSettings.setSelection(!bl);
        this.updateEnableState();
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private boolean useProjectSettings() {
        return this.fUseProjectSettings.isSelected();
    }

    private void doDialogFieldChanged(DialogField dialogField) {
        if (dialogField == this.fChangeWorkspaceSettings) {
            TodoTaskPreferencePage todoTaskPreferencePage = new TodoTaskPreferencePage();
            this.showPreferencePage("org.eclipse.cdt.ui.propertyPages.TodoTaskPropertyPage", (IPreferencePage)todoTaskPreferencePage);
        } else {
            this.updateEnableState();
            this.doStatusChanged();
        }
    }

    private void doStatusChanged() {
        this.updateStatus((IStatus)(this.useProjectSettings() ? this.fBlockStatus : new StatusInfo()));
    }

    private ICProject getProject() {
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.ICElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ICProject)iAdaptable.getAdapter((Class)clazz);
    }

    private void updateEnableState() {
        if (this.useProjectSettings()) {
            if (this.fBlockEnableState != null) {
                this.fBlockEnableState.restore();
                this.fBlockEnableState = null;
            }
        } else if (this.fBlockEnableState == null) {
            this.fBlockEnableState = ControlEnableState.disable((Control)this.fConfigurationBlockControl);
        }
    }

    protected void performDefaults() {
        if (this.useProjectSettings()) {
            this.fUseProjectSettings.setSelection(false);
            this.fUseWorkspaceSettings.setSelection(true);
            this.fConfigurationBlock.performDefaults();
        }
        super.performDefaults();
    }

    public boolean performOk() {
        return this.fConfigurationBlock.performOk(this.useProjectSettings());
    }

    private void updateStatus(IStatus iStatus) {
        this.setValid(!iStatus.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, iStatus);
    }

    private boolean showPreferencePage(String string, IPreferencePage iPreferencePage) {
        PreferenceNode preferenceNode = new PreferenceNode(string, iPreferencePage);
        PreferenceManager preferenceManager = new PreferenceManager();
        preferenceManager.addToRoot((IPreferenceNode)preferenceNode);
        final PreferenceDialog preferenceDialog = new PreferenceDialog(this.getShell(), preferenceManager);
        boolean[] blArray = new boolean[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable((IPreferenceNode)preferenceNode, blArray){
            private final /* synthetic */ IPreferenceNode val$targetNode;
            private final /* synthetic */ boolean[] val$result;
            {
                this.val$targetNode = iPreferenceNode;
                this.val$result = blArray;
            }

            public void run() {
                preferenceDialog.create();
                preferenceDialog.setMessage(this.val$targetNode.getLabelText());
                this.val$result[0] = preferenceDialog.open() == 0;
            }
        });
        return blArray[0];
    }
}

