/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class WorkInProgressPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button fBackgroundTypeCacheEnabled;
    protected OverlayPreferenceStore fOverlayStore;

    public WorkInProgressPreferencePage() {
        this.setPreferenceStore(CUIPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = this.createOverlayStore();
    }

    private OverlayPreferenceStore createOverlayStore() {
        ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "externMatchEnable"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "externMatchVisible"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "CDT_INDEXER_TIMEOUT"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "enableBackgroundTypeCache"));
        OverlayPreferenceStore.OverlayKey[] overlayKeyArray = new OverlayPreferenceStore.OverlayKey[arrayList.size()];
        arrayList.toArray(overlayKeyArray);
        return new OverlayPreferenceStore(this.getPreferenceStore(), overlayKeyArray);
    }

    protected Control createContents(Composite composite) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText("Open Type");
        this.fBackgroundTypeCacheEnabled = this.createCheckButton((Composite)group, "Cache types in background");
        this.fBackgroundTypeCacheEnabled.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                WorkInProgressPreferencePage.this.fOverlayStore.setValue("enableBackgroundTypeCache", button.getSelection());
            }
        });
        Group group2 = new Group(composite2, 0);
        group2.setLayout((Layout)new GridLayout());
        group2.setLayoutData((Object)new GridData(768));
        group2.setText("Editor");
        this.initialize();
        return composite2;
    }

    private void initialize() {
        this.fBackgroundTypeCacheEnabled.setSelection(this.fOverlayStore.getBoolean("enableBackgroundTypeCache"));
    }

    public void init(IWorkbench iWorkbench) {
    }

    private Combo createComboBox(Composite composite, String string, String[] stringArray, String string2) {
        ControlFactory.createLabel(composite, string);
        Combo combo = ControlFactory.createSelectCombo(composite, stringArray, string2);
        combo.setLayoutData((Object)new GridData());
        return combo;
    }

    private Button createCheckButton(Composite composite, String string) {
        Button button = new Button(composite, 16416);
        button.setText(string);
        GridData gridData = new GridData();
        button.setLayoutData((Object)gridData);
        return button;
    }

    private Control addTextField(Composite composite, String string, String string2, int n, int n2, boolean bl) {
        Label label = new Label(composite, 0);
        label.setText(string);
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = n2;
        label.setLayoutData((Object)gridData);
        Text text = new Text(composite, 2052);
        gridData = new GridData(32);
        gridData.widthHint = this.convertWidthInCharsToPixels(n + 1);
        text.setLayoutData((Object)gridData);
        text.setTextLimit(n);
        return text;
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        Preferences preferences = CCorePlugin.getDefault().getPluginPreferences();
        preferences.setValue("enableBackgroundTypeCache", this.fOverlayStore.getString("enableBackgroundTypeCache"));
        CCorePlugin.getDefault().savePluginPreferences();
        return true;
    }

    public static void initDefaults(IPreferenceStore iPreferenceStore) {
        iPreferenceStore.setDefault("enableBackgroundTypeCache", false);
        Preferences preferences = CCorePlugin.getDefault().getPluginPreferences();
        if (preferences != null) {
            preferences.setValue("enableBackgroundTypeCache", iPreferenceStore.getString("enableBackgroundTypeCache"));
            CCorePlugin.getDefault().savePluginPreferences();
        }
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initialize();
        super.performDefaults();
    }
}

