/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.ICompositeChange;
import org.eclipse.cdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.cdt.internal.ui.refactoring.ChangeElement;
import org.eclipse.cdt.internal.ui.refactoring.DefaultChangeElement;
import org.eclipse.cdt.internal.ui.refactoring.PseudoCChangeElement;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

class ChangeElementContentProvider
implements ITreeContentProvider {
    private static final ChangeElement[] EMPTY_CHILDREN = new ChangeElement[0];

    ChangeElementContentProvider() {
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
    }

    public Object[] getChildren(Object object) {
        ChangeElement changeElement = (ChangeElement)object;
        Object[] objectArray = changeElement.getChildren();
        if (objectArray == null) {
            objectArray = this.createChildren(changeElement);
        }
        return objectArray;
    }

    public Object getParent(Object object) {
        return ((ChangeElement)object).getParent();
    }

    public boolean hasChildren(Object object) {
        Object[] objectArray = this.getChildren(object);
        return objectArray != null && objectArray.length > 0;
    }

    public void dispose() {
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    private ChangeElement[] createChildren(ChangeElement changeElement) {
        ChangeElement[] changeElementArray = EMPTY_CHILDREN;
        if (!(changeElement instanceof DefaultChangeElement)) {
            return changeElementArray;
        }
        DefaultChangeElement defaultChangeElement = (DefaultChangeElement)changeElement;
        IChange iChange = defaultChangeElement.getChange();
        if (iChange instanceof ICompositeChange) {
            IChange[] iChangeArray = ((ICompositeChange)iChange).getChildren();
            changeElementArray = new ChangeElement[iChangeArray.length];
            int n = 0;
            while (n < iChangeArray.length) {
                changeElementArray[n] = new DefaultChangeElement(defaultChangeElement, iChangeArray[n]);
                ++n;
            }
        }
        defaultChangeElement.setChildren(changeElementArray);
        return changeElementArray;
    }

    private TextChange.EditChange[] getSortedTextEditChanges(TextChange textChange) {
        TextChange.EditChange[] editChangeArray = textChange.getTextEditChanges();
        ArrayList<TextChange.EditChange> arrayList = new ArrayList<TextChange.EditChange>(editChangeArray.length);
        int n = 0;
        while (n < editChangeArray.length) {
            if (!editChangeArray[n].isEmpty()) {
                arrayList.add(editChangeArray[n]);
            }
            ++n;
        }
        OffsetComparator offsetComparator = new OffsetComparator();
        Collections.sort(arrayList, offsetComparator);
        return arrayList.toArray(new TextChange.EditChange[arrayList.size()]);
    }

    private PseudoCChangeElement getChangeElement(Map map, ICElement iCElement, List list, ChangeElement changeElement) {
        PseudoCChangeElement pseudoCChangeElement = (PseudoCChangeElement)map.get(iCElement);
        if (pseudoCChangeElement != null) {
            return pseudoCChangeElement;
        }
        ICElement iCElement2 = iCElement.getParent();
        if (iCElement2 instanceof ITranslationUnit) {
            pseudoCChangeElement = new PseudoCChangeElement(changeElement, iCElement);
            list.add(pseudoCChangeElement);
            map.put(iCElement, pseudoCChangeElement);
        } else {
            PseudoCChangeElement pseudoCChangeElement2 = this.getChangeElement(map, iCElement2, list, changeElement);
            pseudoCChangeElement = new PseudoCChangeElement(pseudoCChangeElement2, iCElement);
            pseudoCChangeElement2.addChild(pseudoCChangeElement);
            map.put(iCElement, pseudoCChangeElement);
        }
        return pseudoCChangeElement;
    }

    private ICElement getModifiedCElement(TextChange.EditChange editChange, ITranslationUnit iTranslationUnit) throws CModelException {
        IRegion iRegion = editChange.getTextRange();
        if (iRegion.getOffset() == 0 && iRegion.getLength() == 0) {
            return iTranslationUnit;
        }
        ICElement iCElement = this.getElementAt((IParent)iTranslationUnit, iRegion.getOffset());
        if (iCElement == null) {
            return iTranslationUnit;
        }
        try {
            while (true) {
                ISourceReference iSourceReference = (ISourceReference)iCElement;
                Region region = new Region(iSourceReference.getSourceRange().getStartPos(), iSourceReference.getSourceRange().getLength());
                if (iCElement.getElementType() != 60 && iCElement.getParent() != null && !editChange.coveredBy((IRegion)region)) {
                    iCElement = iCElement.getParent();
                    continue;
                }
                break;
            }
        }
        catch (CModelException cModelException) {
        }
        catch (ClassCastException classCastException) {}
        return iCElement;
    }

    protected ICElement getElementAt(IParent iParent, int n) throws CModelException {
        if (iParent instanceof ISourceReference) {
            ICElement[] iCElementArray = iParent.getChildren();
            int n2 = 0;
            while (n2 < iCElementArray.length) {
                ISourceReference iSourceReference;
                ISourceRange iSourceRange;
                ICElement iCElement = iCElementArray[n2];
                if (iCElement instanceof ISourceReference && n < (iSourceRange = (iSourceReference = (ISourceReference)iCElementArray[n2]).getSourceRange()).getStartPos() + iSourceRange.getLength() && n >= iSourceRange.getStartPos()) {
                    if (iSourceReference instanceof IParent) {
                        return this.getElementAt((IParent)iSourceReference, n);
                    }
                    return (ICElement)iSourceReference;
                }
                ++n2;
            }
        }
        return null;
    }

    private static class OffsetComparator
    implements Comparator {
        OffsetComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            TextChange.EditChange editChange = (TextChange.EditChange)object;
            TextChange.EditChange editChange2 = (TextChange.EditChange)object2;
            int n2 = this.getOffset(editChange);
            if (n2 < (n = this.getOffset(editChange2))) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            return 0;
        }

        private int getOffset(TextChange.EditChange editChange) {
            return editChange.getTextRange().getOffset();
        }
    }
}

