/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.ICompositeChange;
import org.eclipse.cdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.cdt.internal.corext.refactoring.changes.TextFileChange;
import org.eclipse.cdt.internal.corext.refactoring.changes.TranslationUnitChange;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.refactoring.ChangeElement;
import org.eclipse.cdt.internal.ui.refactoring.DefaultChangeElement;
import org.eclipse.cdt.internal.ui.refactoring.PseudoCChangeElement;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.internal.ui.refactoring.TextEditChangeElement;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;

class ChangeElementLabelProvider
extends LabelProvider {
    private int fCElementFlags;
    private CElementLabelProvider fCElementLabelProvider;
    private Map fDescriptorImageMap = new HashMap();
    private boolean fShowQualification = true;

    public ChangeElementLabelProvider(int n) {
        this.fCElementFlags = n;
        this.fCElementLabelProvider = new CElementLabelProvider(n);
    }

    public void setShowQualification(boolean bl) {
        this.fShowQualification = bl;
        LabelProviderChangedEvent labelProviderChangedEvent = new LabelProviderChangedEvent((IBaseLabelProvider)this, null);
        this.fireLabelProviderChanged(labelProviderChangedEvent);
    }

    public Image getImage(Object object) {
        if (object instanceof DefaultChangeElement) {
            IChange iChange = ((DefaultChangeElement)object).getChange();
            return this.doGetImage(iChange);
        }
        if (object instanceof TextEditChangeElement) {
            TextChange.EditChange editChange = ((TextEditChangeElement)object).getTextEditChange();
            return this.doGetImage(editChange);
        }
        if (object instanceof PseudoCChangeElement) {
            PseudoCChangeElement pseudoCChangeElement = (PseudoCChangeElement)object;
            return this.fCElementLabelProvider.getImage(pseudoCChangeElement.getCElement());
        }
        return super.getImage(object);
    }

    public String getText(Object object) {
        if (object instanceof DefaultChangeElement) {
            IChange iChange = ((DefaultChangeElement)object).getChange();
            if (!this.fShowQualification) {
                return iChange.getName();
            }
            if (iChange instanceof TextFileChange) {
                IFile iFile = ((TextFileChange)iChange).getFile();
                return RefactoringMessages.getFormattedString("PreviewWizardPage.changeElementLabelProvider.textFormat", new String[]{iFile.getName(), this.getPath(iFile)});
            }
            return iChange.getName();
        }
        if (object instanceof TextEditChangeElement) {
            ChangeElement changeElement;
            TextEditChangeElement textEditChangeElement = (TextEditChangeElement)object;
            String string = textEditChangeElement.getTextEditChange().getName();
            if ((this.fCElementFlags & 0x800) != 0 && (changeElement = this.getParent(textEditChangeElement)) != null) {
                string = RefactoringMessages.getFormattedString("PreviewWizardPage.changeElementLabelProvider.textFormatEdit", new String[]{this.getText(changeElement), string});
            }
            return string;
        }
        if (object instanceof PseudoCChangeElement) {
            PseudoCChangeElement pseudoCChangeElement = (PseudoCChangeElement)object;
            return this.fCElementLabelProvider.getText(pseudoCChangeElement.getCElement());
        }
        return super.getText(object);
    }

    public void dispose() {
        Iterator iterator = this.fDescriptorImageMap.values().iterator();
        while (iterator.hasNext()) {
            Image image = (Image)iterator.next();
            image.dispose();
        }
        super.dispose();
    }

    private Image doGetImage(Object object) {
        Image image;
        ImageDescriptor imageDescriptor = null;
        if (imageDescriptor == null) {
            imageDescriptor = object instanceof ICompositeChange ? CPluginImages.DESC_OBJS_COMPOSITE_CHANGE : (object instanceof TextEditChangeElement ? CPluginImages.DESC_OBJS_TEXT_EDIT : (object instanceof TranslationUnitChange ? CPluginImages.DESC_OBJS_CU_CHANGE : (object instanceof TextFileChange ? CPluginImages.DESC_OBJS_FILE_CHANGE : CPluginImages.DESC_OBJS_DEFAULT_CHANGE)));
        }
        if ((image = (Image)this.fDescriptorImageMap.get(imageDescriptor)) == null) {
            image = imageDescriptor.createImage();
            this.fDescriptorImageMap.put(imageDescriptor, image);
        }
        return image;
    }

    private String getPath(IFile iFile) {
        StringBuffer stringBuffer = new StringBuffer(iFile.getProject().getName());
        String string = iFile.getParent().getProjectRelativePath().toString();
        if (string.length() > 0) {
            stringBuffer.append('/');
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private ChangeElement getParent(TextEditChangeElement textEditChangeElement) {
        ChangeElement changeElement = textEditChangeElement.getParent();
        while (changeElement != null && !(changeElement instanceof PseudoCChangeElement) && !(changeElement instanceof DefaultChangeElement)) {
            changeElement = changeElement.getParent();
        }
        return changeElement;
    }
}

