/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import org.eclipse.cdt.internal.ui.refactoring.ChangeElement;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

class ChangeElementTreeViewer
extends CheckboxTreeViewer {
    public ChangeElementTreeViewer(Composite composite) {
        super(composite, 0);
        this.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                ChangeElement changeElement = (ChangeElement)checkStateChangedEvent.getElement();
                boolean bl = checkStateChangedEvent.getChecked();
                changeElement.setActive(bl);
                ChangeElementTreeViewer.this.setSubtreeChecked(changeElement, bl);
                ChangeElementTreeViewer.this.setSubtreeGrayed(changeElement, false);
                ChangeElement changeElement2 = changeElement.getParent();
                while (changeElement2 != null) {
                    int n = changeElement2.getActive();
                    boolean bl2 = n == 1;
                    ChangeElementTreeViewer.this.setChecked(changeElement2, bl ? true : bl2);
                    ChangeElementTreeViewer.this.setGrayed(changeElement2, bl2);
                    changeElement2 = changeElement2.getParent();
                }
            }
        });
    }

    protected void inputChanged(Object object, Object object2) {
        super.inputChanged(object, object2);
        this.initializeChildren((ChangeElement)object);
    }

    protected void doUpdateItem(Item item, Object object) {
        super.doUpdateItem(item, object);
        TreeItem treeItem = (TreeItem)item;
        ChangeElement changeElement = (ChangeElement)object;
        int n = changeElement.getActive();
        boolean bl = n != 0;
        treeItem.setChecked(bl);
        boolean bl2 = n == 1;
        treeItem.setGrayed(bl2);
    }

    protected void revealNext() {
        this.revealElement(true);
    }

    protected void revealPrevious() {
        this.revealElement(false);
    }

    private void initializeChildren(ChangeElement changeElement) {
        if (changeElement == null) {
            return;
        }
        ChangeElement[] changeElementArray = changeElement.getChildren();
        if (changeElementArray == null) {
            return;
        }
        int n = 0;
        while (n < changeElementArray.length) {
            boolean bl;
            boolean bl2;
            ChangeElement changeElement2 = changeElementArray[n];
            int n2 = changeElement2.getActive();
            boolean bl3 = bl2 = n2 != 0;
            if (bl2) {
                this.setChecked(changeElement2, bl2);
            }
            boolean bl4 = bl = n2 == 1;
            if (bl) {
                this.setGrayed(changeElement2, bl);
            }
            ++n;
        }
    }

    private void setSubtreeGrayed(Object object, boolean bl) {
        TreeItem treeItem;
        Widget widget = this.findItem(object);
        if (widget instanceof TreeItem && (treeItem = (TreeItem)widget).getGrayed() != bl) {
            treeItem.setGrayed(bl);
            this.grayChildren(this.getChildren((Widget)treeItem), bl);
        }
    }

    private void grayChildren(Item[] itemArray, boolean bl) {
        int n = 0;
        while (n < itemArray.length) {
            TreeItem treeItem;
            Item item = itemArray[n];
            if (item instanceof TreeItem && (treeItem = (TreeItem)item).getGrayed() != bl) {
                treeItem.setGrayed(bl);
                this.grayChildren(this.getChildren((Widget)treeItem), bl);
            }
            ++n;
        }
    }

    private void revealElement(boolean bl) {
        ChangeElement changeElement;
        ChangeElement changeElement2;
        ChangeElement changeElement3 = (ChangeElement)this.getInput();
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getSelection();
        if (!iStructuredSelection.isEmpty()) {
            changeElement3 = (ChangeElement)iStructuredSelection.iterator().next();
        }
        if ((changeElement2 = this.getLeaf(changeElement3, bl)) == null && (changeElement2 = this.getElement(changeElement3, bl)) != null && (changeElement = this.getLeaf(changeElement2, bl)) != null) {
            changeElement2 = changeElement;
        }
        if (changeElement2 != null) {
            this.setSelection((ISelection)new StructuredSelection((Object)changeElement2), true);
        } else {
            this.getControl().getDisplay().beep();
        }
    }

    private ChangeElement getLeaf(ChangeElement changeElement, boolean bl) {
        ChangeElement changeElement2 = null;
        ChangeElement[] changeElementArray = changeElement.getChildren();
        while (changeElementArray != null && changeElementArray.length > 0) {
            changeElement2 = changeElementArray[bl ? 0 : changeElementArray.length - 1];
            changeElementArray = changeElement2.getChildren();
        }
        return changeElement2;
    }

    private ChangeElement getElement(ChangeElement changeElement, boolean bl) {
        ChangeElement changeElement2;
        while ((changeElement2 = changeElement.getParent()) != null) {
            ChangeElement changeElement3 = this.getSibling(changeElement2.getChildren(), changeElement, bl);
            if (changeElement3 != null) {
                return changeElement3;
            }
            changeElement = changeElement2;
        }
        return null;
    }

    private ChangeElement getSibling(ChangeElement[] changeElementArray, ChangeElement changeElement, boolean bl) {
        int n = 0;
        while (n < changeElementArray.length) {
            if (changeElementArray[n] == changeElement) {
                if (bl) {
                    if (n < changeElementArray.length - 1) {
                        return changeElementArray[n + 1];
                    }
                    return null;
                }
                if (n > 0) {
                    return changeElementArray[n - 1];
                }
                return null;
            }
            ++n;
        }
        return null;
    }
}

