/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import org.eclipse.cdt.internal.corext.refactoring.base.ChangeAbortException;
import org.eclipse.cdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.IChangeExceptionHandler;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ChangeExceptionHandler
implements IChangeExceptionHandler {
    private Shell fParent;

    public ChangeExceptionHandler(Shell shell) {
        Assert.isNotNull((Object)shell);
        this.fParent = shell;
    }

    public void handle(ChangeContext changeContext, IChange iChange, Exception exception) {
        CUIPlugin.getDefault().log(exception);
        Object object = null;
        object = exception instanceof CoreException ? ((CoreException)((Object)exception)).getStatus() : (exception.getMessage() == null ? new Status(4, CUIPlugin.getPluginId(), 4, RefactoringMessages.getString("ChangeExceptionHandler.no_details"), (Throwable)exception) : new Status(4, CUIPlugin.getPluginId(), 4, exception.getMessage(), (Throwable)exception));
        final RefactorErrorDialog refactorErrorDialog = new RefactorErrorDialog(this.fParent, RefactoringMessages.getString("ChangeExceptionHandler.refactoring"), RefactoringMessages.getFormattedString("ChangeExceptionHandler.unexpected_exception", new String[]{iChange.getName()}), (IStatus)object, 7);
        final int[] nArray = new int[1];
        Runnable runnable = new Runnable(){

            public void run() {
                nArray[0] = refactorErrorDialog.open();
            }
        };
        this.fParent.getDisplay().syncExec(runnable);
        switch (nArray[0]) {
            case 0: {
                changeContext.setTryToUndo();
            }
            case 1: {
                throw new ChangeAbortException(exception);
            }
        }
    }

    private static class RefactorErrorDialog
    extends ErrorDialog {
        public RefactorErrorDialog(Shell shell, String string, String string2, IStatus iStatus, int n) {
            super(shell, string, string2, iStatus, n);
        }

        protected void createButtonsForButtonBar(Composite composite) {
            super.createButtonsForButtonBar(composite);
            Button button = this.getButton(0);
            button.setText(RefactoringMessages.getString("ChangeExceptionHandler.undo"));
            Button button2 = this.createButton(composite, 1, RefactoringMessages.getString("ChangeExceptionHandler.abort"), true);
            button2.moveBelow((Control)button);
            button2.setFocus();
        }

        protected Control createMessageArea(Composite composite) {
            Control control = super.createMessageArea(composite);
            new Label(composite, 0);
            Label label = new Label(composite, 0);
            label.setText(RefactoringMessages.getString("ChangeExceptionHandler.button_explanation"));
            label.setLayoutData((Object)new GridData(768));
            Dialog.applyDialogFont((Control)control);
            return control;
        }
    }
}

