/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.internal.ui.refactoring.CheckConditionsOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;

public class CreateChangeOperation
implements IRunnableWithProgress {
    private Refactoring fRefactoring;
    private int fStyle;
    private int fCheckPassedSeverity;
    private IChange fChange;
    private RefactoringStatus fStatus;
    public static final int CHECK_NONE = 0;
    public static final int CHECK_ACTIVATION = 2;
    public static final int CHECK_INPUT = 4;
    public static final int CHECK_PRECONDITION = 6;
    private static final int LAST = 8;

    public CreateChangeOperation(Refactoring refactoring, int n) {
        Assert.isNotNull((Object)refactoring);
        this.fRefactoring = refactoring;
        this.fStyle = n;
        Assert.isTrue((boolean)this.checkStyle(this.fStyle));
        this.fCheckPassedSeverity = 3;
    }

    public CreateChangeOperation(Refactoring refactoring, int n, int n2) {
        Assert.isNotNull((Object)refactoring);
        this.fRefactoring = refactoring;
        this.fStyle = n;
        Assert.isTrue((boolean)this.checkStyle(this.fStyle));
        this.setCheckPassedSeverity(n2);
    }

    public void setCheckPassedSeverity(int n) {
        this.fCheckPassedSeverity = n;
        Assert.isTrue((this.fCheckPassedSeverity < 4 ? 1 : 0) != 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
        this.fChange = null;
        this.fStatus = null;
        try {
            block8: {
                try {
                    this.fChange = null;
                    if (this.fStyle != 0) {
                        iProgressMonitor.beginTask("", 5);
                        iProgressMonitor.subTask("");
                        CheckConditionsOperation checkConditionsOperation = new CheckConditionsOperation(this.fRefactoring, this.fStyle);
                        checkConditionsOperation.run((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 4, 4));
                        this.fStatus = checkConditionsOperation.getStatus();
                        if (this.fStatus != null && this.fStatus.getSeverity() <= this.fCheckPassedSeverity) {
                            this.fChange = this.fRefactoring.createChange((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1, 4));
                            break block8;
                        } else {
                            iProgressMonitor.worked(1);
                        }
                        break block8;
                    }
                    this.fChange = this.fRefactoring.createChange(iProgressMonitor);
                }
                catch (CModelException cModelException) {
                    throw new InvocationTargetException(cModelException);
                }
            }
            Object var3_6 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
    }

    public IChange getChange() {
        return this.fChange;
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    public int getConditionCheckingStyle() {
        return this.fStyle;
    }

    public void setConditionCheckingStyle(int n) {
        Assert.isTrue((boolean)this.checkStyle(n));
        this.fStyle = n;
    }

    private boolean checkStyle(int n) {
        return n < 8;
    }
}

