/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.ICompositeChange;
import org.eclipse.cdt.internal.ui.refactoring.ChangeElement;
import org.eclipse.cdt.internal.ui.refactoring.IChangePreviewViewer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.Assert;

class DefaultChangeElement
extends ChangeElement {
    private IChange fChange;
    private ChangeElement[] fChildren;

    public DefaultChangeElement(ChangeElement changeElement, IChange iChange) {
        super(changeElement);
        this.fChange = iChange;
        Assert.isNotNull((Object)this.fChange);
    }

    public IChange getChange() {
        return this.fChange;
    }

    public void feedInput(IChangePreviewViewer iChangePreviewViewer) throws CoreException {
        iChangePreviewViewer.setInput(this.fChange);
    }

    public void setActive(boolean bl) {
        this.fChange.setActive(bl);
    }

    public int getActive() {
        if (this.fChange instanceof ICompositeChange) {
            return this.getCompositeChangeActive();
        }
        return this.getDefaultChangeActive();
    }

    public ChangeElement[] getChildren() {
        return this.fChildren;
    }

    public void setChildren(ChangeElement[] changeElementArray) {
        Assert.isNotNull((Object)changeElementArray);
        this.fChildren = changeElementArray;
    }

    private int getDefaultChangeActive() {
        int n;
        int n2 = n = this.fChange.isActive() ? 2 : 0;
        if (this.fChildren != null) {
            int n3 = 0;
            while (n3 < this.fChildren.length) {
                n = ChangeElement.ACTIVATION_TABLE[this.fChildren[n3].getActive()][n];
                if (n == 1) break;
                ++n3;
            }
        }
        return n;
    }

    private int getCompositeChangeActive() {
        if (this.fChildren != null && this.fChildren.length > 0) {
            int n = this.fChildren[0].getActive();
            int n2 = 1;
            while (n2 < this.fChildren.length) {
                n = ChangeElement.ACTIVATION_TABLE[this.fChildren[n2].getActive()][n];
                if (n == 1) break;
                ++n2;
            }
            return n;
        }
        return 2;
    }
}

