/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.internal.ui.refactoring.CreateChangeOperation;
import org.eclipse.cdt.internal.ui.refactoring.PerformChangeOperation;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringStatusViewer;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

class ErrorWizardPage
extends RefactoringWizardPage {
    public static final String PAGE_NAME = "ErrorPage";
    private RefactoringStatus fStatus;
    private RefactoringStatusViewer fViewer;

    public ErrorWizardPage() {
        super(PAGE_NAME);
    }

    public void setStatus(RefactoringStatus refactoringStatus) {
        this.fStatus = refactoringStatus;
        if (this.fStatus != null) {
            this.setPageComplete(this.isRefactoringPossible());
            int n = this.fStatus.getSeverity();
            if (n >= 4) {
                this.setDescription(RefactoringMessages.getString("ErrorWizardPage.cannot_proceed"));
            } else if (n >= 1) {
                this.setDescription(RefactoringMessages.getString("ErrorWizardPage.confirm"));
            } else {
                this.setDescription("");
            }
        } else {
            this.setPageComplete(true);
            this.setDescription("");
        }
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        this.fViewer = new RefactoringStatusViewer(composite, 0);
        this.setControl((Control)this.fViewer);
        Dialog.applyDialogFont((Control)this.fViewer);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.cdt.ui.refactoring_error_wizard_page_context");
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.fViewer.setStatus(this.fStatus);
        }
        super.setVisible(bl);
    }

    public boolean canFlipToNextPage() {
        return this.fStatus != null && this.isRefactoringPossible() && this.isPageComplete() && super.getNextPage() != null;
    }

    public IWizardPage getNextPage() {
        RefactoringWizard refactoringWizard = this.getRefactoringWizard();
        IChange iChange = refactoringWizard.getChange();
        if (iChange == null) {
            iChange = refactoringWizard.createChange(0, 3, false);
            refactoringWizard.setChange(iChange);
        }
        if (iChange == null) {
            return this;
        }
        return super.getNextPage();
    }

    protected boolean performFinish() {
        RefactoringWizard refactoringWizard = this.getRefactoringWizard();
        IChange iChange = refactoringWizard.getChange();
        PerformChangeOperation performChangeOperation = null;
        if (iChange != null) {
            performChangeOperation = new PerformChangeOperation(iChange);
        } else {
            CreateChangeOperation createChangeOperation = new CreateChangeOperation(this.getRefactoring(), 0);
            createChangeOperation.setCheckPassedSeverity(3);
            performChangeOperation = new PerformChangeOperation(createChangeOperation);
            performChangeOperation.setCheckPassedSeverity(3);
        }
        return refactoringWizard.performFinish(performChangeOperation);
    }

    private boolean isRefactoringPossible() {
        return this.fStatus.getSeverity() < 4;
    }
}

