/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.internal.corext.refactoring.base.ChangeAbortException;
import org.eclipse.cdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.internal.ui.refactoring.CreateChangeOperation;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.IEditorPart;

public class PerformChangeOperation
implements IRunnableWithProgress {
    private IChange fChange;
    private ChangeContext fChangeContext;
    private CreateChangeOperation fCreateChangeOperation;
    private int fCheckPassedSeverity;
    private boolean fChangeExecuted;
    static /* synthetic */ Class class$0;

    public PerformChangeOperation(IChange iChange) {
        this.fChange = iChange;
        Assert.isNotNull((Object)this.fChange);
    }

    public PerformChangeOperation(CreateChangeOperation createChangeOperation) {
        this.fCreateChangeOperation = createChangeOperation;
        Assert.isNotNull((Object)this.fCreateChangeOperation);
        this.fCheckPassedSeverity = 1;
    }

    public boolean changeExecuted() {
        return this.fChangeExecuted;
    }

    public IChange getChange() {
        return this.fChange;
    }

    public RefactoringStatus getStatus() {
        return this.fCreateChangeOperation != null ? this.fCreateChangeOperation.getStatus() : null;
    }

    public void setCheckPassedSeverity(int n) {
        this.fCheckPassedSeverity = n;
        Assert.isTrue((this.fCheckPassedSeverity < 4 ? 1 : 0) != 0);
    }

    public void setChangeContext(ChangeContext changeContext) {
        this.fChangeContext = changeContext;
        Assert.isNotNull((Object)this.fChangeContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            block8: {
                try {
                    this.fChangeExecuted = false;
                    if (this.createChange()) {
                        iProgressMonitor.beginTask("", 2);
                        this.fCreateChangeOperation.run((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1, 4));
                        this.fChange = this.fCreateChangeOperation.getChange();
                        RefactoringStatus refactoringStatus = this.fCreateChangeOperation.getStatus();
                        int n = this.fCreateChangeOperation.getConditionCheckingStyle();
                        if (this.fChange != null && (n == 0 || refactoringStatus != null && refactoringStatus.getSeverity() <= this.fCheckPassedSeverity)) {
                            this.executeChange((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1, 4));
                            this.fChangeExecuted = true;
                            break block8;
                        } else {
                            iProgressMonitor.worked(1);
                        }
                        break block8;
                    }
                    this.executeChange(iProgressMonitor);
                    this.fChangeExecuted = true;
                }
                catch (CoreException coreException) {
                    throw new InvocationTargetException(coreException);
                }
            }
            Object var4_7 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeChange(IProgressMonitor iProgressMonitor) throws CoreException {
        Assert.isNotNull((Object)this.fChangeContext);
        IRewriteTarget[] iRewriteTargetArray = null;
        try {
            iRewriteTargetArray = PerformChangeOperation.getRewriteTargets();
            PerformChangeOperation.beginCompoundChange(iRewriteTargetArray);
            this.fChange.aboutToPerform(this.fChangeContext, (IProgressMonitor)new NullProgressMonitor());
            IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    try {
                        PerformChangeOperation.this.fChange.perform(PerformChangeOperation.this.fChangeContext, iProgressMonitor);
                    }
                    catch (ChangeAbortException changeAbortException) {
                        throw new CoreException((IStatus)new Status(4, CUIPlugin.getPluginId(), 10004, RefactoringMessages.getString("PerformChangeOperation.unrecoverable_error"), (Throwable)changeAbortException));
                    }
                }
            };
            CoreModel.run((IWorkspaceRunnable)iWorkspaceRunnable, (IProgressMonitor)iProgressMonitor);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.fChange.performed();
            if (iRewriteTargetArray == null) throw throwable;
            PerformChangeOperation.endCompoundChange(iRewriteTargetArray);
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.fChange.performed();
            if (iRewriteTargetArray == null) return;
        }
        PerformChangeOperation.endCompoundChange(iRewriteTargetArray);
    }

    private boolean createChange() {
        return this.fCreateChangeOperation != null;
    }

    private static void beginCompoundChange(IRewriteTarget[] iRewriteTargetArray) {
        int n = 0;
        while (n < iRewriteTargetArray.length) {
            iRewriteTargetArray[n].beginCompoundChange();
            ++n;
        }
    }

    private static void endCompoundChange(IRewriteTarget[] iRewriteTargetArray) {
        int n = 0;
        while (n < iRewriteTargetArray.length) {
            iRewriteTargetArray[n].endCompoundChange();
            ++n;
        }
    }

    private static IRewriteTarget[] getRewriteTargets() {
        IEditorPart[] iEditorPartArray = CUIPlugin.getInstanciatedEditors();
        ArrayList<IRewriteTarget> arrayList = new ArrayList<IRewriteTarget>(iEditorPartArray.length);
        int n = 0;
        while (n < iEditorPartArray.length) {
            IRewriteTarget iRewriteTarget;
            IEditorPart iEditorPart = iEditorPartArray[n];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.jface.text.IRewriteTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iRewriteTarget = (IRewriteTarget)iEditorPart.getAdapter((Class)clazz)) != null) {
                arrayList.add(iRewriteTarget);
            }
            ++n;
        }
        return arrayList.toArray(new IRewriteTarget[arrayList.size()]);
    }
}

