/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.internal.corext.refactoring.base.ChangeAbortException;
import org.eclipse.cdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.IUndoManager;
import org.eclipse.cdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.cdt.internal.ui.refactoring.AbortChangeExceptionHandler;
import org.eclipse.cdt.internal.ui.refactoring.ChangeExceptionHandler;
import org.eclipse.cdt.internal.ui.refactoring.PerformChangeOperation;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class PerformRefactoringUtil {
    private PerformRefactoringUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean performRefactoring(PerformChangeOperation performChangeOperation, Refactoring refactoring, IRunnableContext iRunnableContext, Shell shell) {
        ChangeContext changeContext = new ChangeContext(new ChangeExceptionHandler(shell));
        boolean bl = false;
        IUndoManager iUndoManager = Refactoring.getUndoManager();
        try {
            block9: {
                try {
                    performChangeOperation.setChangeContext(changeContext);
                    iUndoManager.aboutToPerformRefactoring();
                    iRunnableContext.run(false, false, (IRunnableWithProgress)performChangeOperation);
                    if (!performChangeOperation.changeExecuted()) break block9;
                    if (!performChangeOperation.getChange().isUndoable()) {
                        bl = false;
                    } else {
                        iUndoManager.addUndo(refactoring.getName(), performChangeOperation.getChange().getUndoChange());
                        bl = true;
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    IStatus iStatus;
                    Throwable throwable = invocationTargetException.getTargetException();
                    if (throwable instanceof CoreException && (iStatus = ((CoreException)throwable).getStatus()) != null && iStatus.getCode() == 10004 && iStatus.getPlugin().equals(iStatus.getPlugin())) {
                        bl = PerformRefactoringUtil.handleChangeAbortException(iRunnableContext, changeContext);
                        Object var10_10 = null;
                        changeContext.clearPerformedChanges();
                        iUndoManager.refactoringPerformed(bl);
                        return true;
                    }
                    PerformRefactoringUtil.handleUnexpectedException(invocationTargetException);
                    Object var10_11 = null;
                    changeContext.clearPerformedChanges();
                    iUndoManager.refactoringPerformed(bl);
                    return false;
                }
                catch (InterruptedException interruptedException) {
                    Object var10_12 = null;
                    changeContext.clearPerformedChanges();
                    iUndoManager.refactoringPerformed(bl);
                    return false;
                }
            }
            Object var10_14 = null;
            changeContext.clearPerformedChanges();
            iUndoManager.refactoringPerformed(bl);
            return true;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            changeContext.clearPerformedChanges();
            iUndoManager.refactoringPerformed(bl);
            throw throwable;
        }
    }

    private static boolean handleChangeAbortException(IRunnableContext iRunnableContext, final ChangeContext changeContext) {
        if (!changeContext.getTryToUndo()) {
            return false;
        }
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor iProgressMonitor) throws InterruptedException, InvocationTargetException {
                try {
                    try {
                        CoreModel.run((IWorkspaceRunnable)new IWorkspaceRunnable(this, changeContext){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ ChangeContext val$context;
                            {
                                this.this$1 = var1_1;
                                this.val$context = changeContext;
                            }

                            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                                ChangeContext changeContext = new ChangeContext(new AbortChangeExceptionHandler());
                                IChange[] iChangeArray = this.val$context.getPerformedChanges();
                                iProgressMonitor.beginTask(RefactoringMessages.getString("RefactoringWizard.undoing"), iChangeArray.length);
                                NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
                                int n = iChangeArray.length - 1;
                                while (n >= 0) {
                                    IChange iChange = iChangeArray[n];
                                    iProgressMonitor.subTask(iChange.getName());
                                    iChange.getUndoChange().perform(changeContext, (IProgressMonitor)nullProgressMonitor);
                                    iProgressMonitor.worked(1);
                                    --n;
                                }
                            }
                        }, (IProgressMonitor)iProgressMonitor);
                    }
                    catch (ChangeAbortException changeAbortException) {
                        throw new InvocationTargetException(changeAbortException.getThrowable());
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                }
                iProgressMonitor.done();
            }
        };
        try {
            iRunnableContext.run(false, false, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            PerformRefactoringUtil.handleUnexpectedException(invocationTargetException);
            return false;
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    private static void handleUnexpectedException(InvocationTargetException invocationTargetException) {
        ExceptionHandler.handle(invocationTargetException, RefactoringMessages.getString("RefactoringWizard.refactoring"), RefactoringMessages.getString("RefactoringWizard.unexpected_exception_1"));
    }
}

