/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import org.eclipse.cdt.internal.corext.refactoring.base.Change;
import org.eclipse.cdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.ICompositeChange;
import org.eclipse.cdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.cdt.internal.ui.refactoring.ChangeElement;
import org.eclipse.cdt.internal.ui.refactoring.ChangeElementContentProvider;
import org.eclipse.cdt.internal.ui.refactoring.ChangeElementLabelProvider;
import org.eclipse.cdt.internal.ui.refactoring.ChangeElementTreeViewer;
import org.eclipse.cdt.internal.ui.refactoring.DefaultChangeElement;
import org.eclipse.cdt.internal.ui.refactoring.IChangePreviewViewer;
import org.eclipse.cdt.internal.ui.refactoring.IPreviewWizardPage;
import org.eclipse.cdt.internal.ui.refactoring.PerformChangeOperation;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringWizardPage;
import org.eclipse.cdt.internal.ui.util.ViewerPane;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.PageBook;

public class PreviewWizardPage
extends RefactoringWizardPage
implements IPreviewWizardPage {
    private IChange fChange;
    private ChangeElement fCurrentSelection;
    private PageBook fPageContainer;
    private Control fStandardPage;
    private Control fNullPage;
    private ChangeElementTreeViewer fTreeViewer;

    public PreviewWizardPage() {
        super("PreviewPage");
        this.setDescription(RefactoringMessages.getString("PreviewWizardPage.description"));
    }

    public void setChange(IChange iChange) {
        if (this.fChange == iChange) {
            return;
        }
        this.fChange = iChange;
        this.setTreeViewerInput();
    }

    protected ChangeElementTreeViewer createTreeViewer(Composite composite) {
        return new ChangeElementTreeViewer(composite);
    }

    protected ITreeContentProvider createTreeContentProvider() {
        return new ChangeElementContentProvider();
    }

    protected ILabelProvider createTreeLabelProvider() {
        return new ChangeElementLabelProvider(CElementLabelProvider.SHOW_DEFAULT | 0x100);
    }

    protected boolean performFinish() {
        return this.getRefactoringWizard().performFinish(new PerformChangeOperation(this.fChange));
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        this.fPageContainer = new PageBook(composite, 0);
        this.fStandardPage = this.createStandardPreviewPage((Composite)this.fPageContainer);
        this.fNullPage = this.createNullPage((Composite)this.fPageContainer);
        this.setControl((Control)this.fPageContainer);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.cdt.ui.refactoring_preview_wizard_page_context");
    }

    private Composite createStandardPreviewPage(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        SashForm sashForm = new SashForm(composite2, 256);
        ViewerPane viewerPane = new ViewerPane((Composite)sashForm, 0x800800);
        viewerPane.setText(RefactoringMessages.getString("PreviewWizardPage.changes"));
        ToolBarManager toolBarManager = viewerPane.getToolBarManager();
        toolBarManager.add((IAction)new NextChange());
        toolBarManager.add((IAction)new PreviousChange());
        toolBarManager.update(true);
        this.fTreeViewer = this.createTreeViewer((Composite)viewerPane);
        this.fTreeViewer.setContentProvider((IContentProvider)this.createTreeContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.createTreeLabelProvider());
        this.fTreeViewer.addSelectionChangedListener(this.createSelectionChangedListener());
        this.fTreeViewer.addCheckStateListener(this.createCheckStateListener());
        viewerPane.setContent(this.fTreeViewer.getControl());
        this.setTreeViewerInput();
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(80);
        sashForm.setLayoutData((Object)gridData);
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private Control createNullPage(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0x1000000);
        label.setText(RefactoringMessages.getString("PreviewWizardPage.no_source_code_change"));
        label.setLayoutData((Object)new GridData(768));
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    public void setVisible(boolean bl) {
        this.fCurrentSelection = null;
        if (this.hasChanges()) {
            ITreeContentProvider iTreeContentProvider;
            Object[] objectArray;
            IStructuredSelection iStructuredSelection;
            this.fPageContainer.showPage(this.fStandardPage);
            ChangeElement changeElement = (ChangeElement)this.fTreeViewer.getInput();
            if (bl && changeElement != null && (iStructuredSelection = (IStructuredSelection)this.fTreeViewer.getSelection()).isEmpty() && (objectArray = (iTreeContentProvider = (ITreeContentProvider)this.fTreeViewer.getContentProvider()).getElements((Object)changeElement)) != null && objectArray.length > 0) {
                Object[] objectArray2;
                Object object = objectArray[0];
                if (this.getRefactoringWizard().getExpandFirstNode() && (objectArray2 = iTreeContentProvider.getElements(object)) != null && objectArray2.length > 0) {
                    this.fTreeViewer.expandToLevel(object, 999);
                }
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection(object));
            }
            super.setVisible(bl);
            this.fTreeViewer.getControl().setFocus();
        } else {
            this.fPageContainer.showPage(this.fNullPage);
            super.setVisible(bl);
        }
        this.getRefactoringWizard().setPreviewShown(bl);
    }

    private void setTreeViewerInput() {
        IChange iChange = this.computeChangeInput();
        DefaultChangeElement defaultChangeElement = iChange == null ? null : (iChange instanceof ICompositeChange && !(iChange instanceof TextChange) ? new DefaultChangeElement(null, iChange) : new DefaultChangeElement(null, new DummyRootNode(iChange)));
        if (this.fTreeViewer != null) {
            this.fTreeViewer.setInput(defaultChangeElement);
        }
    }

    private IChange computeChangeInput() {
        IChange iChange = this.fChange;
        if (iChange == null) {
            return iChange;
        }
        while (iChange instanceof ICompositeChange) {
            IChange[] iChangeArray = ((ICompositeChange)iChange).getChildren();
            if (iChangeArray.length == 1) {
                iChange = iChangeArray[0];
                continue;
            }
            return iChange;
        }
        return iChange;
    }

    private ICheckStateListener createCheckStateListener() {
        return new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                ChangeElement changeElement = (ChangeElement)checkStateChangedEvent.getElement();
                if (this.isChild(PreviewWizardPage.this.fCurrentSelection, changeElement) || this.isChild(changeElement, PreviewWizardPage.this.fCurrentSelection)) {
                    PreviewWizardPage.this.showPreview(PreviewWizardPage.this.fCurrentSelection);
                }
            }

            private boolean isChild(ChangeElement changeElement, ChangeElement changeElement2) {
                while (changeElement2 != null) {
                    if (changeElement2 == changeElement) {
                        return true;
                    }
                    changeElement2 = changeElement2.getParent();
                }
                return false;
            }
        };
    }

    private ISelectionChangedListener createSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                if (iStructuredSelection.size() == 1) {
                    ChangeElement changeElement = (ChangeElement)iStructuredSelection.getFirstElement();
                    if (changeElement != PreviewWizardPage.this.fCurrentSelection) {
                        PreviewWizardPage.this.fCurrentSelection = changeElement;
                        PreviewWizardPage.this.showPreview(changeElement);
                    }
                } else {
                    PreviewWizardPage.this.showPreview(null);
                }
            }
        };
    }

    private void showPreview(ChangeElement changeElement) {
        this.showNullPreviewer();
    }

    private void showNullPreviewer() {
    }

    public boolean hasChanges() {
        if (this.fChange == null) {
            return false;
        }
        if (this.fChange instanceof ICompositeChange) {
            return ((ICompositeChange)this.fChange).getChildren().length > 0;
        }
        return true;
    }

    private static class DummyRootNode
    extends Change
    implements ICompositeChange {
        private IChange[] fChildren;

        public DummyRootNode(IChange iChange) {
            this.fChildren = new IChange[]{iChange};
        }

        public IChange[] getChildren() {
            return this.fChildren;
        }

        public String getName() {
            return null;
        }

        public Object getModifiedLanguageElement() {
            return null;
        }

        public IChange getUndoChange() {
            return null;
        }

        public void perform(ChangeContext changeContext, IProgressMonitor iProgressMonitor) {
        }
    }

    private static class NullPreviewer
    implements IChangePreviewViewer {
        private Label fLabel;

        NullPreviewer() {
        }

        public void createControl(Composite composite) {
            this.fLabel = new Label(composite, 0x1800000);
            this.fLabel.setText(RefactoringMessages.getString("PreviewWizardPage.no_preview"));
        }

        public void refresh() {
        }

        public Control getControl() {
            return this.fLabel;
        }

        public void setInput(Object object) throws CoreException {
        }
    }

    private class NextChange
    extends Action {
        public NextChange() {
            this.setImageDescriptor(CompareUI.DESC_ETOOL_NEXT);
            this.setDisabledImageDescriptor(CompareUI.DESC_DTOOL_NEXT);
            this.setHoverImageDescriptor(CompareUI.DESC_CTOOL_NEXT);
            this.setToolTipText(RefactoringMessages.getString("PreviewWizardPage.next_Change"));
            WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.cdt.ui.next_change_action");
        }

        public void run() {
            PreviewWizardPage.this.fTreeViewer.revealNext();
        }
    }

    private class PreviousChange
    extends Action {
        public PreviousChange() {
            this.setImageDescriptor(CompareUI.DESC_ETOOL_PREV);
            this.setDisabledImageDescriptor(CompareUI.DESC_DTOOL_PREV);
            this.setHoverImageDescriptor(CompareUI.DESC_CTOOL_PREV);
            this.setToolTipText(RefactoringMessages.getString("PreviewWizardPage.previous_Change"));
            WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.cdt.ui.previous_change_action");
        }

        public void run() {
            PreviewWizardPage.this.fTreeViewer.revealPrevious();
        }
    }
}

