/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.cdt.internal.ui.refactoring.ChangeElement;
import org.eclipse.cdt.internal.ui.refactoring.DefaultChangeElement;
import org.eclipse.cdt.internal.ui.refactoring.IChangePreviewViewer;
import org.eclipse.cdt.internal.ui.refactoring.TextChangePreviewViewer;
import org.eclipse.cdt.internal.ui.refactoring.TextEditChangeElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.Assert;

class PseudoCChangeElement
extends ChangeElement {
    private ICElement fCElement;
    private List fChildren;

    public PseudoCChangeElement(ChangeElement changeElement, ICElement iCElement) {
        super(changeElement);
        this.fCElement = iCElement;
        Assert.isNotNull((Object)this.fCElement);
    }

    public ICElement getCElement() {
        return this.fCElement;
    }

    public void feedInput(IChangePreviewViewer iChangePreviewViewer) throws CoreException {
        DefaultChangeElement defaultChangeElement = this.getStandardChangeElement();
        if (defaultChangeElement != null) {
            IChange iChange = defaultChangeElement.getChange();
            if (iChange instanceof TextChange) {
                List list = this.collectTextEditChanges();
                iChangePreviewViewer.setInput(TextChangePreviewViewer.createInput(list.toArray(new TextChange.EditChange[list.size()]), this.getTextRange()));
            }
        } else {
            iChangePreviewViewer.setInput(null);
        }
    }

    public void setActive(boolean bl) {
        Iterator iterator = this.fChildren.iterator();
        while (iterator.hasNext()) {
            ChangeElement changeElement = (ChangeElement)iterator.next();
            changeElement.setActive(bl);
        }
    }

    public int getActive() {
        Assert.isTrue((this.fChildren.size() > 0 ? 1 : 0) != 0);
        int n = ((ChangeElement)this.fChildren.get(0)).getActive();
        int n2 = 1;
        while (n2 < this.fChildren.size()) {
            ChangeElement changeElement = (ChangeElement)this.fChildren.get(n2);
            n = ChangeElement.ACTIVATION_TABLE[changeElement.getActive()][n];
            if (n == 1) break;
            ++n2;
        }
        return n;
    }

    public ChangeElement[] getChildren() {
        if (this.fChildren == null) {
            return ChangeElement.EMPTY_CHILDREN;
        }
        return this.fChildren.toArray(new ChangeElement[this.fChildren.size()]);
    }

    public void addChild(TextEditChangeElement textEditChangeElement) {
        this.doAddChild(textEditChangeElement);
    }

    public void addChild(PseudoCChangeElement pseudoCChangeElement) {
        this.doAddChild(pseudoCChangeElement);
    }

    private void doAddChild(ChangeElement changeElement) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList(2);
        }
        this.fChildren.add(changeElement);
    }

    private DefaultChangeElement getStandardChangeElement() {
        ChangeElement changeElement = this.getParent();
        while (!(changeElement instanceof DefaultChangeElement) && changeElement != null) {
            changeElement = changeElement.getParent();
        }
        return (DefaultChangeElement)changeElement;
    }

    private List collectTextEditChanges() {
        ArrayList<TextChange.EditChange> arrayList = new ArrayList<TextChange.EditChange>(10);
        ChangeElement[] changeElementArray = this.getChildren();
        int n = 0;
        while (n < changeElementArray.length) {
            ChangeElement changeElement = changeElementArray[n];
            if (changeElement instanceof TextEditChangeElement) {
                arrayList.add(((TextEditChangeElement)changeElement).getTextEditChange());
            } else if (changeElement instanceof PseudoCChangeElement) {
                arrayList.addAll(((PseudoCChangeElement)changeElement).collectTextEditChanges());
            }
            ++n;
        }
        return arrayList;
    }

    public IRegion getTextRange() throws CoreException {
        ISourceRange iSourceRange = ((ISourceReference)this.fCElement).getSourceRange();
        return new Region(iSourceRange.getStartPos(), iSourceRange.getLength());
    }
}

