/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class RefactoringPreferences {
    public static final String PREF_ERROR_PAGE_SEVERITY_THRESHOLD = "Refactoring.ErrorPage.severityThreshold";
    public static final String PREF_SAVE_ALL_EDITORS = "Refactoring.savealleditors";

    public static int getCheckPassedSeverity() {
        String string = CUIPlugin.getDefault().getPreferenceStore().getString(PREF_ERROR_PAGE_SEVERITY_THRESHOLD);
        try {
            return Integer.valueOf(string) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            return 3;
        }
    }

    public static int getStopSeverity() {
        switch (RefactoringPreferences.getCheckPassedSeverity()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
        }
        return 4;
    }

    public static boolean getSaveAllEditors() {
        IPreferenceStore iPreferenceStore = CUIPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getBoolean(PREF_SAVE_ALL_EDITORS);
    }

    public static void setSaveAllEditors(boolean bl) {
        IPreferenceStore iPreferenceStore = CUIPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setValue(PREF_SAVE_ALL_EDITORS, bl);
    }
}

