/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.Arrays;
import org.eclipse.cdt.internal.ui.refactoring.ListDialog;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringPreferences;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.internal.ui.viewsupport.ListContentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.GlobalBuildAction;

public class RefactoringSaveHelper {
    private boolean fFilesSaved;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveEditors(Shell shell) {
        IEditorPart[] iEditorPartArray = CUIPlugin.getDirtyEditors();
        if (iEditorPartArray.length == 0) {
            return true;
        }
        if (!this.saveAllDirtyEditors(shell)) {
            return false;
        }
        try {
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription iWorkspaceDescription = iWorkspace.getDescription();
            boolean bl = iWorkspaceDescription.isAutoBuilding();
            iWorkspaceDescription.setAutoBuilding(false);
            iWorkspace.setDescription(iWorkspaceDescription);
            try {
                CUIPlugin.getActiveWorkbenchWindow().getWorkbench().saveAllEditors(false);
                this.fFilesSaved = true;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                iWorkspaceDescription.setAutoBuilding(bl);
                iWorkspace.setDescription(iWorkspaceDescription);
                throw throwable;
            }
            {
                Object var6_9 = null;
            }
            iWorkspaceDescription.setAutoBuilding(bl);
            iWorkspace.setDescription(iWorkspaceDescription);
            return true;
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, shell, RefactoringMessages.getString("RefactoringStarter.saving"), RefactoringMessages.getString("RefactoringStarter.unexpected_exception"));
            return false;
        }
    }

    public void triggerBuild() {
        if (this.fFilesSaved && ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding()) {
            new GlobalBuildAction(CUIPlugin.getActiveWorkbenchWindow(), 10).run();
        }
    }

    private boolean saveAllDirtyEditors(Shell shell) {
        if (RefactoringPreferences.getSaveAllEditors()) {
            return true;
        }
        ListDialog listDialog = new ListDialog(shell){

            protected Control createDialogArea(Composite composite) {
                Composite composite2 = (Composite)super.createDialogArea(composite);
                Button button = new Button(composite2, 32);
                button.setText(RefactoringMessages.getString("RefactoringStarter.always_save"));
                button.setSelection(RefactoringPreferences.getSaveAllEditors());
                button.addSelectionListener((SelectionListener)new SelectionAdapter(this, button){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ Button val$check;
                    {
                        this.this$1 = var1_1;
                        this.val$check = button;
                    }

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        RefactoringPreferences.setSaveAllEditors(this.val$check.getSelection());
                    }
                });
                Dialog.applyDialogFont((Control)composite2);
                return composite2;
            }
        };
        listDialog.setTitle(RefactoringMessages.getString("RefactoringStarter.save_all_resources"));
        listDialog.setAddCancelButton(true);
        listDialog.setLabelProvider(this.createDialogLabelProvider());
        listDialog.setMessage(RefactoringMessages.getString("RefactoringStarter.must_save"));
        listDialog.setContentProvider(new ListContentProvider());
        listDialog.setInput(Arrays.asList(CUIPlugin.getDirtyEditors()));
        return listDialog.open() == 0;
    }

    private ILabelProvider createDialogLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object object) {
                return ((IEditorPart)object).getTitleImage();
            }

            public String getText(Object object) {
                return ((IEditorPart)object).getTitle();
            }
        };
    }
}

