/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.internal.ui.refactoring.CheckConditionsOperation;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringErrorDialogUtil;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringWizardDialog;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringWizardDialog2;
import org.eclipse.cdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Shell;

public class RefactoringStarter {
    private RefactoringSaveHelper fSaveHelper = new RefactoringSaveHelper();

    public Object activate(Refactoring refactoring, RefactoringWizard refactoringWizard, Shell shell, String string, boolean bl) throws CModelException {
        if (!this.canActivate(bl, shell)) {
            return null;
        }
        RefactoringStatus refactoringStatus = this.checkActivation(refactoring);
        if (refactoringStatus.hasFatalError()) {
            return RefactoringErrorDialogUtil.open(string, refactoringStatus, shell);
        }
        refactoringWizard.setActivationStatus(refactoringStatus);
        Object object = refactoringWizard.hasMultiPageUserInput() ? new RefactoringWizardDialog(shell, refactoringWizard) : new RefactoringWizardDialog2(shell, refactoringWizard);
        if (object.open() == 1) {
            this.fSaveHelper.triggerBuild();
        }
        return null;
    }

    private RefactoringStatus checkActivation(Refactoring refactoring) {
        try {
            CheckConditionsOperation checkConditionsOperation = new CheckConditionsOperation(refactoring, 2);
            BusyIndicatorRunnableContext busyIndicatorRunnableContext = new BusyIndicatorRunnableContext();
            busyIndicatorRunnableContext.run(false, false, checkConditionsOperation);
            return checkConditionsOperation.getStatus();
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, "Error", RefactoringMessages.getString("RefactoringStarter.unexpected_exception"));
            return RefactoringStatus.createFatalErrorStatus(RefactoringMessages.getString("RefactoringStarter.unexpected_exception"));
        }
        catch (InterruptedException interruptedException) {
            Assert.isTrue((boolean)false);
            return null;
        }
    }

    private boolean canActivate(boolean bl, Shell shell) {
        return !bl || this.fSaveHelper.saveEditors(shell);
    }
}

