/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.internal.ui.refactoring.ErrorWizardPage;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringStatusViewer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

class RefactoringStatusDialog
extends Dialog {
    private RefactoringStatus fStatus;
    private String fWindowTitle;
    private boolean fBackButton;

    public RefactoringStatusDialog(Shell shell, RefactoringStatus refactoringStatus, String string, boolean bl) {
        super(shell);
        this.fStatus = refactoringStatus;
        this.fWindowTitle = string;
        this.fBackButton = bl;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public RefactoringStatusDialog(Shell shell, ErrorWizardPage errorWizardPage, boolean bl) {
        this(shell, errorWizardPage.getStatus(), shell.getText(), bl);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.fWindowTitle);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.initializeDialogUnits((Control)composite2);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 600;
        gridData.heightHint = 400;
        composite2.setLayoutData((Object)gridData);
        Color color = composite.getDisplay().getSystemColor(29);
        ViewForm viewForm = new ViewForm(composite2, 0x800800);
        viewForm.marginWidth = gridLayout.marginWidth;
        viewForm.marginHeight = gridLayout.marginHeight;
        gridData = new GridData(768);
        Rectangle rectangle = viewForm.computeTrim(0, 0, 0, this.convertHeightInCharsToPixels(2) + viewForm.marginHeight * 2);
        gridData.heightHint = rectangle.height;
        viewForm.setLayoutData((Object)gridData);
        viewForm.setBackground(color);
        Label label = new Label((Composite)viewForm, 16448);
        if (this.fStatus.hasFatalError()) {
            label.setText(RefactoringMessages.getString("RefactoringStatusDialog.Cannot_proceed"));
        } else {
            label.setText(RefactoringMessages.getString("RefactoringStatusDialog.Please_look"));
        }
        label.setBackground(color);
        viewForm.setContent((Control)label);
        RefactoringStatusViewer refactoringStatusViewer = new RefactoringStatusViewer(composite2, 0);
        refactoringStatusViewer.setLayoutData(new GridData(1808));
        refactoringStatusViewer.setStatus(this.fStatus);
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected void buttonPressed(int n) {
        if (n == 14) {
            this.setReturnCode(14);
            this.close();
        } else {
            super.buttonPressed(n);
        }
    }

    protected void createButtonsForButtonBar(Composite composite) {
        if (!this.fStatus.hasFatalError()) {
            if (this.fBackButton) {
                this.createButton(composite, 14, IDialogConstants.BACK_LABEL, false);
            }
            this.createButton(composite, 0, RefactoringMessages.getString("RefactoringStatusDialog.Continue"), true);
            this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        } else {
            if (this.fBackButton) {
                this.createButton(composite, 14, IDialogConstants.BACK_LABEL, true);
            }
            this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }
}

