/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.List;
import org.eclipse.cdt.internal.corext.refactoring.base.Context;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatusEntry;
import org.eclipse.cdt.internal.ui.refactoring.IStatusContextViewer;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringStatusContentProvider;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringStatusEntryLabelProvider;
import org.eclipse.cdt.internal.ui.refactoring.StatusContextViewerDescriptor;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.internal.ui.util.ViewerPane;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.part.PageBook;

class RefactoringStatusViewer
extends SashForm {
    private RefactoringStatus fStatus;
    private TableViewer fTableViewer;
    private PageBook fContextViewerContainer;
    private ViewerPane fContextViewerPane;
    private Image fPaneImage;
    private StatusContextViewerDescriptor fCurrentDescriptor;
    private IStatusContextViewer fCurrentContextViewer;
    private NullContextViewer fNullContextViewer;
    private NextProblem fNextProblem;
    private PreviousProblem fPreviousProblem;
    static /* synthetic */ Class class$0;

    public RefactoringStatusViewer(Composite composite, int n) {
        super(composite, n | 0x200);
        this.createContents();
    }

    public void setStatus(RefactoringStatus refactoringStatus) {
        this.fStatus = refactoringStatus;
        if (this.fTableViewer.getInput() != this.fStatus) {
            RefactoringStatusEntry refactoringStatusEntry;
            this.fTableViewer.setInput((Object)this.fStatus);
            this.fTableViewer.getTable().getColumn(0).pack();
            ISelection iSelection = this.fTableViewer.getSelection();
            if (iSelection.isEmpty() && (refactoringStatusEntry = this.getFirstEntry()) != null) {
                this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)refactoringStatusEntry));
                this.showContextViewer(refactoringStatusEntry);
                this.fTableViewer.getControl().setFocus();
            }
            this.fNextProblem.update();
            this.fPreviousProblem.update();
        }
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        PixelConverter pixelConverter = new PixelConverter((Control)this);
        return new Point(pixelConverter.convertWidthInCharsToPixels(90), pixelConverter.convertHeightInCharsToPixels(25));
    }

    private void createContents() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        ViewerPane viewerPane = new ViewerPane((Composite)this, 0x800800);
        viewerPane.setText(RefactoringMessages.getString("RefactoringStatusViewer.Found_problems"));
        ToolBarManager toolBarManager = viewerPane.getToolBarManager();
        this.fNextProblem = new NextProblem();
        toolBarManager.add((IAction)this.fNextProblem);
        this.fPreviousProblem = new PreviousProblem();
        toolBarManager.add((IAction)this.fPreviousProblem);
        toolBarManager.update(true);
        this.createTableViewer((Composite)viewerPane);
        viewerPane.setContent(this.fTableViewer.getControl());
        this.fContextViewerPane = new ViewerPane((Composite)this, 0x800800);
        this.fContextViewerContainer = new PageBook((Composite)this.fContextViewerPane, 0);
        this.fNullContextViewer = new NullContextViewer();
        this.fNullContextViewer.createControl((Composite)this.fContextViewerContainer);
        this.fContextViewerContainer.showPage(this.fNullContextViewer.getControl());
        this.fCurrentContextViewer = this.fNullContextViewer;
        this.fContextViewerPane.setContent((Control)this.fContextViewerContainer);
        this.fCurrentContextViewer = this.fNullContextViewer;
        this.fCurrentDescriptor = null;
        this.setWeights(new int[]{35, 65});
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (RefactoringStatusViewer.this.fPaneImage != null) {
                    RefactoringStatusViewer.this.fPaneImage.dispose();
                    RefactoringStatusViewer.this.fPaneImage = null;
                }
            }
        });
    }

    private void createTableViewer(Composite composite) {
        this.fTableViewer = new TableViewer(new Table(composite, 260));
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new RefactoringStatusEntryLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new RefactoringStatusContentProvider());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                RefactoringStatusViewer.this.entrySelected(selectionChangedEvent.getSelection());
                RefactoringStatusViewer.this.fNextProblem.update();
                RefactoringStatusViewer.this.fPreviousProblem.update();
            }
        });
        this.fTableViewer.setSorter((ViewerSorter)new RefactoringStatusSorter());
        Table table = this.fTableViewer.getTable();
        GridData gridData = new GridData(1808);
        table.setLayoutData((Object)gridData);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setResizable(false);
    }

    private void entrySelected(ISelection iSelection) {
        if (!(iSelection instanceof IStructuredSelection)) {
            return;
        }
        Object object = ((IStructuredSelection)iSelection).getFirstElement();
        if (!(object instanceof RefactoringStatusEntry)) {
            return;
        }
        RefactoringStatusEntry refactoringStatusEntry = (RefactoringStatusEntry)object;
        this.updateTitle(refactoringStatusEntry);
        this.showContextViewer(refactoringStatusEntry);
    }

    private void updateTitle(RefactoringStatusEntry refactoringStatusEntry) {
        IAdaptable iAdaptable = RefactoringStatusViewer.getCorrespondingElement(refactoringStatusEntry);
        String string = null;
        ImageDescriptor imageDescriptor = null;
        if (iAdaptable != null) {
            IWorkbenchAdapter iWorkbenchAdapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iWorkbenchAdapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                string = iWorkbenchAdapter.getLabel((Object)iAdaptable);
                imageDescriptor = iWorkbenchAdapter.getImageDescriptor((Object)iAdaptable);
            }
        }
        if (string == null || string.length() == 0) {
            string = RefactoringMessages.getString("RefactoringStatusViewer.Problem_context");
        }
        this.fContextViewerPane.setText(string);
        if (imageDescriptor != null) {
            if (this.fPaneImage != null) {
                this.fPaneImage.dispose();
                this.fPaneImage = null;
            }
            this.fPaneImage = imageDescriptor.createImage((Device)this.fContextViewerPane.getDisplay());
            this.fContextViewerPane.setImage(this.fPaneImage);
        }
    }

    private static IAdaptable getCorrespondingElement(RefactoringStatusEntry refactoringStatusEntry) {
        if (refactoringStatusEntry.getContext() == null) {
            return null;
        }
        return refactoringStatusEntry.getContext().getCorrespondingElement();
    }

    private void showContextViewer(RefactoringStatusEntry refactoringStatusEntry) {
    }

    private void showNullContextViewer() {
        this.fCurrentContextViewer = this.fNullContextViewer;
        this.fCurrentDescriptor = null;
        this.fContextViewerContainer.showPage(this.fCurrentContextViewer.getControl());
    }

    private RefactoringStatusEntry getFirstEntry() {
        if (this.fStatus == null || this.fStatus.getEntries().isEmpty()) {
            return null;
        }
        return (RefactoringStatusEntry)this.fStatus.getEntries().get(0);
    }

    private void revealElement(boolean bl) {
        List list = this.fStatus.getEntries();
        if (list.isEmpty()) {
            return;
        }
        int n = this.fTableViewer.getTable().getSelectionIndex();
        int n2 = list.size() - 1;
        boolean bl2 = true;
        if (n == -1) {
            n = 0;
        } else if (bl && n < n2) {
            ++n;
        } else if (!bl && n > 0) {
            --n;
        } else {
            bl2 = false;
        }
        if (bl2) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection(list.get(n)));
        }
    }

    private static class NullContextViewer
    implements IStatusContextViewer {
        private Label fLabel;

        public void createControl(Composite composite) {
            this.fLabel = new Label(composite, 0x1800000);
            this.fLabel.setText(RefactoringMessages.getString("ErrorWizardPage.no_context_information_available"));
        }

        public void setInput(Context context) {
        }

        public Control getControl() {
            return this.fLabel;
        }
    }

    private class NextProblem
    extends Action {
        public NextProblem() {
            this.setImageDescriptor(CompareUI.DESC_ETOOL_NEXT);
            this.setDisabledImageDescriptor(CompareUI.DESC_DTOOL_NEXT);
            this.setHoverImageDescriptor(CompareUI.DESC_CTOOL_NEXT);
            this.setToolTipText(RefactoringMessages.getString("ErrorWizardPage.next_Change"));
            WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.cdt.ui.next_problem_action");
        }

        public void run() {
            RefactoringStatusViewer.this.revealElement(true);
        }

        public void update() {
            boolean bl = false;
            List list = null;
            if (RefactoringStatusViewer.this.fStatus != null && !(list = RefactoringStatusViewer.this.fStatus.getEntries()).isEmpty()) {
                int n = RefactoringStatusViewer.this.fTableViewer.getTable().getSelectionIndex();
                bl = n == -1 || n < list.size() - 1;
            }
            this.setEnabled(bl);
        }
    }

    private class PreviousProblem
    extends Action {
        public PreviousProblem() {
            this.setImageDescriptor(CompareUI.DESC_ETOOL_PREV);
            this.setDisabledImageDescriptor(CompareUI.DESC_DTOOL_PREV);
            this.setHoverImageDescriptor(CompareUI.DESC_CTOOL_PREV);
            this.setToolTipText(RefactoringMessages.getString("ErrorWizardPage.previous_Change"));
            WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.cdt.ui.previous_problem_action");
        }

        public void run() {
            RefactoringStatusViewer.this.revealElement(false);
        }

        public void update() {
            boolean bl = false;
            if (RefactoringStatusViewer.this.fStatus != null && !RefactoringStatusViewer.this.fStatus.getEntries().isEmpty()) {
                int n = RefactoringStatusViewer.this.fTableViewer.getTable().getSelectionIndex();
                bl = n == -1 || n > 0;
            }
            this.setEnabled(bl);
        }
    }

    private static class RefactoringStatusSorter
    extends ViewerSorter {
        RefactoringStatusSorter() {
        }

        public int compare(Viewer viewer, Object object, Object object2) {
            int n;
            int n2 = ((RefactoringStatusEntry)object).getSeverity();
            if (n2 < (n = ((RefactoringStatusEntry)object2).getSeverity())) {
                return 1;
            }
            if (n < n2) {
                return -1;
            }
            return 0;
        }
    }
}

