/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.internal.corext.Assert;
import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.internal.ui.refactoring.CheckConditionsOperation;
import org.eclipse.cdt.internal.ui.refactoring.CreateChangeOperation;
import org.eclipse.cdt.internal.ui.refactoring.ErrorWizardPage;
import org.eclipse.cdt.internal.ui.refactoring.IPreviewWizardPage;
import org.eclipse.cdt.internal.ui.refactoring.PerformChangeOperation;
import org.eclipse.cdt.internal.ui.refactoring.PerformRefactoringUtil;
import org.eclipse.cdt.internal.ui.refactoring.PreviewWizardPage;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringWizardPage;
import org.eclipse.cdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.PlatformUI;

public class RefactoringWizard
extends Wizard {
    private String fDefaultPageTitle;
    private Refactoring fRefactoring;
    private IChange fChange;
    private RefactoringStatus fActivationStatus = new RefactoringStatus();
    private RefactoringStatus fStatus;
    private boolean fHasUserInputPages;
    private boolean fExpandFirstNode;
    private boolean fIsChangeCreationCancelable;
    private boolean fPreviewReview;
    private boolean fPreviewShown;

    public RefactoringWizard(Refactoring refactoring) {
        this();
        Assert.isNotNull(refactoring);
        this.fRefactoring = refactoring;
    }

    public RefactoringWizard(Refactoring refactoring, String string) {
        this(refactoring);
        Assert.isNotNull(string);
        this.fDefaultPageTitle = string;
    }

    public RefactoringWizard() {
        this.setNeedsProgressMonitor(true);
        this.setChangeCreationCancelable(true);
        this.setWindowTitle(RefactoringMessages.getString("RefactoringWizard.title"));
    }

    public void initialize(Refactoring refactoring) {
        Assert.isNotNull(refactoring);
        this.fRefactoring = refactoring;
    }

    public void setDefaultPageTitle(String string) {
        this.fDefaultPageTitle = string;
    }

    public void setChangeCreationCancelable(boolean bl) {
        this.fIsChangeCreationCancelable = bl;
    }

    protected boolean checkActivationOnOpen() {
        return false;
    }

    protected void addUserInputPages() {
    }

    protected void addErrorPage() {
        this.addPage((IWizardPage)new ErrorWizardPage());
    }

    protected void addPreviewPage() {
        this.addPage(new PreviewWizardPage());
    }

    public boolean hasMultiPageUserInput() {
        return false;
    }

    protected int getMessageLineWidthInChars() {
        return 80;
    }

    protected boolean hasUserInputPages() {
        return this.fHasUserInputPages;
    }

    protected boolean hasPreviewPage() {
        return true;
    }

    protected boolean yesNoStyle() {
        return false;
    }

    public Refactoring getRefactoring() {
        return this.fRefactoring;
    }

    public void setChange(IChange iChange) {
        IPreviewWizardPage iPreviewWizardPage = (IPreviewWizardPage)this.getPage("PreviewPage");
        if (iPreviewWizardPage != null) {
            iPreviewWizardPage.setChange(iChange);
        }
        this.fChange = iChange;
    }

    public IChange getChange() {
        return this.fChange;
    }

    public void setStatus(RefactoringStatus refactoringStatus) {
        ErrorWizardPage errorWizardPage = (ErrorWizardPage)this.getPage("ErrorPage");
        if (errorWizardPage != null) {
            errorWizardPage.setStatus(refactoringStatus);
        }
        this.fStatus = refactoringStatus;
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    public void setInputStatus(RefactoringStatus refactoringStatus) {
        RefactoringStatus refactoringStatus2 = new RefactoringStatus();
        if (this.fActivationStatus != null) {
            refactoringStatus2.merge(this.fActivationStatus);
        }
        refactoringStatus2.merge(refactoringStatus);
        this.setStatus(refactoringStatus2);
    }

    public void setActivationStatus(RefactoringStatus refactoringStatus) {
        this.fActivationStatus = refactoringStatus;
        this.setStatus(refactoringStatus);
    }

    public RefactoringStatus getActivationStatus() {
        return this.fActivationStatus;
    }

    public String getDefaultPageTitle() {
        return this.fDefaultPageTitle;
    }

    public void setExpandFirstNode(boolean bl) {
        this.fExpandFirstNode = true;
    }

    public boolean getExpandFirstNode() {
        return this.fExpandFirstNode;
    }

    public IWizardPage computeUserInputSuccessorPage(IWizardPage iWizardPage) {
        return this.computeUserInputSuccessorPage(iWizardPage, (IRunnableContext)this.getContainer());
    }

    private IWizardPage computeUserInputSuccessorPage(IWizardPage iWizardPage, IRunnableContext iRunnableContext) {
        IChange iChange = this.createChange(4, 0, true, iRunnableContext);
        RefactoringStatus refactoringStatus = this.getStatus();
        if (iChange == null && refactoringStatus == null) {
            this.setChange(iChange);
            return iWizardPage;
        }
        if (!refactoringStatus.hasFatalError()) {
            this.setChange(iChange);
        }
        if (refactoringStatus.isOK()) {
            return this.getPage("PreviewPage");
        }
        return this.getPage("ErrorPage");
    }

    private void initializeDefaultPageTitles() {
        if (this.fDefaultPageTitle == null) {
            return;
        }
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = 0;
        while (n < iWizardPageArray.length) {
            IWizardPage iWizardPage = iWizardPageArray[n];
            if (iWizardPage.getTitle() == null) {
                iWizardPage.setTitle(this.fDefaultPageTitle);
            }
            ++n;
        }
    }

    public void setPreviewReview(boolean bl) {
        this.fPreviewReview = bl;
        this.getContainer().updateButtons();
    }

    public void setPreviewShown(boolean bl) {
        this.fPreviewShown = bl;
        this.getContainer().updateButtons();
    }

    public boolean canFinish() {
        if (this.fPreviewReview && !this.fPreviewShown) {
            return false;
        }
        return super.canFinish();
    }

    IChange createChange(int n, int n2, boolean bl) {
        return this.createChange(n, n2, bl, (IRunnableContext)this.getContainer());
    }

    private IChange createChange(int n, int n2, boolean bl, IRunnableContext iRunnableContext) {
        Object object;
        CreateChangeOperation createChangeOperation = new CreateChangeOperation(this.fRefactoring, n);
        createChangeOperation.setCheckPassedSeverity(n2);
        InvocationTargetException invocationTargetException = null;
        try {
            iRunnableContext.run(true, this.fIsChangeCreationCancelable, (IRunnableWithProgress)createChangeOperation);
        }
        catch (InterruptedException interruptedException) {
            this.setStatus(null);
            return null;
        }
        catch (InvocationTargetException invocationTargetException2) {
            invocationTargetException = invocationTargetException2;
        }
        if (bl) {
            object = null;
            if (invocationTargetException != null) {
                object = new RefactoringStatus();
                String string = invocationTargetException.getMessage();
                if (string != null) {
                    ((RefactoringStatus)object).addFatalError(RefactoringMessages.getFormattedString("RefactoringWizard.see_log", string));
                } else {
                    ((RefactoringStatus)object).addFatalError(RefactoringMessages.getString("RefactoringWizard.Internal_error"));
                }
                CUIPlugin.getDefault().log(invocationTargetException);
            } else {
                object = createChangeOperation.getStatus();
            }
            this.setStatus((RefactoringStatus)object, n);
        } else if (invocationTargetException != null) {
            ExceptionHandler.handle(invocationTargetException, RefactoringMessages.getString("RefactoringWizard.refactoring"), RefactoringMessages.getString("RefactoringWizard.unexpected_exception"));
        }
        object = createChangeOperation.getChange();
        return object;
    }

    public boolean performFinish(PerformChangeOperation performChangeOperation) {
        return PerformRefactoringUtil.performRefactoring(performChangeOperation, this.fRefactoring, (IRunnableContext)this.getContainer(), this.getContainer().getShell());
    }

    public RefactoringStatus checkInput() {
        return this.internalCheckCondition((IRunnableContext)this.getContainer(), 4);
    }

    protected RefactoringStatus internalCheckCondition(IRunnableContext iRunnableContext, int n) {
        CheckConditionsOperation checkConditionsOperation = new CheckConditionsOperation(this.fRefactoring, n);
        Exception exception = null;
        try {
            iRunnableContext.run(true, true, (IRunnableWithProgress)checkConditionsOperation);
        }
        catch (InterruptedException interruptedException) {
            exception = interruptedException;
        }
        catch (InvocationTargetException invocationTargetException) {
            exception = invocationTargetException;
        }
        RefactoringStatus refactoringStatus = null;
        if (exception != null) {
            CUIPlugin.getDefault().log(exception);
            refactoringStatus = new RefactoringStatus();
            refactoringStatus.addFatalError(RefactoringMessages.getString("RefactoringWizard.internal_error_1"));
        } else {
            refactoringStatus = checkConditionsOperation.getStatus();
        }
        this.setStatus(refactoringStatus, n);
        return refactoringStatus;
    }

    protected void setStatus(RefactoringStatus refactoringStatus, int n) {
        if ((n & 6) == 6) {
            this.setStatus(refactoringStatus);
        } else if ((n & 2) == 2) {
            this.setActivationStatus(refactoringStatus);
        } else if ((n & 4) == 4) {
            this.setInputStatus(refactoringStatus);
        }
    }

    public boolean performFinish() {
        Assert.isNotNull(this.fRefactoring);
        RefactoringWizardPage refactoringWizardPage = (RefactoringWizardPage)this.getContainer().getCurrentPage();
        return refactoringWizardPage.performFinish();
    }

    public IWizardPage getPreviousPage(IWizardPage iWizardPage) {
        if (this.fHasUserInputPages) {
            return super.getPreviousPage(iWizardPage);
        }
        if (!iWizardPage.getName().equals("ErrorPage") && this.fStatus.isOK()) {
            return null;
        }
        return super.getPreviousPage(iWizardPage);
    }

    public IWizardPage getStartingPage() {
        if (this.fHasUserInputPages) {
            return super.getStartingPage();
        }
        return this.computeUserInputSuccessorPage(null, (IRunnableContext)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public void addPages() {
        if (this.checkActivationOnOpen()) {
            this.internalCheckCondition(new BusyIndicatorRunnableContext(), 2);
        }
        if (this.fActivationStatus.hasFatalError()) {
            this.addErrorPage();
            this.setStatus(this.getStatus());
        } else {
            Assert.isTrue(this.getPageCount() == 0);
            this.addUserInputPages();
            if (this.getPageCount() > 0) {
                this.fHasUserInputPages = true;
            }
            this.addErrorPage();
            this.addPreviewPage();
        }
        this.initializeDefaultPageTitles();
    }

    public void addPage(IWizardPage iWizardPage) {
        Assert.isTrue(iWizardPage instanceof RefactoringWizardPage);
        super.addPage(iWizardPage);
    }
}

