/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import org.eclipse.cdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class RefactoringWizardDialog
extends WizardDialog {
    private static final String DIALOG_SETTINGS = "RefactoringWizard";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private IDialogSettings fSettings;
    private boolean fMakeNextButtonDefault;

    public RefactoringWizardDialog(Shell shell, RefactoringWizard refactoringWizard) {
        super(shell, (IWizard)refactoringWizard);
        this.setShellStyle(this.getShellStyle() | 0x10);
        IDialogSettings iDialogSettings = CUIPlugin.getDefault().getDialogSettings();
        refactoringWizard.setDialogSettings(iDialogSettings);
        this.fSettings = iDialogSettings.getSection(DIALOG_SETTINGS);
        if (this.fSettings == null) {
            this.fSettings = new DialogSettings(DIALOG_SETTINGS);
            iDialogSettings.addSection(this.fSettings);
            this.fSettings.put(WIDTH, 600);
            this.fSettings.put(HEIGHT, 400);
        }
        int n = 600;
        int n2 = 400;
        try {
            n = this.fSettings.getInt(WIDTH);
            n2 = this.fSettings.getInt(HEIGHT);
        }
        catch (NumberFormatException numberFormatException) {}
        this.setMinimumPageSize(n, n2);
    }

    protected void finishPressed() {
        IWizardPage iWizardPage = this.getCurrentPage();
        Composite composite = iWizardPage.getControl().getParent();
        Point point = composite.getSize();
        this.fSettings.put(WIDTH, point.x);
        this.fSettings.put(HEIGHT, point.y);
        super.finishPressed();
    }

    public void updateButtons() {
        super.updateButtons();
        if (!this.fMakeNextButtonDefault) {
            return;
        }
        if (this.getShell() == null) {
            return;
        }
        Button button = this.getButton(15);
        if (button.isEnabled()) {
            this.getShell().setDefaultButton(button);
        }
    }

    public void setMakeNextButtonDefault(boolean bl) {
        this.fMakeNextButtonDefault = bl;
    }
}

