/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.refactoring.ErrorWizardPage;
import org.eclipse.cdt.internal.ui.refactoring.PreviewWizardPage;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringStatusDialog;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RefactoringWizardDialog2
extends Dialog
implements IWizardContainer {
    private RefactoringWizard fWizard;
    private IWizardPage fCurrentPage;
    private IWizardPage fVisiblePage;
    private PageBook fPageContainer;
    private PageBook fStatusContainer;
    private MessageBox fMessageBox;
    private ProgressMonitorPart fProgressMonitorPart;
    private int fActiveRunningOperations;
    private Cursor fWaitCursor;
    private Cursor fArrowCursor;
    private static final int PREVIEW_ID = 1025;
    private int fPreviewWidth;
    private int fPreviewHeight;
    private IDialogSettings fSettings;
    private static final String DIALOG_SETTINGS = "RefactoringWizard.preview";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final Image INFO = CPluginImages.get("org.eclipse.cdt.ui.info_obj.gif");
    private static final Image WARNING = CPluginImages.get("org.eclipse.cdt.ui.warning_obj.gif");
    private static final Image ERROR = CPluginImages.get("org.eclipse.cdt.ui.error_obj.gif");

    public RefactoringWizardDialog2(Shell shell, RefactoringWizard refactoringWizard) {
        super(shell);
        Assert.isNotNull((Object)((Object)refactoringWizard));
        this.setShellStyle(this.getShellStyle() | 0x10);
        refactoringWizard.setDialogSettings(CUIPlugin.getDefault().getDialogSettings());
        this.fWizard = refactoringWizard;
        this.fWizard.setContainer(this);
        this.fWizard.addPages();
        this.initSize();
    }

    private void initSize() {
        IDialogSettings iDialogSettings = CUIPlugin.getDefault().getDialogSettings();
        this.fSettings = iDialogSettings.getSection(DIALOG_SETTINGS);
        if (this.fSettings == null) {
            this.fSettings = new DialogSettings(DIALOG_SETTINGS);
            iDialogSettings.addSection(this.fSettings);
            this.fSettings.put(WIDTH, 600);
            this.fSettings.put(HEIGHT, 100);
        }
        this.fPreviewWidth = 600;
        this.fPreviewHeight = 100;
        try {
            this.fPreviewWidth = this.fSettings.getInt(WIDTH);
            this.fPreviewHeight = this.fSettings.getInt(HEIGHT);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private void saveSize() {
        if (this.fCurrentPage instanceof PreviewWizardPage) {
            Composite composite = this.fCurrentPage.getControl().getParent();
            Point point = composite.getSize();
            this.fSettings.put(WIDTH, point.x);
            this.fSettings.put(HEIGHT, point.y);
        }
    }

    public void showPage(IWizardPage iWizardPage) {
        this.fCurrentPage = iWizardPage;
    }

    public void updateButtons() {
        Button button;
        boolean bl = this.isPreviewPageActive();
        boolean bl2 = this.fWizard.canFinish();
        boolean bl3 = this.fCurrentPage.canFlipToNextPage();
        Button button2 = this.getButton(1025);
        Button button3 = null;
        if (button2 != null && !button2.isDisposed()) {
            button2.setEnabled(!bl);
            if (!bl) {
                button2.setEnabled(bl3);
            }
            if (button2.isEnabled()) {
                button3 = button2;
            }
        }
        if ((button = this.getButton(0)) != null && !button.isDisposed()) {
            button.setEnabled(bl2);
            if (bl2) {
                button3 = button;
            }
        }
        if (button3 != null) {
            button3.getShell().setDefaultButton(button3);
        }
    }

    public void updateMessage() {
        if (this.fStatusContainer == null || this.fStatusContainer.isDisposed()) {
            return;
        }
        this.fStatusContainer.showPage((Control)this.fMessageBox);
        this.fMessageBox.setMessage(this.fCurrentPage);
    }

    public void updateTitleBar() {
    }

    public void updateWindowTitle() {
        this.getShell().setText(this.fWizard.getWindowTitle());
    }

    public IWizardPage getCurrentPage() {
        return this.fCurrentPage;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(boolean bl, boolean bl2, IRunnableWithProgress iRunnableWithProgress) throws InvocationTargetException, InterruptedException {
        if (this.fProgressMonitorPart == null) {
            ModalContext.run((IRunnableWithProgress)iRunnableWithProgress, (boolean)false, (IProgressMonitor)new NullProgressMonitor(), (Display)this.getShell().getDisplay());
            return;
        }
        Object object = null;
        if (this.fActiveRunningOperations == 0) {
            object = this.aboutToStart(bl && bl2);
        }
        ++this.fActiveRunningOperations;
        try {
            ModalContext.run((IRunnableWithProgress)iRunnableWithProgress, (boolean)bl, (IProgressMonitor)this.fProgressMonitorPart, (Display)this.getShell().getDisplay());
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            --this.fActiveRunningOperations;
            if (object == null) throw throwable;
            this.stopped(object);
            throw throwable;
        }
        {
            Object var5_7 = null;
            --this.fActiveRunningOperations;
            if (object == null) return;
            this.stopped(object);
            return;
        }
    }

    private Object aboutToStart(boolean bl) {
        Map map = null;
        Shell shell = this.getShell();
        if (shell != null) {
            Control control = this.getShell().getDisplay().getFocusControl();
            if (control != null && control.getShell() != this.getShell()) {
                control = null;
            }
            Button button = this.getButton(1);
            Display display = this.getShell().getDisplay();
            this.fWaitCursor = new Cursor((Device)display, 1);
            this.setDisplayCursor(display, this.fWaitCursor);
            this.fArrowCursor = new Cursor((Device)display, 0);
            button.setCursor(this.fArrowCursor);
            boolean bl2 = this.fProgressMonitorPart != null;
            map = this.saveUIState(bl2 && bl);
            if (control != null) {
                map.put("focus", control);
            }
            if (bl2) {
                this.fProgressMonitorPart.attachToCancelComponent((Control)button);
                this.fStatusContainer.showPage((Control)this.fProgressMonitorPart);
            }
            this.fStatusContainer.update();
        }
        return map;
    }

    private Map saveUIState(boolean bl) {
        HashMap<String, ControlEnableState> hashMap = new HashMap<String, ControlEnableState>(10);
        this.saveEnableStateAndSet((Control)this.getButton(1025), hashMap, "preview", false);
        this.saveEnableStateAndSet((Control)this.getButton(0), hashMap, "ok", false);
        this.saveEnableStateAndSet((Control)this.getButton(1), hashMap, "cancel", bl);
        hashMap.put("page", ControlEnableState.disable((Control)this.fVisiblePage.getControl()));
        return hashMap;
    }

    private void saveEnableStateAndSet(Control control, Map map, String string, boolean bl) {
        if (control != null) {
            map.put(string, new Boolean(control.getEnabled()));
            control.setEnabled(bl);
        }
    }

    private void setDisplayCursor(Display display, Cursor cursor) {
        Shell[] shellArray = display.getShells();
        int n = 0;
        while (n < shellArray.length) {
            shellArray[n].setCursor(cursor);
            ++n;
        }
    }

    private void stopped(Object object) {
        Shell shell = this.getShell();
        if (shell != null) {
            Button button = this.getButton(1);
            if (this.fProgressMonitorPart != null) {
                this.fProgressMonitorPart.removeFromCancelComponent((Control)button);
            }
            this.fStatusContainer.showPage((Control)this.fMessageBox);
            Map map = (Map)object;
            this.restoreUIState(map);
            this.setDisplayCursor(shell.getDisplay(), null);
            button.setCursor(null);
            this.fWaitCursor.dispose();
            this.fWaitCursor = null;
            this.fArrowCursor.dispose();
            this.fArrowCursor = null;
            Control control = (Control)map.get("focus");
            if (control != null) {
                control.setFocus();
            }
        }
    }

    private void restoreUIState(Map map) {
        this.restoreEnableState((Control)this.getButton(1025), map, "preview");
        this.restoreEnableState((Control)this.getButton(0), map, "ok");
        this.restoreEnableState((Control)this.getButton(1), map, "cancel");
        ControlEnableState controlEnableState = (ControlEnableState)map.get("page");
        controlEnableState.restore();
    }

    private void restoreEnableState(Control control, Map map, String string) {
        Boolean bl;
        if (control != null && (bl = (Boolean)map.get(string)) != null) {
            control.setEnabled(bl.booleanValue());
        }
    }

    public boolean close() {
        this.fWizard.dispose();
        return super.close();
    }

    protected void cancelPressed() {
        if (this.fActiveRunningOperations == 0 && this.fWizard.performCancel()) {
            super.cancelPressed();
        }
    }

    protected void okPressed() {
        IWizardPage iWizardPage = this.fCurrentPage;
        if (this.fWizard.performFinish()) {
            this.saveSize();
            super.okPressed();
            return;
        }
        if (this.fCurrentPage == iWizardPage) {
            return;
        }
        Assert.isTrue((boolean)"ErrorPage".equals(this.fCurrentPage.getName()));
        if (this.showErrorDialog((ErrorWizardPage)this.fCurrentPage) && this.fWizard.performFinish()) {
            super.okPressed();
            return;
        }
        this.fCurrentPage = iWizardPage;
    }

    private boolean isPreviewPageActive() {
        return "PreviewPage".equals(this.fCurrentPage.getName());
    }

    private void previewPressed() {
        IWizardPage iWizardPage = this.fCurrentPage;
        this.fCurrentPage = this.fCurrentPage.getNextPage();
        if (iWizardPage == this.fCurrentPage) {
            return;
        }
        String string = this.fCurrentPage.getName();
        if ("ErrorPage".equals(string)) {
            if (this.showErrorDialog((ErrorWizardPage)this.fCurrentPage)) {
                this.fCurrentPage = this.fCurrentPage.getNextPage();
                string = this.fCurrentPage.getName();
            } else {
                return;
            }
        }
        if ("PreviewPage".equals(string)) {
            this.fCurrentPage.createControl((Composite)this.fPageContainer);
            this.makeVisible(this.fCurrentPage);
            this.updateButtons();
            if (((PreviewWizardPage)this.fCurrentPage).hasChanges()) {
                this.resize();
            } else {
                this.getButton(0).setEnabled(false);
            }
        } else {
            this.fCurrentPage = iWizardPage;
        }
    }

    private boolean showErrorDialog(ErrorWizardPage errorWizardPage) {
        RefactoringStatusDialog refactoringStatusDialog = new RefactoringStatusDialog(this.getShell(), errorWizardPage, true);
        switch (refactoringStatusDialog.open()) {
            case 0: {
                return true;
            }
            case 14: {
                this.fCurrentPage = this.fCurrentPage.getPreviousPage();
                break;
            }
            case 1: {
                super.cancelPressed();
            }
        }
        return false;
    }

    private void resize() {
        int n;
        Control control = this.fPageContainer.getTopPage();
        Point point = control.getSize();
        int n2 = Math.max(0, this.fPreviewWidth - point.x);
        int n3 = Math.max(0, this.fPreviewHeight - point.y);
        int n4 = n2 / 2;
        int n5 = n3 / 2;
        Shell shell = this.getShell();
        Rectangle rectangle = shell.getBounds();
        Rectangle rectangle2 = shell.getDisplay().getClientArea();
        rectangle.x = Math.max(0, rectangle.x - n4);
        rectangle.y = Math.max(0, rectangle.y - n5);
        rectangle.width = Math.min(rectangle.width + n2, rectangle2.width);
        rectangle.height = Math.min(rectangle.height + n3, rectangle2.height);
        int n6 = rectangle.x + rectangle.width;
        if (n6 > rectangle2.width) {
            rectangle.x -= n6 - rectangle2.width;
        }
        if ((n = rectangle.y + rectangle.height) > rectangle2.height) {
            rectangle.y -= n - rectangle2.height;
        }
        shell.setBounds(rectangle);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.fWizard.getDefaultPageTitle());
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        this.initializeDialogUnits((Control)composite2);
        this.fPageContainer = new PageBook(composite2, 0);
        GridData gridData = new GridData(1808);
        this.fPageContainer.setLayoutData(gridData);
        this.fCurrentPage = this.fWizard.getStartingPage();
        this.dialogArea = this.fPageContainer;
        if (this.fCurrentPage instanceof PreviewWizardPage) {
            gridData.widthHint = this.fPreviewWidth;
            gridData.heightHint = this.fPreviewHeight;
        }
        this.fStatusContainer = new PageBook(composite2, 0);
        gridData = new GridData(768);
        gridData.widthHint = this.convertWidthInCharsToPixels(this.fWizard.getMessageLineWidthInChars());
        this.fStatusContainer.setLayoutData(gridData);
        if (this.fWizard.needsProgressMonitor()) {
            this.createProgressMonitorPart();
        }
        this.createMessageBox();
        this.fStatusContainer.showPage((Control)this.fMessageBox);
        this.buttonBar = this.createButtonBar(composite2);
        this.fCurrentPage.createControl((Composite)this.fPageContainer);
        this.makeVisible(this.fCurrentPage);
        this.updateMessage();
        this.updateButtons();
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private void createProgressMonitorPart() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        this.fProgressMonitorPart = new ProgressMonitorPart((Composite)this.fStatusContainer, (Layout)gridLayout);
    }

    private void createMessageBox() {
        this.fMessageBox = new MessageBox(this.fStatusContainer, 0);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        String string;
        if (!(this.fCurrentPage instanceof PreviewWizardPage) && this.fWizard.hasPreviewPage()) {
            string = this.createButton(composite, 1025, RefactoringMessages.getString("RefactoringWizardDialog2.buttons.preview.label"), false);
            string.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    RefactoringWizardDialog2.this.previewPressed();
                }
            });
        }
        string = IDialogConstants.OK_LABEL;
        String string2 = IDialogConstants.CANCEL_LABEL;
        if (this.fWizard.yesNoStyle()) {
            string = IDialogConstants.YES_LABEL;
            string2 = IDialogConstants.NO_LABEL;
        }
        this.createButton(composite, 0, string, true);
        this.createButton(composite, 1, string2, false);
        Button button = this.getButton(0);
        button.setFocus();
    }

    private void makeVisible(IWizardPage iWizardPage) {
        if (this.fVisiblePage == iWizardPage) {
            return;
        }
        if (this.fVisiblePage != null) {
            this.fVisiblePage.setVisible(false);
        }
        this.fVisiblePage = iWizardPage;
        this.fPageContainer.showPage(iWizardPage.getControl());
        this.fVisiblePage.setVisible(true);
    }

    private static class MessageBox
    extends Composite {
        private Label fImage;
        private Label fText;

        public MessageBox(Composite composite, int n) {
            super(composite, n);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            this.setLayout((Layout)gridLayout);
            this.fImage = new Label((Composite)this, 0);
            this.fImage.setImage(INFO);
            Point point = this.fImage.computeSize(-1, -1);
            GridData gridData = new GridData();
            gridData.verticalAlignment = 128;
            gridData.widthHint = point.x;
            gridData.heightHint = point.y;
            this.fImage.setLayoutData((Object)gridData);
            this.fImage.setImage(null);
            this.fText = new Label((Composite)this, 64);
            this.fText.setText(" \n ");
            point = this.fText.computeSize(-1, -1);
            gridData = new GridData(768);
            gridData.heightHint = point.y;
            gridData.verticalAlignment = 128;
            this.fText.setLayoutData((Object)gridData);
        }

        public void setMessage(IWizardPage iWizardPage) {
            String string = iWizardPage.getErrorMessage();
            int n = 3;
            if (string == null || string.length() == 0) {
                string = iWizardPage.getMessage();
                n = 0;
                if (string != null && iWizardPage instanceof IMessageProvider) {
                    n = ((IMessageProvider)iWizardPage).getMessageType();
                }
            }
            Image image = null;
            switch (n) {
                case 1: {
                    image = INFO;
                    break;
                }
                case 2: {
                    image = WARNING;
                    break;
                }
                case 3: {
                    image = ERROR;
                }
            }
            if (string == null) {
                string = "";
            }
            this.fText.setText(string);
            if (image == null && string.length() > 0) {
                image = INFO;
            }
            this.fImage.setImage(image);
        }
    }

    private static class PageBook
    extends Composite {
        private StackLayout fLayout = new StackLayout();

        public PageBook(Composite composite, int n) {
            super(composite, n);
            this.setLayout((Layout)this.fLayout);
            this.fLayout.marginWidth = 5;
            this.fLayout.marginHeight = 5;
        }

        public void showPage(Control control) {
            this.fLayout.topControl = control;
            this.layout();
        }

        public Control getTopPage() {
            return this.fLayout.topControl;
        }
    }
}

