/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import org.eclipse.cdt.internal.corext.refactoring.IReferenceUpdating;
import org.eclipse.cdt.internal.corext.refactoring.ITextUpdating;
import org.eclipse.cdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.internal.ui.refactoring.TextInputWizardPage;
import org.eclipse.cdt.internal.ui.util.RowLayouter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

abstract class RenameInputWizardPage
extends TextInputWizardPage {
    private String fHelpContextID;
    private Button fUpdateReferences;
    private Button fUpdateComments;
    private Button fUpdateStrings;
    private Button fUpdateQualifiedNames;
    private static final String UPDATE_REFERENCES = "updateReferences";
    private static final String UPDATE_COMMENTS = "updateComments";
    private static final String UPDATE_STRINGS = "updateStrings";
    private static final String UPDATE_QUALIFIED_NAMES = "updateQualifiedNames";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public RenameInputWizardPage(String string, String string2, boolean bl, String string3) {
        super(string, bl, string3);
        this.fHelpContextID = string2;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        this.initializeDialogUnits((Control)composite2);
        composite2.setLayout((Layout)new GridLayout());
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 8;
        composite3.setLayout((Layout)gridLayout);
        RowLayouter rowLayouter = new RowLayouter(2);
        Label label = new Label(composite3, 0);
        label.setText(this.getOldNameLabelText());
        Label label2 = new Label(composite3, 0);
        label2.setText(this.fInitialValue);
        Label label3 = new Label(composite3, 0);
        label3.setText(this.getLabelText());
        Text text = this.createTextInputField(composite3);
        text.selectAll();
        GridData gridData = new GridData(768);
        gridData.widthHint = this.convertWidthInCharsToPixels(25);
        text.setLayoutData((Object)gridData);
        rowLayouter.perform((Control)label3, (Control)text, 1);
        this.addOptionalUpdateReferencesCheckbox(composite3, rowLayouter);
        Dialog.applyDialogFont((Control)composite2);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)this.fHelpContextID);
    }

    protected boolean saveSettings() {
        if (this.getContainer() instanceof Dialog) {
            return ((Dialog)this.getContainer()).getReturnCode() == 0;
        }
        return true;
    }

    public void dispose() {
        if (this.saveSettings()) {
            this.saveBooleanSetting(UPDATE_REFERENCES, this.fUpdateReferences);
            this.saveBooleanSetting(UPDATE_COMMENTS, this.fUpdateComments);
            this.saveBooleanSetting(UPDATE_STRINGS, this.fUpdateStrings);
            this.saveBooleanSetting(UPDATE_QUALIFIED_NAMES, this.fUpdateQualifiedNames);
        }
        super.dispose();
    }

    private void addOptionalUpdateReferencesCheckbox(Composite composite, RowLayouter rowLayouter) {
        IReferenceUpdating iReferenceUpdating;
        Refactoring refactoring = this.getRefactoring();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.corext.refactoring.IReferenceUpdating");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iReferenceUpdating = (IReferenceUpdating)refactoring.getAdapter(clazz)) == null || !iReferenceUpdating.canEnableUpdateReferences()) {
            return;
        }
        String string = RefactoringMessages.getString("RenameInputWizardPage.update_references");
        boolean bl = this.getBooleanSetting(UPDATE_REFERENCES, iReferenceUpdating.getUpdateReferences());
        this.fUpdateReferences = RenameInputWizardPage.createCheckbox(composite, string, bl, rowLayouter);
        iReferenceUpdating.setUpdateReferences(this.fUpdateReferences.getSelection());
        this.fUpdateReferences.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                iReferenceUpdating.setUpdateReferences(RenameInputWizardPage.this.fUpdateReferences.getSelection());
            }
        });
    }

    private void addOptionalUpdateCommentsAndStringCheckboxes(Composite composite, RowLayouter rowLayouter) {
        ITextUpdating iTextUpdating;
        Refactoring refactoring = this.getRefactoring();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.cdt.internal.corext.refactoring.ITextUpdating");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iTextUpdating = (ITextUpdating)refactoring.getAdapter(clazz)) == null || !iTextUpdating.canEnableTextUpdating()) {
            return;
        }
        this.addUpdateCommentsCheckbox(composite, rowLayouter, iTextUpdating);
        this.addUpdateStringsCheckbox(composite, rowLayouter, iTextUpdating);
    }

    private void addUpdateCommentsCheckbox(Composite composite, RowLayouter rowLayouter, final ITextUpdating iTextUpdating) {
        String string = RefactoringMessages.getString("RenameInputWizardPage.update_comment_references");
        boolean bl = this.getBooleanSetting(UPDATE_COMMENTS, iTextUpdating.getUpdateComments());
        this.fUpdateComments = RenameInputWizardPage.createCheckbox(composite, string, bl, rowLayouter);
        iTextUpdating.setUpdateComments(this.fUpdateComments.getSelection());
        this.fUpdateComments.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                iTextUpdating.setUpdateComments(RenameInputWizardPage.this.fUpdateComments.getSelection());
                RenameInputWizardPage.this.updateForcePreview();
            }
        });
    }

    private void addUpdateStringsCheckbox(Composite composite, RowLayouter rowLayouter, final ITextUpdating iTextUpdating) {
        String string = RefactoringMessages.getString("RenameInputWizardPage.ppdate_string_references");
        boolean bl = this.getBooleanSetting(UPDATE_STRINGS, iTextUpdating.getUpdateStrings());
        this.fUpdateStrings = RenameInputWizardPage.createCheckbox(composite, string, bl, rowLayouter);
        iTextUpdating.setUpdateStrings(this.fUpdateStrings.getSelection());
        this.fUpdateStrings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                iTextUpdating.setUpdateStrings(RenameInputWizardPage.this.fUpdateStrings.getSelection());
                RenameInputWizardPage.this.updateForcePreview();
            }
        });
    }

    protected String getLabelText() {
        return RefactoringMessages.getString("RenameInputWizardPage.enter_name");
    }

    protected String getOldNameLabelText() {
        return RefactoringMessages.getString("RenameInputWizardPage.old_name");
    }

    protected boolean getBooleanSetting(String string, boolean bl) {
        String string2 = this.getRefactoringSettings().get(string);
        if (string2 != null) {
            return Boolean.valueOf(string2);
        }
        return bl;
    }

    protected void saveBooleanSetting(String string, Button button) {
        if (button != null) {
            this.getRefactoringSettings().put(string, button.getSelection());
        }
    }

    private static Button createCheckbox(Composite composite, String string, boolean bl, RowLayouter rowLayouter) {
        Button button = new Button(composite, 32);
        button.setText(string);
        button.setSelection(bl);
        rowLayouter.perform((Control)button);
        return button;
    }

    private void updateForcePreview() {
        ITextUpdating iTextUpdating;
        boolean bl = false;
        Refactoring refactoring = this.getRefactoring();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.cdt.internal.corext.refactoring.ITextUpdating");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iTextUpdating = (ITextUpdating)refactoring.getAdapter(clazz)) != null) {
            bl = iTextUpdating.getUpdateComments() || iTextUpdating.getUpdateJavaDoc() || iTextUpdating.getUpdateStrings();
        }
        this.getRefactoringWizard().setPreviewReview(bl);
    }
}

