/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import org.eclipse.cdt.internal.corext.refactoring.IRenameRefactoring;
import org.eclipse.cdt.internal.corext.refactoring.RenameRefactoring;
import org.eclipse.cdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.cdt.internal.ui.refactoring.RenameInputWizardPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;

public class RenameRefactoringWizard
extends RefactoringWizard {
    private final String fInputPageDescription;
    private final String fPageContextHelpId;
    private final ImageDescriptor fInputPageImageDescriptor;

    public RenameRefactoringWizard(String string, String string2, ImageDescriptor imageDescriptor, String string3) {
        this.setDefaultPageTitle(string);
        this.fInputPageDescription = string2;
        this.fInputPageImageDescriptor = imageDescriptor;
        this.fPageContextHelpId = string3;
    }

    protected boolean hasPreviewPage() {
        Refactoring refactoring = this.getRefactoring();
        if (refactoring instanceof RenameRefactoring) {
            return (((RenameRefactoring)refactoring).getStyle() & 1) != 0;
        }
        return super.hasPreviewPage();
    }

    protected void addUserInputPages() {
        String string = this.getRenameRefactoring().getCurrentName();
        RenameInputWizardPage renameInputWizardPage = this.createInputPage(this.fInputPageDescription, string);
        renameInputWizardPage.setImageDescriptor(this.fInputPageImageDescriptor);
        this.addPage((IWizardPage)renameInputWizardPage);
    }

    private IRenameRefactoring getRenameRefactoring() {
        return (IRenameRefactoring)((Object)this.getRefactoring());
    }

    protected RenameInputWizardPage createInputPage(String string, String string2) {
        return new RenameInputWizardPage(string, this.fPageContextHelpId, true, string2){

            protected RefactoringStatus validateTextField(String string) {
                return RenameRefactoringWizard.this.validateNewName(string);
            }
        };
    }

    protected RefactoringStatus validateNewName(String string) {
        IRenameRefactoring iRenameRefactoring = this.getRenameRefactoring();
        iRenameRefactoring.setNewName(string);
        try {
            return iRenameRefactoring.checkNewName(string);
        }
        catch (CoreException coreException) {
            String string2 = coreException.getMessage() == null ? "" : coreException.getMessage();
            return RefactoringStatus.createFatalErrorStatus(RefactoringMessages.getFormattedString("RenameRefactoringWizard.internal_error", string2));
        }
    }
}

