/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.cdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.cdt.internal.ui.refactoring.IChangePreviewViewer;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TextChangePreviewViewer
implements IChangePreviewViewer {
    private ComparePreviewer fViewer;

    public static Object createInput(TextChange textChange) {
        return textChange;
    }

    public static Object createInput(TextChange.EditChange editChange, int n) {
        TextEditChangeInput textEditChangeInput = new TextEditChangeInput();
        textEditChangeInput.change = editChange;
        textEditChangeInput.surroundingLines = n;
        return textEditChangeInput;
    }

    public static Object createInput(TextChange.EditChange[] editChangeArray, IRegion iRegion) {
        TextEditChangeInput textEditChangeInput = new TextEditChangeInput();
        textEditChangeInput.changes = editChangeArray;
        textEditChangeInput.range = iRegion;
        return textEditChangeInput;
    }

    public void createControl(Composite composite) {
        this.fViewer = new ComparePreviewer(composite);
    }

    public Control getControl() {
        return this.fViewer;
    }

    public void setInput(Object object) throws CoreException {
        if (object instanceof TextChange) {
            TextChange textChange = (TextChange)object;
            this.setInput(textChange.getCurrentContent(), textChange.getPreviewContent(), textChange.getTextType());
            return;
        }
        if (object instanceof TextEditChangeInput) {
            TextEditChangeInput textEditChangeInput = (TextEditChangeInput)object;
            if (textEditChangeInput.change != null && textEditChangeInput.surroundingLines >= 0) {
                TextChange.EditChange editChange = textEditChangeInput.change;
                TextChange textChange = editChange.getTextChange();
                this.setInput(textChange.getCurrentContent(editChange, 2), textChange.getPreviewContent(editChange, 2), textChange.getTextType());
                return;
            }
            if (textEditChangeInput.changes != null && textEditChangeInput.changes.length > 0 && textEditChangeInput.range != null) {
                TextChange textChange = textEditChangeInput.changes[0].getTextChange();
                this.setInput(textChange.getCurrentContent(textEditChangeInput.range), textChange.getPreviewContent(textEditChangeInput.changes, textEditChangeInput.range), textChange.getTextType());
                return;
            }
        } else {
            this.fViewer.setInput(null);
        }
    }

    public void refresh() {
        this.fViewer.getViewer().refresh();
    }

    private void setInput(String string, String string2, String string3) {
        this.fViewer.setInput(new DiffNode((ITypedElement)new CompareElement(string, string3), (ITypedElement)new CompareElement(string2, string3)));
    }

    private static class TextEditChangeInput {
        TextChange.EditChange change;
        int surroundingLines;
        TextChange.EditChange[] changes;
        IRegion range;

        TextEditChangeInput() {
        }
    }

    private static class ComparePreviewer
    extends CompareViewerSwitchingPane {
        private CompareConfiguration fCompareConfiguration = new CompareConfiguration();

        public ComparePreviewer(Composite composite) {
            super(composite, 0x800800, true);
            this.fCompareConfiguration.setLeftEditable(false);
            this.fCompareConfiguration.setLeftLabel(RefactoringMessages.getString("ComparePreviewer.original_source"));
            this.fCompareConfiguration.setRightEditable(false);
            this.fCompareConfiguration.setRightLabel(RefactoringMessages.getString("ComparePreviewer.refactored_source"));
        }

        protected Viewer getViewer(Viewer viewer, Object object) {
            return CompareUI.findContentViewer((Viewer)viewer, (ICompareInput)((ICompareInput)object), (Composite)this, (CompareConfiguration)this.fCompareConfiguration);
        }

        public void setText(String string) {
            super.setText(string);
        }
    }

    private static class CompareElement
    implements ITypedElement,
    IStreamContentAccessor {
        private InputStream fContent;
        private String fType;

        public CompareElement(String string, String string2) {
            this.fContent = CompareElement.createInputStream(string);
            this.fType = string2;
        }

        public String getName() {
            return RefactoringMessages.getString("ComparePreviewer.element_name");
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            return this.fType;
        }

        public InputStream getContents() throws CoreException {
            return this.fContent;
        }

        private static InputStream createInputStream(String string) {
            try {
                return new ByteArrayInputStream(string.getBytes(ResourcesPlugin.getEncoding()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new ByteArrayInputStream(string.getBytes());
            }
        }
    }
}

