/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.cdt.internal.ui.refactoring.ChangeElement;
import org.eclipse.cdt.internal.ui.refactoring.DefaultChangeElement;
import org.eclipse.cdt.internal.ui.refactoring.IChangePreviewViewer;
import org.eclipse.cdt.internal.ui.refactoring.PseudoCChangeElement;
import org.eclipse.cdt.internal.ui.refactoring.TextChangePreviewViewer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.Assert;

class TextEditChangeElement
extends ChangeElement {
    private static final ChangeElement[] fgChildren = new ChangeElement[0];
    private TextChange.EditChange fChange;

    public TextEditChangeElement(ChangeElement changeElement, TextChange.EditChange editChange) {
        super(changeElement);
        this.fChange = editChange;
        Assert.isNotNull((Object)this.fChange);
    }

    public TextChange.EditChange getTextEditChange() {
        return this.fChange;
    }

    public void feedInput(IChangePreviewViewer iChangePreviewViewer) throws CoreException {
        DefaultChangeElement defaultChangeElement = this.getStandardChangeElement();
        if (defaultChangeElement != null) {
            IChange iChange = defaultChangeElement.getChange();
            if (iChange instanceof TextChange) {
                IRegion iRegion = TextEditChangeElement.getTextRange(this);
                Object object = null;
                object = iRegion != null ? TextChangePreviewViewer.createInput(new TextChange.EditChange[]{this.fChange}, iRegion) : TextChangePreviewViewer.createInput(this.fChange, 2);
                iChangePreviewViewer.setInput(object);
            }
        } else {
            iChangePreviewViewer.setInput(null);
        }
    }

    public void setActive(boolean bl) {
        this.fChange.setActive(bl);
    }

    public int getActive() {
        return this.fChange.isActive() ? 2 : 0;
    }

    public ChangeElement[] getChildren() {
        return fgChildren;
    }

    private DefaultChangeElement getStandardChangeElement() {
        ChangeElement changeElement = this.getParent();
        while (!(changeElement instanceof DefaultChangeElement) && changeElement != null) {
            changeElement = changeElement.getParent();
        }
        return (DefaultChangeElement)changeElement;
    }

    private static IRegion getTextRange(ChangeElement changeElement) throws CoreException {
        if (changeElement == null) {
            return null;
        }
        if (changeElement instanceof PseudoCChangeElement) {
            return ((PseudoCChangeElement)changeElement).getTextRange();
        }
        if (changeElement instanceof DefaultChangeElement) {
            return null;
        }
        return TextEditChangeElement.getTextRange(changeElement.getParent());
    }
}

