/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.internal.ui.refactoring.UserInputWizardPage;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public abstract class TextInputWizardPage
extends UserInputWizardPage {
    protected String fInitialValue;
    protected Text fTextField;
    public static final String PAGE_NAME = "TextInputPage";

    public TextInputWizardPage(String string, boolean bl) {
        this(string, bl, "");
    }

    public TextInputWizardPage(String string, boolean bl, String string2) {
        super(PAGE_NAME, bl);
        Assert.isNotNull((Object)string2);
        this.setDescription(string);
        this.fInitialValue = string2;
    }

    protected boolean isInitialInputValid() {
        return false;
    }

    protected boolean isEmptyInputValid() {
        return false;
    }

    protected String getText() {
        if (this.fTextField == null) {
            return null;
        }
        return this.fTextField.getText();
    }

    protected void setText(String string) {
        if (this.fTextField == null) {
            return;
        }
        this.fTextField.setText(string);
    }

    protected RefactoringStatus validateTextField(String string) {
        return null;
    }

    protected Text createTextInputField(Composite composite) {
        return this.createTextInputField(composite, 2048);
    }

    protected Text createTextInputField(Composite composite, int n) {
        this.fTextField = new Text(composite, n);
        this.fTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                TextInputWizardPage.this.textModified(TextInputWizardPage.this.getText());
            }
        });
        this.fTextField.setText(this.fInitialValue);
        return this.fTextField;
    }

    protected void textModified(String string) {
        if (!this.isEmptyInputValid() && string.equals("")) {
            this.setPageComplete(false);
            this.setErrorMessage(null);
            this.restoreMessage();
            return;
        }
        if (!this.isInitialInputValid() && string.equals(this.fInitialValue)) {
            this.setPageComplete(false);
            this.setErrorMessage(null);
            this.restoreMessage();
            return;
        }
        this.setPageComplete(this.validateTextField(string));
    }

    protected void restoreMessage() {
        this.setMessage(null);
    }

    public void dispose() {
        this.fTextField = null;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.textModified(this.getText());
        }
        super.setVisible(bl);
        if (bl && this.fTextField != null) {
            this.fTextField.setFocus();
        }
    }
}

