/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import org.eclipse.cdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.refactoring.CreateChangeOperation;
import org.eclipse.cdt.internal.ui.refactoring.PerformChangeOperation;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringPreferences;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringWizard;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringWizardPage;
import org.eclipse.jface.wizard.IWizardPage;

public abstract class UserInputWizardPage
extends RefactoringWizardPage {
    private final boolean fIsLastUserPage;

    public UserInputWizardPage(String string, boolean bl) {
        super(string);
        this.fIsLastUserPage = bl;
    }

    public void setPageComplete(RefactoringStatus refactoringStatus) {
        this.getRefactoringWizard().setStatus(refactoringStatus);
        int n = refactoringStatus.getSeverity();
        if (n == 4) {
            this.setPageComplete(false);
            this.setErrorMessage(refactoringStatus.getFirstMessage(n));
            this.setImageDescriptor(CPluginImages.DESC_OBJS_DEFAULT_CHANGE);
        } else {
            this.setPageComplete(true);
            this.setErrorMessage(null);
            if (n == 0) {
                this.setMessage(null, 0);
            } else {
                this.setMessage(refactoringStatus.getFirstMessage(n), UserInputWizardPage.getCorrespondingIStatusSeverity(n));
                this.setImageDescriptor(CPluginImages.DESC_OBJS_DEFAULT_CHANGE);
            }
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.getRefactoringWizard().setChange(null);
        }
        super.setVisible(bl);
    }

    public IWizardPage getNextPage() {
        if (this.fIsLastUserPage) {
            return this.getRefactoringWizard().computeUserInputSuccessorPage((IWizardPage)this);
        }
        return super.getNextPage();
    }

    public boolean canFlipToNextPage() {
        if (this.fIsLastUserPage) {
            return this.isPageComplete();
        }
        return super.canFlipToNextPage();
    }

    protected boolean performFinish() {
        CreateChangeOperation createChangeOperation;
        RefactoringWizard refactoringWizard = this.getRefactoringWizard();
        int n = RefactoringPreferences.getCheckPassedSeverity();
        RefactoringStatus refactoringStatus = refactoringWizard.getActivationStatus();
        RefactoringStatus refactoringStatus2 = null;
        RefactoringStatus refactoringStatus3 = new RefactoringStatus();
        Refactoring refactoring = this.getRefactoring();
        boolean bl = false;
        if (refactoringStatus != null && refactoringStatus.getSeverity() > n) {
            refactoringStatus2 = refactoringWizard.checkInput();
        } else {
            createChangeOperation = new CreateChangeOperation(refactoring, 4);
            createChangeOperation.setCheckPassedSeverity(n);
            PerformChangeOperation performChangeOperation = new PerformChangeOperation(createChangeOperation);
            performChangeOperation.setCheckPassedSeverity(n);
            bl = refactoringWizard.performFinish(performChangeOperation);
            refactoringWizard.setChange(createChangeOperation.getChange());
            if (!bl) {
                return false;
            }
            refactoringStatus2 = createChangeOperation.getStatus();
        }
        refactoringStatus3.merge(refactoringStatus);
        refactoringStatus3.merge(refactoringStatus2);
        if (refactoringStatus3.getSeverity() > n) {
            refactoringWizard.setStatus(refactoringStatus3);
            createChangeOperation = refactoringWizard.getPage("ErrorPage");
            refactoringWizard.getContainer().showPage((IWizardPage)createChangeOperation);
            return false;
        }
        return bl;
    }

    private static int getCorrespondingIStatusSeverity(int n) {
        if (n == 4) {
            return 4;
        }
        if (n == 3) {
            return 2;
        }
        if (n == 2) {
            return 2;
        }
        if (n == 1) {
            return 1;
        }
        return 0;
    }
}

