/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.actions;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.corext.refactoring.RenameRefactoring;
import org.eclipse.cdt.internal.ui.cview.SelectionConverter;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.internal.ui.refactoring.UserInterfaceStarter;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.actions.SelectionDispatchAction;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.texteditor.ITextEditor;

public class RenameRefactoringAction
extends SelectionDispatchAction {
    private CEditor fEditor;

    public RenameRefactoringAction(CEditor cEditor) {
        this((IWorkbenchSite)cEditor.getEditorSite());
        this.fEditor = cEditor;
    }

    public RenameRefactoringAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(RefactoringMessages.getString("RenameRefactoringAction.text"));
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(iStructuredSelection.size() == 1);
    }

    public void selectionChanged(ITextSelection iTextSelection) {
        boolean bl = true;
        ICElement iCElement = null;
        try {
            iCElement = SelectionConverter.getElementAtOffset((ITextEditor)this.fEditor);
        }
        catch (CModelException cModelException) {
            this.setEnabled(false);
        }
        if (iCElement == null || iCElement instanceof ITranslationUnit) {
            this.setEnabled(false);
            return;
        }
        ITextSelection iTextSelection2 = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        if (iTextSelection2 == null) {
            this.setEnabled(false);
            return;
        }
        if (((CElement)iCElement).getIdStartPos() != iTextSelection2.getOffset() || ((CElement)iCElement).getIdLength() != iTextSelection2.getLength()) {
            bl = false;
        }
        this.setEnabled(bl);
    }

    public void run(ITextSelection iTextSelection) {
        try {
            ICElement iCElement = SelectionConverter.getElementAtOffset((ITextEditor)this.fEditor);
            RenameRefactoring renameRefactoring = new RenameRefactoring(iCElement);
            RenameRefactoringAction.run(renameRefactoring, this.getShell());
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, this.getShell(), RefactoringMessages.getString("RenameRefactoringAction.label"), RefactoringMessages.getString("RenameRefactoringAction.unexpected_exception"));
        }
    }

    public void run(IStructuredSelection iStructuredSelection) {
        Object object = iStructuredSelection.getFirstElement();
        try {
            RenameRefactoring renameRefactoring = new RenameRefactoring(object);
            RenameRefactoringAction.run(renameRefactoring, this.getShell());
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, this.getShell(), RefactoringMessages.getString("RenameRefactoringAction.label"), RefactoringMessages.getString("RenameRefactoringAction.unexpected_exception"));
        }
    }

    public void run(IAction iAction) {
        this.run();
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        iAction.setEnabled(true);
    }

    public static void run(RenameRefactoring renameRefactoring, Shell shell) throws CoreException {
        if (renameRefactoring.isAvailable()) {
            UserInterfaceStarter.run(renameRefactoring, shell);
        } else {
            MessageDialog.openInformation((Shell)shell, (String)RefactoringMessages.getString("RenameRefactoringAction.label"), (String)RefactoringMessages.getString("RenameRefactoringAction.no_refactoring_available"));
        }
    }
}

