/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.cdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatusEntry;
import org.eclipse.cdt.internal.corext.refactoring.base.UndoManagerAdapter;
import org.eclipse.cdt.internal.ui.refactoring.AbortChangeExceptionHandler;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.actions.SelectionDispatchAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

abstract class UndoManagerAction
extends SelectionDispatchAction {
    private static final int MAX_LENGTH = 30;
    private RefactoringStatus fPreflightStatus;
    private IAction fAction;
    private IWorkbenchWindow fWorkbenchWindow;
    private UndoManagerAdapter fUndoManagerListener;

    public UndoManagerAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
    }

    protected abstract IRunnableWithProgress createOperation(ChangeContext var1);

    protected abstract UndoManagerAdapter createUndoManagerListener();

    protected abstract String getName();

    protected IWorkbenchWindow getWorkbenchWindow() {
        return this.fWorkbenchWindow;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected boolean isHooked() {
        return this.fAction != null;
    }

    protected void hookListener(IAction iAction) {
        if (this.isHooked()) {
            return;
        }
        this.fAction = iAction;
        this.fUndoManagerListener = this.createUndoManagerListener();
        Refactoring.getUndoManager().addListener(this.fUndoManagerListener);
    }

    protected String shortenText(String string, int n) {
        int n2 = string.length();
        int n3 = 30 + n;
        if (string.length() <= n3) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = n3 / 2;
        stringBuffer.append(string.substring(0, n4));
        stringBuffer.append("...");
        stringBuffer.append(string.substring(n2 - n4));
        return stringBuffer.toString();
    }

    public void dispose() {
        if (this.fUndoManagerListener != null) {
            Refactoring.getUndoManager().removeListener(this.fUndoManagerListener);
        }
        this.fWorkbenchWindow = null;
        this.fAction = null;
        this.fUndoManagerListener = null;
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.fWorkbenchWindow = iWorkbenchWindow;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        this.run();
    }

    public void run(IAction iAction) {
        this.run();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block6: {
            String string;
            MultiStatus multiStatus;
            Shell shell = this.fWorkbenchWindow.getShell();
            ChangeContext changeContext = new ChangeContext(new AbortChangeExceptionHandler(), this.getUnsavedFiles());
            IRunnableWithProgress iRunnableWithProgress = this.createOperation(changeContext);
            try {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(false, false, iRunnableWithProgress);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Refactoring.getUndoManager().flush();
                    ExceptionHandler.handle(invocationTargetException, RefactoringMessages.getString("UndoManagerAction.error"), RefactoringMessages.getString("UndoManagerAction.internal_error"));
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                changeContext.clearPerformedChanges();
                throw throwable;
            }
            {
                multiStatus = null;
                changeContext.clearPerformedChanges();
                if (this.fPreflightStatus == null || !this.fPreflightStatus.hasError()) break block6;
                string = this.getName();
                multiStatus = this.createMultiStatus();
            }
            String string2 = RefactoringMessages.getFormattedString("UndoManagerAction.cannot_be_executed", string);
            ErrorDialog errorDialog = new ErrorDialog(shell, string, string2, (IStatus)multiStatus, 4){

                public void create() {
                    super.create();
                    this.buttonPressed(13);
                }
            };
            errorDialog.open();
        }
        this.fPreflightStatus = null;
    }

    void setPreflightStatus(RefactoringStatus refactoringStatus) {
        this.fPreflightStatus = refactoringStatus;
    }

    private MultiStatus createMultiStatus() {
        MultiStatus multiStatus = new MultiStatus(CUIPlugin.getPluginId(), 4, RefactoringMessages.getString("UndoManagerAction.unsaved_filed"), null);
        String string = CUIPlugin.getPluginId();
        Iterator iterator = this.fPreflightStatus.getEntries().iterator();
        while (iterator.hasNext()) {
            RefactoringStatusEntry refactoringStatusEntry = (RefactoringStatusEntry)iterator.next();
            multiStatus.merge((IStatus)new Status(4, string, 4, refactoringStatusEntry.getMessage(), null));
        }
        return multiStatus;
    }

    private IFile[] getUnsavedFiles() {
        IEditorPart[] iEditorPartArray = CUIPlugin.getDirtyEditors();
        ArrayList<IFile> arrayList = new ArrayList<IFile>(iEditorPartArray.length);
        int n = 0;
        while (n < iEditorPartArray.length) {
            IEditorInput iEditorInput = iEditorPartArray[n].getEditorInput();
            if (iEditorInput instanceof IFileEditorInput) {
                arrayList.add(((IFileEditorInput)iEditorInput).getFile());
            }
            ++n;
        }
        return arrayList.toArray(new IFile[arrayList.size()]);
    }
}

