/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.internal.corext.refactoring.base.ChangeAbortException;
import org.eclipse.cdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.cdt.internal.corext.refactoring.base.IUndoManager;
import org.eclipse.cdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.cdt.internal.corext.refactoring.base.UndoManagerAdapter;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.internal.ui.refactoring.actions.UndoManagerAction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchSite;

public class UndoRefactoringAction
extends UndoManagerAction {
    private int fPatternLength;
    private CEditor fEditor;

    public UndoRefactoringAction(CEditor cEditor) {
        this((IWorkbenchSite)cEditor.getEditorSite());
        this.fEditor = cEditor;
    }

    public UndoRefactoringAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.init(iWorkbenchSite.getWorkbenchWindow());
    }

    protected String getName() {
        return RefactoringMessages.getString("UndoRefactoringAction.name");
    }

    protected IRunnableWithProgress createOperation(final ChangeContext changeContext) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    UndoRefactoringAction.this.setPreflightStatus(Refactoring.getUndoManager().performUndo(changeContext, iProgressMonitor));
                }
                catch (CModelException cModelException) {
                    throw new InvocationTargetException(cModelException);
                }
                catch (ChangeAbortException changeAbortException) {
                    throw new InvocationTargetException(changeAbortException);
                }
            }
        };
    }

    protected UndoManagerAdapter createUndoManagerListener() {
        return new UndoManagerAdapter(){

            public void undoStackChanged(IUndoManager iUndoManager) {
                IAction iAction = UndoRefactoringAction.this.getAction();
                if (iAction == null) {
                    return;
                }
                boolean bl = false;
                String string = null;
                if (iUndoManager.anythingToUndo()) {
                    bl = true;
                    string = UndoRefactoringAction.this.getActionText();
                } else {
                    string = RefactoringMessages.getString("UndoRefactoringAction.label");
                }
                iAction.setEnabled(bl);
                iAction.setText(string);
            }
        };
    }

    public void selectionChanged(ISelection iSelection) {
        this.selectionChanged((IAction)this, iSelection);
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        if (!this.isHooked()) {
            this.hookListener((IAction)this);
        }
        this.fPatternLength = RefactoringMessages.getString("UndoRefactoringAction.extendedLabel").length();
        IUndoManager iUndoManager = Refactoring.getUndoManager();
        if (iUndoManager.anythingToUndo()) {
            if (iUndoManager.peekUndoName() != null) {
                iAction.setText(this.getActionText());
            }
            iAction.setEnabled(true);
        } else {
            iAction.setEnabled(false);
        }
    }

    private String getActionText() {
        return this.shortenText(RefactoringMessages.getFormattedString("UndoRefactoringAction.extendedLabel", Refactoring.getUndoManager().peekUndoName()), this.fPatternLength);
    }
}

