/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.index.Indexer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchQuery;
import org.eclipse.cdt.internal.ui.search.CSearchScopeFactory;
import org.eclipse.cdt.internal.ui.search.CSearchUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.search.internal.ui.util.RowLayouter;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class CSearchPage
extends DialogPage
implements ISearchPage,
ICSearchConstants {
    public static final String EXTENSION_POINT_ID = "org.eclipse.cdt.ui.CSearchPage";
    private static final String PAGE_NAME = "CSearchPage";
    private static final String STORE_CASE_SENSITIVE = "CSearchPageCASE_SENSITIVE";
    public static final String EXTERNALMATCH_ENABLED = "externMatchEnable";
    public static final String EXTERNALMATCH_VISIBLE = "externMatchVisible";
    private static List fgPreviousSearchPatterns = new ArrayList(20);
    private Button[] fSearchFor;
    private ICSearchConstants.SearchFor[] fSearchForValues = new ICSearchConstants.SearchFor[]{ICSearchConstants.CLASS_STRUCT, ICSearchConstants.FUNCTION, ICSearchConstants.VAR, ICSearchConstants.UNION, ICSearchConstants.METHOD, ICSearchConstants.FIELD, ICSearchConstants.ENUM, ICSearchConstants.ENUMTOR, ICSearchConstants.NAMESPACE, ICSearchConstants.UNKNOWN_SEARCH_FOR};
    private String[] fSearchForText = new String[]{CSearchMessages.getString("CSearchPage.searchFor.classStruct"), CSearchMessages.getString("CSearchPage.searchFor.function"), CSearchMessages.getString("CSearchPage.searchFor.variable"), CSearchMessages.getString("CSearchPage.searchFor.union"), CSearchMessages.getString("CSearchPage.searchFor.method"), CSearchMessages.getString("CSearchPage.searchFor.field"), CSearchMessages.getString("CSearchPage.searchFor.enum"), CSearchMessages.getString("CSearchPage.searchFor.enumr"), CSearchMessages.getString("CSearchPage.searchFor.namespace"), CSearchMessages.getString("CSearchPage.searchFor.any")};
    private Button[] fLimitTo;
    private static final int LIMIT_TO_ALL = 3;
    private static final int LIMIT_TO_DEFINITIONS = 1;
    private ICSearchConstants.LimitTo[] fLimitToValues = new ICSearchConstants.LimitTo[]{ICSearchConstants.DECLARATIONS, ICSearchConstants.DEFINITIONS, ICSearchConstants.REFERENCES, ICSearchConstants.ALL_OCCURRENCES};
    private String[] fLimitToText = new String[]{CSearchMessages.getString("CSearchPage.limitTo.declarations"), CSearchMessages.getString("CSearchPage.limitTo.definitions"), CSearchMessages.getString("CSearchPage.limitTo.references"), CSearchMessages.getString("CSearchPage.limitTo.allOccurrences")};
    private SearchPatternData fInitialData;
    private IStructuredSelection fStructuredSelection;
    private ICElement fCElement;
    private boolean fFirstTime = true;
    private IDialogSettings fDialogSettings;
    private boolean fIsCaseSensitive;
    private Combo fPattern;
    private ISearchPageContainer fContainer;
    private Button fCaseSensitive;
    private IStatusLineManager fLineManager;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public boolean performAction() {
        Object object;
        this.fLineManager.setErrorMessage(null);
        SearchPatternData searchPatternData = this.getPatternData();
        IWorkspace iWorkspace = CUIPlugin.getWorkspace();
        ICSearchScope iCSearchScope = null;
        String string = "";
        switch (this.getContainer().getSelectedScope()) {
            case 1: {
                if (this.fStructuredSelection != null && this.fStructuredSelection.iterator().hasNext()) {
                    string = CSearchMessages.getString("SelectionScope");
                    iCSearchScope = CSearchScopeFactory.getInstance().createCSearchScope(this.fStructuredSelection);
                    break;
                }
            }
            case 0: {
                string = CSearchMessages.getString("WorkspaceScope");
                iCSearchScope = SearchEngine.createWorkspaceScope();
                break;
            }
            case 2: {
                object = this.getContainer().getSelectedWorkingSets();
                if (object == null || ((IWorkingSet[])object).length < 1) {
                    return false;
                }
                string = CSearchMessages.getFormattedString("WorkingSetScope", CSearchUtil.toString((IWorkingSet[])object));
                iCSearchScope = CSearchScopeFactory.getInstance().createCSearchScope(this.getContainer().getSelectedWorkingSets());
                CSearchUtil.updateLRUWorkingSets(this.getContainer().getSelectedWorkingSets());
            }
        }
        searchPatternData.cElement = null;
        object = null;
        if (searchPatternData.searchFor.contains(ICSearchConstants.UNKNOWN_SEARCH_FOR)) {
            object = new LinkedList();
            int n = 0;
            while (n < this.fSearchFor.length - 1) {
                object.add(this.fSearchForValues[n]);
                ++n;
            }
            object.add(ICSearchConstants.MACRO);
            object.add(ICSearchConstants.TYPEDEF);
        } else {
            object = searchPatternData.searchFor;
        }
        CSearchQuery cSearchQuery = new CSearchQuery(iWorkspace, searchPatternData.pattern, searchPatternData.isCaseSensitive, (List)object, searchPatternData.limitTo, iCSearchScope, string, null);
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQuery((ISearchQuery)cSearchQuery);
        return true;
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        this.readConfiguration();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        RowLayouter rowLayouter = new RowLayouter(gridLayout.numColumns);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 18;
        rowLayouter.setDefaultGridData(gridData, 0);
        rowLayouter.setDefaultGridData(gridData, 1);
        rowLayouter.setDefaultSpan();
        rowLayouter.perform(this.createExpression(composite2));
        rowLayouter.perform(this.createSearchFor(composite2), this.createLimitTo(composite2), -1);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (CSearchPage.this.getSearchFor() == ((CSearchPage)CSearchPage.this).fInitialData.searchFor) {
                    CSearchPage.this.fCElement = ((CSearchPage)CSearchPage.this).fInitialData.cElement;
                } else {
                    CSearchPage.this.fCElement = null;
                }
                CSearchPage.this.handleAllElements(selectionEvent);
                List list = CSearchPage.this.getSearchFor();
                CSearchPage.this.getContainer().setPerformActionEnabled(list.size() != 0 && CSearchPage.this.getPattern().length() > 0);
                CSearchPage.this.setLimitTo(list);
                CSearchPage.this.updateCaseSensitiveCheckbox();
            }
        };
        int n = 0;
        while (n < this.fSearchFor.length) {
            this.fSearchFor[n].addSelectionListener((SelectionListener)selectionAdapter);
            ++n;
        }
        this.setControl((Control)composite2);
        this.fLineManager = this.getStatusLineManager();
        this.setIndexerMessages();
        Dialog.applyDialogFont((Control)composite2);
        WorkbenchHelp.setHelp((Control)composite2, (String)"org.eclipse.cdt.ui.cdt_u_search");
    }

    private void setIndexerMessages() {
        if (this.fLineManager == null) {
            return;
        }
        if (Indexer.indexEnabledOnAllProjects()) {
            return;
        }
        if (Indexer.indexEnabledOnAnyProjects()) {
            this.fLineManager.setErrorMessage(CSearchMessages.getString("CSearchPage.warning.indexersomeprojects"));
        } else {
            this.fLineManager.setErrorMessage(CSearchMessages.getString("CSearchPage.warning.indexernoprojects"));
        }
    }

    private IStatusLineManager getStatusLineManager() {
        IWorkbenchPage iWorkbenchPage;
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
            IWorkbenchPartSite iWorkbenchPartSite = iWorkbenchPage.getActivePart().getSite();
            if (iWorkbenchPartSite instanceof IViewSite) {
                return ((IViewSite)iWorkbenchPartSite).getActionBars().getStatusLineManager();
            }
            if (iWorkbenchPartSite instanceof IEditorSite) {
                return ((IEditorSite)iWorkbenchPartSite).getActionBars().getStatusLineManager();
            }
        }
        return null;
    }

    private Control createExpression(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 0;
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 16384);
        label.setText(CSearchMessages.getString("CSearchPage.expression.label"));
        gridData = new GridData(1);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.fPattern = new Combo(composite2, 2052);
        this.fPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CSearchPage.this.handlePatternSelected();
            }
        });
        this.fPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                CSearchPage.this.getContainer().setPerformActionEnabled(CSearchPage.this.getPattern().length() > 0 && CSearchPage.this.getSearchFor().size() != 0);
                CSearchPage.this.updateCaseSensitiveCheckbox();
            }
        });
        gridData = new GridData(768);
        gridData.horizontalIndent = -gridData.horizontalIndent;
        this.fPattern.setLayoutData((Object)gridData);
        this.fCaseSensitive = new Button(composite2, 32);
        this.fCaseSensitive.setText(CSearchMessages.getString("CSearchPage.expression.caseSensitive"));
        gridData = new GridData();
        this.fCaseSensitive.setLayoutData((Object)gridData);
        this.fCaseSensitive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CSearchPage.this.fIsCaseSensitive = CSearchPage.this.fCaseSensitive.getSelection();
                CSearchPage.this.writeConfiguration();
            }
        });
        return composite2;
    }

    private void handleAllElements(SelectionEvent selectionEvent) {
        Button button = this.fSearchFor[this.fSearchFor.length - 1];
        if (selectionEvent.widget == button) {
            int n = 0;
            while (n < this.fSearchFor.length - 1) {
                this.fSearchFor[n].setEnabled(!button.getSelection());
                ++n;
            }
        }
    }

    private void handlePatternSelected() {
        if (this.fPattern.getSelectionIndex() < 0) {
            return;
        }
        int n = fgPreviousSearchPatterns.size() - 1 - this.fPattern.getSelectionIndex();
        this.fInitialData = (SearchPatternData)fgPreviousSearchPatterns.get(n);
        this.updateSelections();
        if (this.fInitialData.workingSets != null) {
            this.getContainer().setSelectedWorkingSets(this.fInitialData.workingSets);
        } else {
            this.getContainer().setSelectedScope(this.fInitialData.scope);
        }
    }

    private String getPattern() {
        return this.fPattern.getText();
    }

    private Control createLimitTo(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(CSearchMessages.getString("CSearchPage.limitTo.label"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        this.fLimitTo = new Button[this.fLimitToText.length];
        int n = 0;
        while (n < this.fLimitToText.length) {
            Button button = new Button((Composite)group, 16);
            button.setText(this.fLimitToText[n]);
            this.fLimitTo[n] = button;
            ++n;
        }
        Button button = new Button((Composite)group, 16);
        button.setVisible(false);
        button = new Button((Composite)group, 16);
        button.setVisible(false);
        return group;
    }

    private ICSearchConstants.LimitTo getLimitTo() {
        int n = 0;
        while (n < this.fLimitTo.length) {
            if (this.fLimitTo[n].getSelection()) {
                return this.fLimitToValues[n];
            }
            ++n;
        }
        return null;
    }

    private void setLimitTo(List list) {
        HashSet<ICSearchConstants.LimitTo> hashSet = new HashSet<ICSearchConstants.LimitTo>();
        hashSet.add(ICSearchConstants.DECLARATIONS);
        hashSet.add(ICSearchConstants.REFERENCES);
        hashSet.add(ICSearchConstants.ALL_OCCURRENCES);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ICSearchConstants.SearchFor searchFor = (ICSearchConstants.SearchFor)iterator.next();
            if (searchFor != ICSearchConstants.FUNCTION && searchFor != ICSearchConstants.METHOD && searchFor != ICSearchConstants.VAR && searchFor != ICSearchConstants.FIELD && searchFor != ICSearchConstants.NAMESPACE && searchFor != ICSearchConstants.UNKNOWN_SEARCH_FOR) continue;
            hashSet.add(ICSearchConstants.DEFINITIONS);
            break;
        }
        int n = 0;
        while (n < this.fLimitTo.length) {
            this.fLimitTo[n].setEnabled(hashSet.contains(this.fLimitToValues[n]));
            ++n;
        }
        if (!this.fLimitTo[1].isEnabled() && this.fLimitTo[1].getSelection()) {
            this.fLimitTo[1].setSelection(false);
            this.fLimitTo[3].setSelection(true);
        }
    }

    private Control createSearchFor(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(CSearchMessages.getString("CSearchPage.searchFor.label"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        group.setLayout((Layout)gridLayout);
        this.fSearchFor = new Button[this.fSearchForText.length];
        int n = 0;
        while (n < this.fSearchForText.length) {
            Button button = new Button((Composite)group, 32);
            button.setText(this.fSearchForText[n]);
            this.fSearchFor[n] = button;
            ++n;
        }
        return group;
    }

    protected List getSearchFor() {
        LinkedList<ICSearchConstants.SearchFor> linkedList = new LinkedList<ICSearchConstants.SearchFor>();
        int n = 0;
        while (n < this.fSearchFor.length) {
            if (this.fSearchFor[n].getSelection()) {
                linkedList.add(this.fSearchForValues[n]);
            }
            ++n;
        }
        return linkedList;
    }

    public void setContainer(ISearchPageContainer iSearchPageContainer) {
        this.fContainer = iSearchPageContainer;
    }

    private ISearchPageContainer getContainer() {
        return this.fContainer;
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings iDialogSettings = CUIPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = iDialogSettings.getSection(PAGE_NAME);
        if (this.fDialogSettings == null) {
            this.fDialogSettings = iDialogSettings.addNewSection(PAGE_NAME);
        }
        return this.fDialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        this.fIsCaseSensitive = iDialogSettings.getBoolean(STORE_CASE_SENSITIVE);
    }

    private void writeConfiguration() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        iDialogSettings.put(STORE_CASE_SENSITIVE, this.fIsCaseSensitive);
    }

    public void setVisible(boolean bl) {
        if (bl && this.fPattern != null) {
            if (this.fFirstTime) {
                this.fFirstTime = false;
                this.fPattern.setItems(this.getPreviousSearchPatterns());
                this.initSelections();
            }
            this.fPattern.setFocus();
            this.getContainer().setPerformActionEnabled(this.fPattern.getText().length() > 0 && this.getSearchFor().size() != 0);
        }
        super.setVisible(bl);
    }

    private void updateCaseSensitiveCheckbox() {
        if (this.fInitialData != null && this.getPattern().equals(this.fInitialData.pattern) && this.fCElement != null) {
            this.fCaseSensitive.setEnabled(false);
            this.fCaseSensitive.setSelection(true);
        } else {
            this.fCaseSensitive.setEnabled(true);
            this.fCaseSensitive.setSelection(this.fIsCaseSensitive);
        }
    }

    private void initSelections() {
        this.fStructuredSelection = this.asStructuredSelection();
        this.fInitialData = this.tryStructuredSelection(this.fStructuredSelection);
        this.updateSelections();
    }

    private void updateSelections() {
        if (this.fInitialData == null) {
            this.fInitialData = this.trySimpleTextSelection(this.getContainer().getSelection());
        }
        if (this.fInitialData == null) {
            this.fInitialData = this.getDefaultInitValues();
        }
        this.fCElement = this.fInitialData.cElement;
        this.fIsCaseSensitive = this.fInitialData.isCaseSensitive;
        this.fCaseSensitive.setSelection(this.fInitialData.isCaseSensitive);
        this.fCaseSensitive.setEnabled(this.fInitialData.cElement == null);
        HashSet hashSet = new HashSet(this.fInitialData.searchFor);
        boolean bl = !hashSet.contains(this.fSearchForValues[this.fSearchFor.length - 1]);
        int n = 0;
        while (n < this.fSearchFor.length) {
            this.fSearchFor[n].setSelection(hashSet.contains(this.fSearchForValues[n]));
            this.fSearchFor[n].setEnabled(bl);
            ++n;
        }
        if (!bl) {
            this.fSearchFor[this.fSearchFor.length - 1].setEnabled(true);
        }
        this.setLimitTo(this.fInitialData.searchFor);
        n = 0;
        while (n < this.fLimitTo.length) {
            this.fLimitTo[n].setSelection(this.fLimitToValues[n] == this.fInitialData.limitTo);
            ++n;
        }
        this.fPattern.setText(this.fInitialData.pattern);
    }

    private SearchPatternData tryStructuredSelection(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection == null || iStructuredSelection.size() > 1) {
            return null;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof ICElement) {
            return this.determineInitValuesFrom((ICElement)object);
        }
        if (object instanceof ISearchResultViewEntry) {
            ICElement iCElement = CSearchUtil.getCElement(((ISearchResultViewEntry)object).getSelectedMarker());
            return this.determineInitValuesFrom(iCElement);
        }
        if (object instanceof IAdaptable) {
            IWorkbenchAdapter iWorkbenchAdapter;
            ICElement iCElement;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iCElement = (ICElement)iAdaptable.getAdapter((Class)clazz)) != null) {
                return this.determineInitValuesFrom(iCElement);
            }
            IAdaptable iAdaptable2 = (IAdaptable)object;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iWorkbenchAdapter = (IWorkbenchAdapter)iAdaptable2.getAdapter((Class)clazz2)) != null) {
                LinkedList<ICSearchConstants.SearchFor> linkedList = new LinkedList<ICSearchConstants.SearchFor>();
                linkedList.add(ICSearchConstants.UNKNOWN_SEARCH_FOR);
                return new SearchPatternData(linkedList, ICSearchConstants.DECLARATIONS, this.fIsCaseSensitive, iWorkbenchAdapter.getLabel(object), null);
            }
        }
        return null;
    }

    private SearchPatternData trySimpleTextSelection(ISelection iSelection) {
        SearchPatternData searchPatternData = null;
        if (iSelection instanceof ITextSelection) {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new StringReader(((ITextSelection)iSelection).getText()));
            try {
                string = bufferedReader.readLine();
                if (string == null) {
                    string = "";
                }
            }
            catch (IOException iOException) {
                string = "";
            }
            LinkedList<ICSearchConstants.SearchFor> linkedList = new LinkedList<ICSearchConstants.SearchFor>();
            linkedList.add(ICSearchConstants.UNKNOWN_SEARCH_FOR);
            searchPatternData = new SearchPatternData(linkedList, ICSearchConstants.DECLARATIONS, this.fIsCaseSensitive, string, null);
        }
        return searchPatternData;
    }

    private SearchPatternData getDefaultInitValues() {
        LinkedList<ICSearchConstants.SearchFor> linkedList = new LinkedList<ICSearchConstants.SearchFor>();
        linkedList.add(ICSearchConstants.CLASS_STRUCT);
        return new SearchPatternData(linkedList, ICSearchConstants.DECLARATIONS, this.fIsCaseSensitive, "", null);
    }

    private String[] getPreviousSearchPatterns() {
        int n = fgPreviousSearchPatterns.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = ((SearchPatternData)CSearchPage.fgPreviousSearchPatterns.get((int)(n - 1 - n2))).pattern;
            ++n2;
        }
        return stringArray;
    }

    private IStructuredSelection asStructuredSelection() {
        ISelection iSelection;
        ISelectionProvider iSelectionProvider;
        IWorkbenchPart iWorkbenchPart;
        IWorkbenchPage iWorkbenchPage;
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null && (iWorkbenchPart = iWorkbenchPage.getActivePart()) != null && (iSelectionProvider = iWorkbenchPart.getSite().getSelectionProvider()) != null && (iSelection = iSelectionProvider.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)iSelection;
        }
        return StructuredSelection.EMPTY;
    }

    private SearchPatternData determineInitValuesFrom(ICElement iCElement) {
        if (iCElement == null) {
            return null;
        }
        LinkedList<ICSearchConstants.SearchFor> linkedList = new LinkedList<ICSearchConstants.SearchFor>();
        linkedList.add(CSearchUtil.getSearchForFromElement(iCElement));
        String string = iCElement.getElementName();
        ICSearchConstants.LimitTo limitTo = ICSearchConstants.ALL_OCCURRENCES;
        return new SearchPatternData(linkedList, limitTo, true, string, iCElement);
    }

    private SearchPatternData getPatternData() {
        String string = this.getPattern();
        SearchPatternData searchPatternData = null;
        int n = 0;
        int n2 = fgPreviousSearchPatterns.size();
        while (searchPatternData == null && n < n2) {
            searchPatternData = (SearchPatternData)fgPreviousSearchPatterns.get(n);
            ++n;
            if (string.equals(searchPatternData.pattern)) continue;
            searchPatternData = null;
        }
        if (searchPatternData == null) {
            searchPatternData = new SearchPatternData(this.getSearchFor(), this.getLimitTo(), string, this.fCaseSensitive.getSelection(), this.fCElement, this.getContainer().getSelectedScope(), this.getContainer().getSelectedWorkingSets());
            fgPreviousSearchPatterns.add(searchPatternData);
        } else {
            searchPatternData.searchFor = this.getSearchFor();
            searchPatternData.limitTo = this.getLimitTo();
            searchPatternData.isCaseSensitive = this.fCaseSensitive.getSelection();
            searchPatternData.cElement = this.fCElement;
            searchPatternData.scope = this.getContainer().getSelectedScope();
            searchPatternData.workingSets = this.getContainer().getSelectedWorkingSets();
        }
        return searchPatternData;
    }

    private static class SearchPatternData {
        List searchFor;
        ICSearchConstants.LimitTo limitTo;
        String pattern;
        boolean isCaseSensitive;
        ICElement cElement;
        int scope;
        IWorkingSet[] workingSets;

        public SearchPatternData(List list, ICSearchConstants.LimitTo limitTo, boolean bl, String string, ICElement iCElement) {
            this(list, limitTo, string, bl, iCElement, 0, null);
        }

        public SearchPatternData(List list, ICSearchConstants.LimitTo limitTo, String string, boolean bl, ICElement iCElement, int n, IWorkingSet[] iWorkingSetArray) {
            this.searchFor = list;
            this.limitTo = limitTo;
            this.pattern = string;
            this.isCaseSensitive = bl;
            this.cElement = iCElement;
            this.scope = n;
            this.workingSets = iWorkingSetArray;
        }
    }
}

