/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.internal.ui.search.CSearchMatch;
import org.eclipse.cdt.internal.ui.search.CSearchQuery;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class CSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    CSearchQuery cQuery;
    private static final Match[] NO_MATCHES = new Match[0];

    public CSearchResult(CSearchQuery cSearchQuery) {
        this.cQuery = cSearchQuery;
    }

    public Match[] findContainedMatches(IFile iFile) {
        ICElement iCElement = this.create(iFile);
        HashSet hashSet = new HashSet();
        this.collectMatches(hashSet, iCElement);
        return hashSet.toArray(new Match[hashSet.size()]);
    }

    private ICElement create(IFile iFile) {
        IProject iProject = iFile.getProject();
        ICProject iCProject = CCorePlugin.getDefault().getCoreModel().create(iProject);
        return iCProject;
    }

    private void collectMatches(Set set, ICElement iCElement) {
        Match[] matchArray = this.getMatches(iCElement);
        if (matchArray.length != 0) {
            int n = 0;
            while (n < matchArray.length) {
                set.add(matchArray[n]);
                ++n;
            }
        }
        if (iCElement instanceof IParent) {
            IParent iParent = (IParent)iCElement;
            try {
                ICElement[] iCElementArray = iParent.getChildren();
                int n = 0;
                while (n < iCElementArray.length) {
                    this.collectMatches(set, iCElementArray[n]);
                    ++n;
                }
            }
            catch (CModelException cModelException) {}
        }
    }

    public IFile getFile(Object object) {
        if (object instanceof ICElement) {
            ICElement iCElement = (ICElement)object;
            object = iCElement.getUnderlyingResource();
        }
        if (object instanceof IFile) {
            return (IFile)object;
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart iEditorPart) {
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        if (match.getElement() instanceof BasicSearchMatch) {
            BasicSearchMatch basicSearchMatch = (BasicSearchMatch)match.getElement();
            if (iEditorInput instanceof IFileEditorInput) {
                IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
                IResource iResource = basicSearchMatch.getResource();
                if (iResource != null) {
                    return iFile.equals((Object)iResource);
                }
                return false;
            }
        } else if (match instanceof CSearchMatch) {
            BasicSearchMatch basicSearchMatch = ((CSearchMatch)match).getSearchMatch();
            if (iEditorInput instanceof IFileEditorInput) {
                IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
                IResource iResource = basicSearchMatch.getResource();
                if (iResource != null) {
                    return iFile.equals((Object)iResource);
                }
                return false;
            }
        } else if (match.getElement() instanceof IFile && iEditorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)iEditorInput).getFile().equals(match.getElement());
        }
        return false;
    }

    public Match[] findContainedMatches(IEditorPart iEditorPart) {
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            return this.findContainedMatches(iFileEditorInput.getFile());
        }
        return null;
    }

    public String getText() {
        int n = this.getMatchCount();
        String string = null;
        string = n == 1 ? this.cQuery.getSingularLabel() : this.cQuery.getPluralLabelPattern();
        return MessageFormat.format(string, new Integer(n));
    }

    public String getTooltip() {
        return this.getText();
    }

    public ImageDescriptor getImageDescriptor() {
        return this.cQuery.getImageDescriptor();
    }

    public ISearchQuery getQuery() {
        return this.cQuery;
    }

    public String getLabel() {
        int n = this.getMatchCount();
        String string = null;
        if (n == 1) {
            return this.cQuery.getSingularLabel();
        }
        string = this.cQuery.getPluralLabelPattern();
        return MessageFormat.format(string, new Integer(n));
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult abstractTextSearchResult, IEditorPart iEditorPart) {
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            return this.computeContainedMatches(abstractTextSearchResult, iFileEditorInput.getFile());
        }
        return null;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult abstractTextSearchResult, IFile iFile) {
        ICElement iCElement = CoreModel.getDefault().create(iFile);
        if (!(iCElement instanceof ITranslationUnit)) {
            return NO_MATCHES;
        }
        HashSet hashSet = new HashSet();
        Object[] objectArray = abstractTextSearchResult.getElements();
        this.collectMatches(hashSet, objectArray, iFile);
        return hashSet.toArray(new Match[hashSet.size()]);
    }

    private void collectMatches(Set set, Object[] objectArray, IFile iFile) {
        int n = 0;
        while (n < objectArray.length) {
            Match[] matchArray = this.getMatches(objectArray[n]);
            int n2 = 0;
            while (n2 < matchArray.length) {
                if (((CSearchMatch)matchArray[n2]).getSearchMatch().getResource().equals((Object)iFile)) {
                    set.add(matchArray[n2]);
                }
                ++n2;
            }
            ++n;
        }
    }
}

