/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.search.CSearchContentProvider;
import org.eclipse.cdt.internal.ui.search.CSearchMatch;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchTableContentProvider;
import org.eclipse.cdt.internal.ui.search.CountLabelProvider;
import org.eclipse.cdt.internal.ui.search.ElementNameSorter;
import org.eclipse.cdt.internal.ui.search.LevelTreeContentProvider;
import org.eclipse.cdt.internal.ui.search.ParentNameSorter;
import org.eclipse.cdt.internal.ui.search.PathNameSorter;
import org.eclipse.cdt.internal.ui.search.actions.GroupAction;
import org.eclipse.cdt.internal.ui.search.actions.SortAction;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CSearchResultLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class CSearchResultPage
extends AbstractTextSearchViewPage {
    private CSearchContentProvider _contentProvider;
    private int _currentSortOrder = 1;
    private int _currentGrouping;
    private SortAction _parentSortAction = new SortAction(CSearchMessages.getString("CSearchResultPage.parent_name"), this, 2);
    private SortAction _pathSortAction = new SortAction(CSearchMessages.getString("CSearchResultPage.path_name"), this, 3);
    private SortAction _elementNameSortAction = new SortAction(CSearchMessages.getString("CSearchResultPage.element_name"), this, 1);
    private GroupAction _groupFileAction;
    private GroupAction _groupFoldersAction;
    private GroupAction _groupProjectAction;
    private GroupAction _groupClassAction;
    private static final String KEY_GROUPING = "org.eclipse.cdt.search.resultpage.grouping";

    public CSearchResultPage() {
        this.initGroupingActions();
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.cdt.ui.search_view");
    }

    private void initGroupingActions() {
        this._groupProjectAction = new GroupAction(CSearchMessages.getString("CSearchResultPage.groupby_project"), CSearchMessages.getString("CSearchResultPage.groupby_project.tooltip"), this, 4);
        this._groupProjectAction.setImageDescriptor(CPluginImages.DESC_OBJS_SEARCHHIERPROJECT);
        this._groupFoldersAction = new GroupAction(CSearchMessages.getString("CSearchResultPage.groupby_folder"), CSearchMessages.getString("CSearchResultPage.groupby_folder.tooltip"), this, 3);
        this._groupFoldersAction.setImageDescriptor(CPluginImages.DESC_OBJS_SEARCHHIERFODLER);
        this._groupFileAction = new GroupAction(CSearchMessages.getString("CSearchResultPage.groupby_file"), CSearchMessages.getString("CSearchResultPage.groupby_file.tooltip"), this, 2);
        this._groupFileAction.setImageDescriptor(CPluginImages.DESC_OBJS_TUNIT);
        this._groupClassAction = new GroupAction(CSearchMessages.getString("CSearchResultPage.groupby_class"), CSearchMessages.getString("CSearchResultPage.groupby_class.tooltip"), this, 1);
        this._groupClassAction.setImageDescriptor(CPluginImages.DESC_OBJS_CLASS);
        try {
            this._currentGrouping = this.getSettings().getInt(KEY_GROUPING);
        }
        catch (NumberFormatException numberFormatException) {
            this._currentGrouping = 4;
        }
    }

    protected void showMatch(Match match, int n, int n2, boolean bl) throws PartInitException {
        ICElement iCElement;
        IEditorPart iEditorPart = null;
        Object object = match.getElement();
        if (object instanceof ICElement) {
            iCElement = (ICElement)object;
            try {
                iEditorPart = EditorUtility.openInEditor(iCElement, false);
            }
            catch (PartInitException partInitException) {
                return;
            }
            catch (CModelException cModelException) {
                cModelException.printStackTrace();
            }
        } else if (object instanceof IFile) {
            iEditorPart = IDE.openEditor((IWorkbenchPage)CUIPlugin.getActivePage(), (IFile)this.getCanonicalFile((IFile)object), (boolean)false);
        } else if (match instanceof CSearchMatch) {
            iCElement = ((CSearchMatch)match).getSearchMatch();
            if (iCElement.resource != null) {
                iEditorPart = IDE.openEditor((IWorkbenchPage)CUIPlugin.getActivePage(), (IFile)this.getCanonicalFile((IFile)iCElement.resource), (boolean)false);
                this.showWithMarker(iEditorPart, this.getCanonicalFile((IFile)iCElement.resource), n, n2);
            }
        }
        if (iEditorPart instanceof ITextEditor) {
            iCElement = (ITextEditor)iEditorPart;
            iCElement.selectAndReveal(n, n2);
        } else if (iEditorPart != null && object instanceof IFile) {
            iCElement = (IFile)object;
            this.showWithMarker(iEditorPart, this.getCanonicalFile((IFile)iCElement), n, n2);
        }
    }

    protected void elementsChanged(Object[] objectArray) {
        if (this._contentProvider != null) {
            this._contentProvider.elementsChanged(objectArray);
        }
    }

    protected void clear() {
        if (this._contentProvider != null) {
            this._contentProvider.clear();
        }
    }

    protected void configureTreeViewer(TreeViewer treeViewer) {
        treeViewer.setSorter(new ViewerSorter());
        CSearchResultLabelProvider cSearchResultLabelProvider = new CSearchResultLabelProvider();
        cSearchResultLabelProvider.setOrder(0);
        treeViewer.setLabelProvider((IBaseLabelProvider)new CountLabelProvider(this, (ILabelProvider)cSearchResultLabelProvider));
        this._contentProvider = new LevelTreeContentProvider((AbstractTreeViewer)treeViewer, this._currentGrouping);
        treeViewer.setContentProvider((IContentProvider)this._contentProvider);
    }

    protected void configureTableViewer(TableViewer tableViewer) {
        tableViewer.setLabelProvider((IBaseLabelProvider)new CountLabelProvider(this, (ILabelProvider)new CSearchResultLabelProvider()));
        this._contentProvider = new CSearchTableContentProvider(tableViewer);
        tableViewer.setContentProvider((IContentProvider)this._contentProvider);
        this.setSortOrder(this._currentSortOrder);
    }

    private void showWithMarker(IEditorPart iEditorPart, IFile iFile, int n, int n2) throws PartInitException {
        try {
            IMarker iMarker = iFile.createMarker("org.eclipse.search.searchmarker");
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(4);
            hashMap.put("charStart", new Integer(n));
            hashMap.put("charEnd", new Integer(n + n2));
            iMarker.setAttributes(hashMap);
            IDE.gotoMarker((IEditorPart)iEditorPart, (IMarker)iMarker);
            iMarker.delete();
        }
        catch (CoreException coreException) {
            throw new PartInitException("Search Result Error", (Throwable)coreException);
        }
    }

    public void setSortOrder(int n) {
        this._currentSortOrder = n;
        StructuredViewer structuredViewer = this.getViewer();
        CountLabelProvider countLabelProvider = (CountLabelProvider)structuredViewer.getLabelProvider();
        ((CSearchResultLabelProvider)countLabelProvider.getLabelProvider()).setOrder(n);
        if (n == 1) {
            structuredViewer.setSorter((ViewerSorter)new ElementNameSorter());
        } else if (n == 3) {
            structuredViewer.setSorter((ViewerSorter)new PathNameSorter());
        } else {
            structuredViewer.setSorter((ViewerSorter)new ParentNameSorter());
        }
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        this.addSortActions(iMenuManager);
    }

    private void addSortActions(IMenuManager iMenuManager) {
        if (this.getLayout() != 1) {
            return;
        }
        MenuManager menuManager = new MenuManager(CSearchMessages.getString("CSearchResultPage.sort"));
        menuManager.add((IAction)this._elementNameSortAction);
        menuManager.add((IAction)this._pathSortAction);
        menuManager.add((IAction)this._parentSortAction);
        this._elementNameSortAction.setChecked(this._currentSortOrder == this._elementNameSortAction.getSortOrder());
        this._pathSortAction.setChecked(this._currentSortOrder == this._pathSortAction.getSortOrder());
        this._parentSortAction.setChecked(this._currentSortOrder == this._parentSortAction.getSortOrder());
        iMenuManager.appendToGroup("group.viewerSetup", (IContributionItem)menuManager);
    }

    private void addGroupActions(IToolBarManager iToolBarManager) {
        iToolBarManager.appendToGroup("group.viewerSetup", (IAction)this._groupProjectAction);
        iToolBarManager.appendToGroup("group.viewerSetup", (IAction)this._groupFoldersAction);
        iToolBarManager.appendToGroup("group.viewerSetup", (IAction)this._groupFileAction);
        iToolBarManager.appendToGroup("group.viewerSetup", (IAction)this._groupClassAction);
        this.updateGroupingActions();
    }

    public void setGrouping(int n) {
        this._currentGrouping = n;
        StructuredViewer structuredViewer = this.getViewer();
        LevelTreeContentProvider levelTreeContentProvider = (LevelTreeContentProvider)structuredViewer.getContentProvider();
        levelTreeContentProvider.setLevel(n);
        this.updateGroupingActions();
        this.getSettings().put(KEY_GROUPING, this._currentGrouping);
    }

    private void updateGroupingActions() {
        this._groupProjectAction.setChecked(this._currentGrouping == 4);
        this._groupFoldersAction.setChecked(this._currentGrouping == 3);
        this._groupFileAction.setChecked(this._currentGrouping == 2);
        this._groupClassAction.setChecked(this._currentGrouping == 1);
    }

    protected void fillToolbar(IToolBarManager iToolBarManager) {
        super.fillToolbar(iToolBarManager);
        if (this.getLayout() != 1) {
            this.addGroupActions(iToolBarManager);
        }
    }

    private IFile getCanonicalFile(IFile iFile) {
        if (iFile == null) {
            return null;
        }
        File file = iFile.getRawLocation().toFile();
        String string = null;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {}
        if (string != null && !iFile.isLinked()) {
            Path path = new Path(string);
            iFile = CUIPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        }
        return iFile;
    }
}

