/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class CSearchScopeFactory {
    private static CSearchScopeFactory fgInstance;
    private static ICSearchScope EMPTY_SCOPE;
    static /* synthetic */ Class class$0;

    static {
        EMPTY_SCOPE = SearchEngine.createCSearchScope((ICElement[])new ICElement[0]);
    }

    public static CSearchScopeFactory getInstance() {
        if (fgInstance == null) {
            fgInstance = new CSearchScopeFactory();
        }
        return fgInstance;
    }

    public ICSearchScope createCSearchScope(IWorkingSet[] iWorkingSetArray) {
        if (iWorkingSetArray == null || iWorkingSetArray.length < 1) {
            return EMPTY_SCOPE;
        }
        HashSet hashSet = new HashSet(iWorkingSetArray.length * 10);
        int n = 0;
        while (n < iWorkingSetArray.length) {
            this.addCElements(hashSet, iWorkingSetArray[n]);
            ++n;
        }
        return this.createCSearchScope(hashSet);
    }

    private ICSearchScope createCSearchScope(Set set) {
        return SearchEngine.createCSearchScope((ICElement[])set.toArray(new ICElement[set.size()]));
    }

    private void addCElements(Set set, IWorkingSet iWorkingSet) {
        if (iWorkingSet == null) {
            return;
        }
        IAdaptable[] iAdaptableArray = iWorkingSet.getElements();
        int n = 0;
        while (n < iAdaptableArray.length) {
            if (iAdaptableArray[n] instanceof ICElement) {
                this.addCElements(set, (ICElement)iAdaptableArray[n]);
            } else {
                this.addCElements(set, iAdaptableArray[n]);
            }
            ++n;
        }
    }

    private void addCElements(Set set, IAdaptable iAdaptable) {
        ICElement iCElement;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.ICElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iCElement = (ICElement)iAdaptable.getAdapter((Class)clazz)) == null) {
            return;
        }
        this.addCElements(set, iCElement);
    }

    private void addCElements(Set set, ICElement iCElement) {
        set.add(iCElement);
    }

    public ICSearchScope createCSearchScope(IStructuredSelection iStructuredSelection) {
        HashSet hashSet = new HashSet(iStructuredSelection.size());
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof ICElement) {
                this.addCElements(hashSet, (ICElement)e);
                continue;
            }
            if (e instanceof BasicSearchMatch) {
                this.addCElements(hashSet, (BasicSearchMatch)e);
                continue;
            }
            if (!(e instanceof IResource)) continue;
            this.addCElements(hashSet, (IAdaptable)((IResource)e));
        }
        return this.createCSearchScope(hashSet);
    }

    private void addCElements(Set set, BasicSearchMatch basicSearchMatch) {
        ICElement iCElement;
        IResource iResource = basicSearchMatch.getResource();
        if (iResource != null && (iCElement = CCorePlugin.getDefault().getCoreModel().create(iResource)) != null) {
            set.add(iCElement);
        }
    }

    public IWorkingSet[] queryWorkingSets() {
        IWorkingSet[] iWorkingSetArray;
        Shell shell = CUIPlugin.getActiveWorkbenchShell();
        if (shell == null) {
            return null;
        }
        IWorkingSetSelectionDialog iWorkingSetSelectionDialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(shell, true);
        if (iWorkingSetSelectionDialog.open() == 0 && (iWorkingSetArray = iWorkingSetSelectionDialog.getSelection()).length > 0) {
            return iWorkingSetArray;
        }
        return null;
    }
}

