/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.core.resources.IMarker;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;

public class CSearchUtil {
    public static void updateLRUWorkingSets(IWorkingSet[] iWorkingSetArray) {
    }

    public static void warnIfBinaryConstant(ICElement iCElement, Shell shell) {
    }

    public static Object toString(IWorkingSet[] iWorkingSetArray) {
        if (iWorkingSetArray != null & iWorkingSetArray.length > 0) {
            String string = new String();
            int n = 0;
            while (n < iWorkingSetArray.length) {
                if (n > 0) {
                    string = String.valueOf(string) + ", ";
                }
                string = String.valueOf(string) + iWorkingSetArray[n].getName();
                ++n;
            }
            return string;
        }
        return null;
    }

    public static ICElement getCElement(IMarker iMarker) {
        return null;
    }

    public static ICSearchConstants.SearchFor getSearchForFromElement(ICElement iCElement) {
        if (iCElement == null) {
            return null;
        }
        ICSearchConstants.SearchFor searchFor = null;
        String string = iCElement.getElementName();
        boolean bl = string.indexOf("::") != -1;
        switch (iCElement.getElementType()) {
            case 70: 
            case 71: 
            case 80: {
                if (bl) {
                    searchFor = ICSearchConstants.METHOD;
                    break;
                }
                searchFor = ICSearchConstants.FUNCTION;
                break;
            }
            case 74: {
                searchFor = ICSearchConstants.VAR;
                break;
            }
            case 64: 
            case 65: 
            case 73: {
                searchFor = ICSearchConstants.CLASS_STRUCT;
                break;
            }
            case 66: {
                searchFor = ICSearchConstants.UNION;
                break;
            }
            case 69: 
            case 79: {
                searchFor = ICSearchConstants.FIELD;
                break;
            }
            case 67: 
            case 68: 
            case 81: {
                searchFor = ICSearchConstants.METHOD;
                break;
            }
            case 61: {
                searchFor = ICSearchConstants.NAMESPACE;
                break;
            }
            case 63: {
                searchFor = ICSearchConstants.ENUM;
                break;
            }
            default: {
                searchFor = ICSearchConstants.UNKNOWN_SEARCH_FOR;
            }
        }
        return searchFor;
    }

    public static ICSearchConstants.SearchFor getSearchForFromNode(IASTOffsetableNamedElement iASTOffsetableNamedElement) {
        ICSearchConstants.SearchFor searchFor = null;
        if (iASTOffsetableNamedElement instanceof IASTClassSpecifier) {
            IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTOffsetableNamedElement;
            if (iASTClassSpecifier.getClassKind().equals(ASTClassKind.CLASS)) {
                searchFor = ICSearchConstants.CLASS;
            } else if (iASTClassSpecifier.getClassKind().equals(ASTClassKind.STRUCT)) {
                searchFor = ICSearchConstants.STRUCT;
            } else if (iASTClassSpecifier.getClassKind().equals(ASTClassKind.UNION)) {
                searchFor = ICSearchConstants.UNION;
            }
        } else if (iASTOffsetableNamedElement instanceof IASTMethod) {
            searchFor = ICSearchConstants.METHOD;
        } else if (iASTOffsetableNamedElement instanceof IASTFunction) {
            searchFor = ICSearchConstants.FUNCTION;
        } else if (iASTOffsetableNamedElement instanceof IASTField) {
            searchFor = ICSearchConstants.FIELD;
        } else if (iASTOffsetableNamedElement instanceof IASTVariable) {
            searchFor = ICSearchConstants.VAR;
        } else if (iASTOffsetableNamedElement instanceof IASTEnumerationSpecifier) {
            searchFor = ICSearchConstants.ENUM;
        } else if (iASTOffsetableNamedElement instanceof IASTNamespaceDefinition) {
            searchFor = ICSearchConstants.NAMESPACE;
        } else if (iASTOffsetableNamedElement instanceof IASTTypedefDeclaration) {
            searchFor = ICSearchConstants.TYPEDEF;
        } else if (iASTOffsetableNamedElement instanceof IASTEnumerator) {
            searchFor = ICSearchConstants.ENUMTOR;
        }
        return searchFor;
    }
}

