/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.search.CSearchUtil;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.util.SelectionUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.IDE;

public class GotoMarkerAction
extends Action {
    public void run() {
        ISearchResultView iSearchResultView = SearchUI.getSearchResultView();
        Object object = SelectionUtil.getSingleElement(iSearchResultView.getSelection());
        if (object instanceof ISearchResultViewEntry) {
            ISearchResultViewEntry iSearchResultViewEntry = (ISearchResultViewEntry)object;
            this.show(iSearchResultViewEntry.getSelectedMarker());
        }
    }

    private void show(IMarker iMarker) {
        IResource iResource = iMarker.getResource();
        if (iResource == null || !iResource.exists()) {
            return;
        }
        IWorkbenchPage iWorkbenchPage = CUIPlugin.getActivePage();
        ICElement iCElement = CSearchUtil.getCElement(iMarker);
        if (SearchUI.reuseEditor()) {
            this.showWithReuse(iMarker, iResource, iCElement, iWorkbenchPage);
        } else {
            this.showWithoutReuse(iMarker, iCElement, iWorkbenchPage);
        }
    }

    private void showWithoutReuse(IMarker iMarker, ICElement iCElement, IWorkbenchPage iWorkbenchPage) {
        IEditorPart iEditorPart = null;
        try {
            ICElement iCElement2 = iCElement != null ? iCElement : iMarker.getResource();
            iEditorPart = EditorUtility.openInEditor(iCElement2, false);
        }
        catch (CoreException coreException) {}
        if (iEditorPart != null) {
            IDE.gotoMarker(iEditorPart, (IMarker)iMarker);
        }
    }

    private void showWithReuse(IMarker iMarker, IResource iResource, ICElement iCElement, IWorkbenchPage iWorkbenchPage) {
        if (!(iResource instanceof IFile)) {
            return;
        }
        IEditorPart iEditorPart = EditorUtility.isOpenInEditor(iCElement);
        if (iEditorPart != null) {
            iWorkbenchPage.bringToTop((IWorkbenchPart)iEditorPart);
        }
    }
}

