/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.internal.ui.search.CSearchContentProvider;
import org.eclipse.cdt.internal.ui.search.CSearchMatch;
import org.eclipse.cdt.internal.ui.search.CSearchResult;
import org.eclipse.cdt.ui.CElementContentProvider;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Control;

public class LevelTreeContentProvider
extends CSearchContentProvider
implements ITreeContentProvider {
    private AbstractTreeViewer fTreeViewer;
    private Map fChildrenMap;
    private CElementContentProvider fContentProvider;
    private static int[][] C_ELEMENT_TYPES = new int[][]{{64}, {60, 61}, {12}, {11}, {10}};
    private static int[][] RESOURCE_TYPES = new int[][]{new int[0], {1}, {2}, {4}, {8}};
    private static final int MAX_LEVEL = C_ELEMENT_TYPES.length - 1;
    private int fCurrentLevel;
    public static final int LEVEL_CLASS = 1;
    public static final int LEVEL_FILE = 2;
    public static final int LEVEL_FOLDER = 3;
    public static final int LEVEL_PROJECT = 4;

    public LevelTreeContentProvider(AbstractTreeViewer abstractTreeViewer, int n) {
        this.fTreeViewer = abstractTreeViewer;
        this.fCurrentLevel = n;
        this.fContentProvider = new CElementContentProvider();
    }

    public Object getParent(Object object) {
        Object object2;
        block13: {
            BasicSearchMatch basicSearchMatch;
            block12: {
                object2 = null;
                if (object instanceof CSearchMatch) {
                    basicSearchMatch = ((CSearchMatch)((Object)object)).getSearchMatch();
                    ICElement iCElement = CCorePlugin.getDefault().getCoreModel().create(basicSearchMatch.getResource());
                    if (iCElement instanceof ITranslationUnit) {
                        try {
                            object = ((ITranslationUnit)iCElement).getElementAtOffset(basicSearchMatch.startOffset);
                        }
                        catch (CModelException cModelException) {}
                    }
                    if (object == null) {
                        object2 = iCElement;
                    }
                }
                if (object != null) {
                    object2 = this.internalGetParent(object);
                }
                if (!(object2 instanceof ICElement)) break block12;
                basicSearchMatch = (ICElement)object2;
                int n = this.fCurrentLevel;
                while (n < MAX_LEVEL + 1) {
                    int n2 = 0;
                    while (n2 < C_ELEMENT_TYPES[n].length) {
                        if (basicSearchMatch.getElementType() == C_ELEMENT_TYPES[n][n2]) {
                            return null;
                        }
                        ++n2;
                    }
                    ++n;
                }
                break block13;
            }
            if (!(object2 instanceof IResource)) break block13;
            basicSearchMatch = (IResource)object2;
            int n = this.fCurrentLevel;
            while (n < MAX_LEVEL + 1) {
                int n3 = 0;
                while (n3 < RESOURCE_TYPES[n].length) {
                    if (basicSearchMatch.getType() == RESOURCE_TYPES[n][n3]) {
                        return null;
                    }
                    ++n3;
                }
                ++n;
            }
        }
        return object2;
    }

    private Object internalGetParent(Object object) {
        return this.fContentProvider.getParent(object);
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    protected synchronized void initialize(CSearchResult cSearchResult) {
        super.initialize(cSearchResult);
        this.fChildrenMap = new HashMap();
        if (cSearchResult != null) {
            Object[] objectArray = cSearchResult.getElements();
            int n = 0;
            while (n < objectArray.length) {
                this.insert(objectArray[n], false);
                ++n;
            }
        }
    }

    protected void insert(Object object, boolean bl) {
        Object object2 = this.getMatchParent(object);
        while (object2 != null) {
            if (this.insertChild(object2, object)) {
                if (bl) {
                    this.fTreeViewer.add(object2, object);
                }
            } else {
                if (bl) {
                    this.fTreeViewer.refresh(object2);
                }
                return;
            }
            object = object2;
            object2 = this.getParent(object);
        }
        if (this.insertChild((Object)this._result, object) && bl) {
            this.fTreeViewer.add((Object)this._result, object);
        }
    }

    private Object getMatchParent(Object object) {
        Match[] matchArray = null;
        if (object instanceof String) {
            matchArray = this._result.getMatches(object);
        }
        if (matchArray.length > 0) {
            return this.getParent(matchArray[0]);
        }
        return null;
    }

    private boolean insertChild(Object object, Object object2) {
        HashSet<Object> hashSet = (HashSet<Object>)this.fChildrenMap.get(object);
        if (hashSet == null) {
            hashSet = new HashSet<Object>();
            this.fChildrenMap.put(object, hashSet);
        }
        return hashSet.add(object2);
    }

    protected void remove(Object object, boolean bl) {
        if (this.hasChildren(object)) {
            if (bl) {
                this.fTreeViewer.refresh(object);
            }
        } else if (this._result.getMatchCount(object) == 0) {
            this.fChildrenMap.remove(object);
            Object object2 = this.getParent(object);
            if (object2 != null) {
                this.removeFromSiblings(object, object2);
                this.remove(object2, bl);
            } else {
                this.removeFromSiblings(object, (Object)this._result);
                if (bl) {
                    this.fTreeViewer.refresh();
                }
            }
        } else if (bl) {
            this.fTreeViewer.refresh(object);
        }
    }

    private void removeFromSiblings(Object object, Object object2) {
        Set set = (Set)this.fChildrenMap.get(object2);
        if (set != null) {
            set.remove(object);
        }
    }

    public Object[] getChildren(Object object) {
        Set set = (Set)this.fChildrenMap.get(object);
        if (set == null) {
            return this.EMPTY_ARR;
        }
        return set.toArray();
    }

    public boolean hasChildren(Object object) {
        return this.getChildren(object).length > 0;
    }

    public synchronized void elementsChanged(Object[] objectArray) {
        if (this._result == null) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (this._result.getMatchCount(objectArray[n]) > 0) {
                this.insert(objectArray[n], true);
            } else {
                this.remove(objectArray[n], true);
            }
            ++n;
        }
    }

    public void clear() {
        this.initialize(this._result);
        this.fTreeViewer.refresh();
    }

    public void setLevel(int n) {
        this.fCurrentLevel = n;
        Control control = this.fTreeViewer.getControl();
        if (control != null) {
            control.setRedraw(false);
        }
        this.initialize(this._result);
        this.fTreeViewer.refresh();
        if (control != null) {
            control.setRedraw(true);
        }
    }
}

