/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.BasicSearchResultCollector;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.internal.ui.search.CSearchMatch;
import org.eclipse.cdt.internal.ui.search.CSearchResult;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.search.ui.text.Match;

public class NewSearchResultCollector
extends BasicSearchResultCollector {
    public static final int PARENT_LENGTH = 7;
    public static final String PARENT = "PARENT:";
    public static final int NAME_LENGTH = 5;
    public static final String NAME = "NAME:";
    public static final int LOCATION_LENGTH = 9;
    public static final String LOCATION = "LOCATION:";
    public static final int ELEMENTTYPE_LENGTH = 12;
    public static final String ELEMENTTYPE = "ELEMENTTYPE:";
    public static final int VISIBILITY_LENGTH = 11;
    public static final String VISIBILITY = "VISIBILITY:";
    private CSearchResult fSearch;
    private IProgressMonitor fProgressMonitor;
    private int fMatchCount;

    public NewSearchResultCollector(CSearchResult cSearchResult, IProgressMonitor iProgressMonitor) {
        this.fSearch = cSearchResult;
        this.fProgressMonitor = iProgressMonitor;
        this.fMatchCount = 0;
    }

    public void accept(IResource iResource, int n, int n2, ICElement iCElement, int n3) {
        ++this.fMatchCount;
        this.fSearch.addMatch(new Match((Object)iCElement, n, n2 - n));
    }

    public void done() {
    }

    public IProgressMonitor getProgressMonitor() {
        return this.fProgressMonitor;
    }

    public int getMatchCount() {
        return this.fMatchCount;
    }

    public boolean acceptMatch(IMatch iMatch) throws CoreException {
        BasicSearchMatch basicSearchMatch = (BasicSearchMatch)iMatch;
        if (!super.acceptMatch(iMatch)) {
            return false;
        }
        if (basicSearchMatch.resource == null && basicSearchMatch.path == null) {
            return false;
        }
        if (basicSearchMatch.resource != null) {
            ++this.fMatchCount;
            int n = iMatch.getStartOffset();
            int n2 = iMatch.getEndOffset();
            String string = PARENT + iMatch.getParentName() + NAME + iMatch.getName() + LOCATION + iMatch.getLocation().toOSString() + ELEMENTTYPE + iMatch.getElementType() + VISIBILITY + iMatch.getVisibility();
            this.fSearch.addMatch(new CSearchMatch(string, n, n2 - n, iMatch));
            return true;
        }
        IPreferenceStore iPreferenceStore = CUIPlugin.getDefault().getPreferenceStore();
        if (iPreferenceStore.getBoolean("externMatchEnable")) {
            int n;
            IPath iPath = basicSearchMatch.getReferenceLocation();
            IFile iFile = CCorePlugin.getWorkspace().getRoot().getFileForLocation(iPath);
            IProject iProject = iFile.getProject();
            IPath iPath2 = basicSearchMatch.getLocation();
            IFile iFile2 = this.getUniqueFile(iPath2, iProject);
            if (iFile2.exists() && iFile2.isLinked()) {
                iFile2.delete(true, null);
            }
            if (!iFile2.exists()) {
                iFile2.createLink(iPath2, 0, null);
                n = iPreferenceStore.getInt("externMatchVisible");
                if (n == 0) {
                    iFile2.setTeamPrivateMember(true);
                }
            }
            basicSearchMatch.resource = iFile2;
            basicSearchMatch.path = iPath2;
            ++this.fMatchCount;
            n = iMatch.getStartOffset();
            int n3 = iMatch.getEndOffset();
            String string = PARENT + iMatch.getParentName() + NAME + iMatch.getName() + LOCATION + iMatch.getLocation().toOSString() + ELEMENTTYPE + iMatch.getElementType() + VISIBILITY + iMatch.getVisibility();
            this.fSearch.addMatch(new CSearchMatch(string, n, n3 - n, iMatch));
            return true;
        }
        return false;
    }

    private IFile getUniqueFile(IPath iPath, IProject iProject) {
        IFile iFile = null;
        String string = "";
        int n = iPath.segmentCount() - 1;
        int n2 = 0;
        while (n2 < Integer.MAX_VALUE) {
            iFile = iProject.getFile(string = string != "" ? "cdtlnk" + n2 + "_" + iPath.segment(n) : iPath.segment(n));
            IPath iPath2 = iFile.getLocation();
            if (iPath.equals((Object)iPath2) || !iFile.exists()) break;
            ++n2;
        }
        return iFile;
    }
}

