/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import java.util.LinkedList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.ParseError;
import org.eclipse.cdt.core.parser.ast.ASTUtil;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTQualifiedNameElement;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.search.CSearchQuery;
import org.eclipse.cdt.internal.ui.search.CSearchResultCollector;
import org.eclipse.cdt.internal.ui.search.CSearchUtil;
import org.eclipse.cdt.internal.ui.search.actions.SelectionParseAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IWorkbenchSite;

public abstract class FindAction
extends SelectionParseAction {
    public FindAction(CEditor cEditor) {
        super(cEditor);
    }

    public FindAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
    }

    protected CSearchQuery createSearchQuery(String string, ICSearchConstants.SearchFor searchFor) {
        CSearchQuery cSearchQuery = null;
        ICSearchScope iCSearchScope = this.getScope();
        if (iCSearchScope == null) {
            return null;
        }
        String string2 = this.getScopeDescription();
        LinkedList<ICSearchConstants.SearchFor> linkedList = new LinkedList<ICSearchConstants.SearchFor>();
        linkedList.add(searchFor);
        CSearchResultCollector cSearchResultCollector = new CSearchResultCollector();
        ICSearchConstants.LimitTo limitTo = this.getLimitTo();
        cSearchQuery = new CSearchQuery(CCorePlugin.getWorkspace(), string, true, linkedList, limitTo, iCSearchScope, string2, cSearchResultCollector);
        return cSearchQuery;
    }

    protected CSearchQuery createSearchQuery(IASTOffsetableNamedElement iASTOffsetableNamedElement) {
        int n;
        String[] stringArray;
        String string = null;
        if (iASTOffsetableNamedElement instanceof IASTQualifiedNameElement) {
            stringArray = ((IASTQualifiedNameElement)iASTOffsetableNamedElement).getFullyQualifiedName();
            string = "::" + stringArray[0];
            n = 1;
            while (n < stringArray.length) {
                string = String.valueOf(string) + "::";
                string = String.valueOf(string) + stringArray[n];
                ++n;
            }
        } else {
            string = iASTOffsetableNamedElement.getName();
        }
        if (iASTOffsetableNamedElement instanceof IASTFunction) {
            string = String.valueOf(string) + '(';
            stringArray = ASTUtil.getFunctionParameterTypes((IASTFunction)((IASTFunction)iASTOffsetableNamedElement));
            n = 0;
            while (n < stringArray.length) {
                if (n != 0) {
                    string = String.valueOf(string) + ", ";
                }
                string = String.valueOf(string) + stringArray[n];
                ++n;
            }
            string = String.valueOf(string) + ')';
        }
        return this.createSearchQuery(string, CSearchUtil.getSearchForFromNode(iASTOffsetableNamedElement));
    }

    public void run() {
        ISelection iSelection = this.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            this.run((IStructuredSelection)iSelection);
        } else if (iSelection instanceof ITextSelection) {
            this.run((ITextSelection)iSelection);
        }
    }

    public void run(IStructuredSelection iStructuredSelection) {
        Object object = iStructuredSelection.getFirstElement();
        if (object == null || !(object instanceof ICElement)) {
            this.operationNotAvailable();
            return;
        }
        this.clearStatusLine();
        ICElement iCElement = (ICElement)object;
        CSearchQuery cSearchQuery = this.createSearchQuery(iCElement.getElementName(), CSearchUtil.getSearchForFromElement(iCElement));
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQuery((ISearchQuery)cSearchQuery);
    }

    public void run(ITextSelection iTextSelection) {
        IASTOffsetableNamedElement iASTOffsetableNamedElement;
        block8: {
            if (iTextSelection == null) {
                return;
            }
            SelectionParseAction.SelSearchNode selSearchNode = this.getSelection(iTextSelection);
            int n = selSearchNode.selStart;
            int n2 = selSearchNode.selEnd;
            IFile iFile = this.fEditor.getInputFile();
            IParser iParser = this.setupParser(iFile);
            iASTOffsetableNamedElement = null;
            IParser.ISelectionParseResult iSelectionParseResult = null;
            try {
                iSelectionParseResult = iParser.parse(n, n2);
                if (iSelectionParseResult != null) {
                    iASTOffsetableNamedElement = iSelectionParseResult.getOffsetableNamedElement();
                }
            }
            catch (ParseError parseError) {
            }
            catch (Exception exception) {
            }
            catch (VirtualMachineError virtualMachineError) {
                if (!(virtualMachineError instanceof OutOfMemoryError)) break block8;
                Util.log(null, (String)("Selection Search Out Of Memory error: " + virtualMachineError.getMessage() + " on File: " + iFile.getName()), (ICLogConstants.LogConst)ICLogConstants.CDT);
            }
        }
        if (iASTOffsetableNamedElement == null || !(iASTOffsetableNamedElement instanceof IASTNode)) {
            this.operationNotAvailable();
            return;
        }
        this.clearStatusLine();
        CSearchQuery cSearchQuery = this.createSearchQuery(iASTOffsetableNamedElement);
        if (cSearchQuery == null) {
            return;
        }
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQuery((ISearchQuery)cSearchQuery);
    }

    protected abstract String getScopeDescription();

    protected abstract ICSearchScope getScope();

    protected abstract ICSearchConstants.LimitTo getLimitTo();
}

