/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchScopeFactory;
import org.eclipse.cdt.internal.ui.search.CSearchUtil;
import org.eclipse.cdt.internal.ui.search.actions.FindAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;

public class FindDeclarationsInWorkingSetAction
extends FindAction {
    private IWorkingSet[] fWorkingSet;

    public FindDeclarationsInWorkingSetAction(IWorkbenchSite iWorkbenchSite) {
        this(iWorkbenchSite, CSearchMessages.getString("CSearch.FindDeclarationsInWorkingSetAction.label"), CSearchMessages.getString("CSearch.FindDeclarationsInWorkingSetAction.tooltip"));
    }

    public FindDeclarationsInWorkingSetAction(CEditor cEditor) {
        this(cEditor, CSearchMessages.getString("CSearch.FindDeclarationsInWorkingSetAction.label"), CSearchMessages.getString("CSearch.FindDeclarationsInWorkingSetAction.tooltip"));
    }

    public FindDeclarationsInWorkingSetAction(CEditor cEditor, String string, String string2) {
        super(cEditor);
        this.setText(string);
        this.setToolTipText(string2);
    }

    public FindDeclarationsInWorkingSetAction(IWorkbenchSite iWorkbenchSite, String string, String string2) {
        super(iWorkbenchSite);
        this.setText(string);
        this.setToolTipText(string2);
    }

    protected String getScopeDescription() {
        return CSearchMessages.getFormattedString("WorkingSetScope", CSearchUtil.toString(this.fWorkingSet));
    }

    protected ICSearchScope getScope() {
        IWorkingSet[] iWorkingSetArray = this.fWorkingSet;
        if (this.fWorkingSet == null) {
            iWorkingSetArray = CSearchScopeFactory.getInstance().queryWorkingSets();
            if (iWorkingSetArray == null) {
                return null;
            }
            this.fWorkingSet = iWorkingSetArray;
        }
        ICSearchScope iCSearchScope = CSearchScopeFactory.getInstance().createCSearchScope(iWorkingSetArray);
        CSearchUtil.updateLRUWorkingSets(iWorkingSetArray);
        return iCSearchScope;
    }

    protected ICSearchConstants.LimitTo getLimitTo() {
        return ICSearchConstants.DECLARATIONS;
    }
}

