/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.ParseError;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.search.actions.SelectionParseAction;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.IUpdate;

public class OpenDeclarationsAction
extends SelectionParseAction
implements IUpdate {
    SearchEngine searchEngine = null;
    String projectName = "";

    public OpenDeclarationsAction(CEditor cEditor) {
        super(cEditor);
        this.setText(CEditorMessages.getString("OpenDeclarations.label"));
        this.setToolTipText(CEditorMessages.getString("OpenDeclarations.tooltip"));
        this.setDescription(CEditorMessages.getString("OpenDeclarations.description"));
        this.searchEngine = new SearchEngine();
    }

    protected SelectionParseAction.SelSearchNode getSelectedStringFromEditor() {
        ISelection iSelection = this.getSelection();
        if (iSelection == null || !(iSelection instanceof ITextSelection)) {
            return null;
        }
        return this.getSelection((ITextSelection)iSelection);
    }

    public void run() {
        final SelectionParseAction.SelSearchNode selSearchNode = this.getSelectedStringFromEditor();
        if (selSearchNode == null) {
            return;
        }
        final Storage storage = new Storage();
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor iProgressMonitor) {
                IFile iFile = OpenDeclarationsAction.this.fEditor.getInputFile();
                OpenDeclarationsAction.this.projectName = this.findProjectName(iFile);
                IParser iParser = OpenDeclarationsAction.this.setupParser(iFile);
                int n = selSearchNode.selStart;
                int n2 = selSearchNode.selEnd;
                IParser.ISelectionParseResult iSelectionParseResult = null;
                IASTOffsetableNamedElement iASTOffsetableNamedElement = null;
                try {
                    try {
                        iSelectionParseResult = iParser.parse(n, n2);
                        if (iSelectionParseResult != null) {
                            iASTOffsetableNamedElement = iSelectionParseResult.getOffsetableNamedElement();
                        }
                    }
                    catch (ParseError parseError) {
                    }
                    catch (VirtualMachineError virtualMachineError) {
                        if (virtualMachineError instanceof OutOfMemoryError) {
                            Util.log(null, (String)("Open Declarations Out Of Memory error: " + virtualMachineError.getMessage() + " on File: " + iFile.getName()), (ICLogConstants.LogConst)ICLogConstants.CDT);
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (iASTOffsetableNamedElement == null) {
                        return;
                    }
                    throw throwable;
                }
                {
                    Object var9_11 = null;
                    if (iASTOffsetableNamedElement == null) {
                        return;
                    }
                    storage.setFileName(iSelectionParseResult.getFilename());
                    storage.setElement(iASTOffsetableNamedElement);
                    storage.setResource(ParserUtil.getResourceForFilename((String)iSelectionParseResult.getFilename()));
                    return;
                }
            }

            private String findProjectName(IFile iFile) {
                IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = 0;
                while (n < iProjectArray.length) {
                    if (iProjectArray[n].contains((ISchedulingRule)iFile)) {
                        return iProjectArray[n].getName();
                    }
                    ++n;
                }
                return "";
            }
        };
        try {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
            progressMonitorDialog.run(true, true, iRunnableWithProgress);
            IASTOffsetableNamedElement iASTOffsetableNamedElement = storage.getNamedElement();
            if (iASTOffsetableNamedElement == null) {
                this.operationNotAvailable();
                return;
            }
            this.clearStatusLine();
            if (storage.getResource() != null) {
                int n = 0;
                int n2 = 0;
                n = iASTOffsetableNamedElement.getNameOffset();
                n2 = iASTOffsetableNamedElement.getNameEndOffset();
                this.open(storage.getResource(), n, n2 - n);
                return;
            }
            String string = null;
            int n = 0;
            int n3 = 0;
            string = storage.getFileName();
            n = iASTOffsetableNamedElement.getNameOffset();
            n3 = iASTOffsetableNamedElement.getNameEndOffset();
            if (string != null) {
                this.open(string, n, n3 - n);
            }
        }
        catch (Exception exception) {
            CUIPlugin.getDefault().log(exception);
        }
    }

    protected boolean open(String string, int n, int n2) throws PartInitException, CModelException {
        Path path = new Path(string);
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        if (iFile != null) {
            this.open((IResource)iFile, n, n2);
            return true;
        }
        ICProject iCProject = CoreModel.getDefault().getCModel().getCProject(this.projectName);
        ITranslationUnit iTranslationUnit = CoreModel.getDefault().createTranslationUnitFrom(iCProject, (IPath)path);
        if (iTranslationUnit != null) {
            this.setSelectionAtOffset(EditorUtility.openInEditor(iTranslationUnit), n, n2);
            return true;
        }
        FileStorage fileStorage = new FileStorage(null, (IPath)path);
        IEditorPart iEditorPart = EditorUtility.openInEditor(fileStorage);
        this.setSelectionAtOffset(iEditorPart, n, n2);
        return true;
    }

    protected Shell getShell() {
        return this.fEditor.getSite().getShell();
    }

    protected void open(IMatch iMatch) throws CModelException, PartInitException {
        this.open(iMatch.getResource(), iMatch.getStartOffset(), iMatch.getEndOffset() - iMatch.getStartOffset());
    }

    protected void open(IResource iResource, int n, int n2) throws CModelException, PartInitException {
        IEditorPart iEditorPart = EditorUtility.openInEditor(iResource);
        this.setSelectionAtOffset(iEditorPart, n, n2);
    }

    private void setSelectionAtOffset(IEditorPart iEditorPart, int n, int n2) {
        if (iEditorPart instanceof CEditor) {
            CEditor cEditor = (CEditor)iEditorPart;
            try {
                cEditor.selectAndReveal(n, n2);
            }
            catch (Exception exception) {}
        }
    }

    public void update() {
        this.setEnabled(this.getSelectedStringFromEditor() != null);
    }

    private ICSearchConstants.SearchFor getSearchForFromNode(IASTNode iASTNode) {
        ICSearchConstants.SearchFor searchFor = null;
        if (iASTNode instanceof IASTClassSpecifier) {
            IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTNode;
            if (iASTClassSpecifier.getClassKind().equals(ASTClassKind.CLASS)) {
                searchFor = ICSearchConstants.CLASS;
            } else if (iASTClassSpecifier.getClassKind().equals(ASTClassKind.STRUCT)) {
                searchFor = ICSearchConstants.STRUCT;
            } else if (iASTClassSpecifier.getClassKind().equals(ASTClassKind.UNION)) {
                searchFor = ICSearchConstants.UNION;
            }
        } else if (iASTNode instanceof IASTMethod) {
            searchFor = ICSearchConstants.METHOD;
        } else if (iASTNode instanceof IASTFunction) {
            searchFor = ICSearchConstants.FUNCTION;
        } else if (iASTNode instanceof IASTField) {
            searchFor = ICSearchConstants.FIELD;
        } else if (iASTNode instanceof IASTVariable) {
            searchFor = ICSearchConstants.VAR;
        } else if (iASTNode instanceof IASTEnumerationSpecifier) {
            searchFor = ICSearchConstants.ENUM;
        } else if (iASTNode instanceof IASTEnumerator) {
            searchFor = ICSearchConstants.FIELD;
        } else if (iASTNode instanceof IASTNamespaceDefinition) {
            searchFor = ICSearchConstants.NAMESPACE;
        }
        return searchFor;
    }

    private static class Storage {
        private IASTOffsetableNamedElement element;
        private IResource resource;
        private String fileName;

        Storage() {
        }

        public IASTOffsetableNamedElement getNamedElement() {
            return this.element;
        }

        public final String getFileName() {
            return this.fileName;
        }

        public final void setFileName(String string) {
            this.fileName = string;
        }

        public final IResource getResource() {
            return this.resource;
        }

        public final void setResource(IResource iResource) {
            this.resource = iResource;
        }

        public final void setElement(IASTOffsetableNamedElement iASTOffsetableNamedElement) {
            this.element = iASTOffsetableNamedElement;
        }
    }
}

