/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import java.io.IOException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class SelectionParseAction
extends Action {
    protected IWorkbenchSite fSite;
    protected CEditor fEditor;

    public SelectionParseAction() {
    }

    public SelectionParseAction(CEditor cEditor) {
        this.fEditor = cEditor;
        this.fSite = cEditor.getSite();
    }

    public SelectionParseAction(IWorkbenchSite iWorkbenchSite) {
        this.fSite = iWorkbenchSite;
    }

    protected IParser setupParser(IFile iFile) {
        IParser iParser;
        IScannerInfo iScannerInfo;
        IProject iProject = iFile.getProject();
        ScannerInfo scannerInfo = new ScannerInfo();
        IScannerInfoProvider iScannerInfoProvider = CCorePlugin.getDefault().getScannerInfoProvider(iProject);
        if (iScannerInfoProvider != null && (iScannerInfo = iScannerInfoProvider.getScannerInformation((IResource)iFile)) != null) {
            scannerInfo = new ScannerInfo(iScannerInfo.getDefinedSymbols(), iScannerInfo.getIncludePaths());
        }
        iScannerInfo = CoreModel.hasCCNature((IProject)iProject) ? ParserLanguage.CPP : ParserLanguage.C;
        IWorkingCopy iWorkingCopy = null;
        if (this.fEditor.isDirty() && (iParser = CUIPlugin.getSharedWorkingCopies()) != null) {
            int n = 0;
            while (n < ((IWorkingCopy[])iParser).length) {
                if (iParser[n].getUnderlyingResource().equals((Object)iFile)) {
                    iWorkingCopy = iParser[n];
                    break;
                }
                ++n;
            }
        }
        iParser = null;
        CodeReader codeReader = null;
        try {
            codeReader = iWorkingCopy == null ? new CodeReader(iFile.getLocation().toOSString(), iFile.getCharset()) : new CodeReader(iFile.getLocation().toOSString(), iWorkingCopy.getContents());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        try {
            iParser = ParserFactory.createParser((IScanner)ParserFactory.createScanner((CodeReader)codeReader, (IScannerInfo)scannerInfo, (ParserMode)ParserMode.SELECTION_PARSE, (ParserLanguage)iScannerInfo, (ISourceElementRequestor)new NullSourceElementRequestor(), (IParserLogService)ParserUtil.getScannerLogService(), null), (ISourceElementRequestor)new NullSourceElementRequestor(), (ParserMode)ParserMode.SELECTION_PARSE, (ParserLanguage)iScannerInfo, (IParserLogService)ParserUtil.getParserLogService());
        }
        catch (ParserFactoryError parserFactoryError) {}
        return iParser;
    }

    protected void operationNotAvailable() {
        IStatusLineManager iStatusLineManager = null;
        if (this.fSite instanceof IViewSite) {
            iStatusLineManager = ((IViewSite)this.fSite).getActionBars().getStatusLineManager();
        } else if (this.fSite instanceof IEditorSite) {
            iStatusLineManager = ((IEditorSite)this.fSite).getActionBars().getStatusLineManager();
        }
        if (iStatusLineManager != null) {
            iStatusLineManager.setErrorMessage(CSearchMessages.getString("CSearchOperation.operationUnavailable.message"));
        }
    }

    protected void clearStatusLine() {
        IStatusLineManager iStatusLineManager = null;
        if (this.fSite instanceof IViewSite) {
            iStatusLineManager = ((IViewSite)this.fSite).getActionBars().getStatusLineManager();
        } else if (this.fSite instanceof IEditorSite) {
            iStatusLineManager = ((IEditorSite)this.fSite).getActionBars().getStatusLineManager();
        }
        if (iStatusLineManager != null) {
            iStatusLineManager.setErrorMessage("");
        }
    }

    public SelSearchNode getSelection(int n) {
        IDocument iDocument;
        IDocumentProvider iDocumentProvider = this.fEditor != null ? this.fEditor.getDocumentProvider() : null;
        IDocument iDocument2 = iDocument = iDocumentProvider != null ? iDocumentProvider.getDocument((Object)this.fEditor.getEditorInput()) : null;
        if (iDocument == null) {
            return null;
        }
        int n2 = n;
        int n3 = 0;
        int n4 = 0;
        String string = null;
        try {
            char c;
            while (n2 >= 0) {
                c = iDocument.getChar(n2);
                if (!Character.isJavaIdentifierPart(c)) break;
                --n2;
            }
            n3 = n2 + 1;
            n2 = n;
            int n5 = iDocument.getLength();
            while (n2 < n5) {
                c = iDocument.getChar(n2);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++n2;
            }
            n4 = n2;
            string = iDocument.get(n3, n4 - n3);
        }
        catch (BadLocationException badLocationException) {}
        SelSearchNode selSearchNode = new SelSearchNode();
        selSearchNode.selText = string;
        selSearchNode.selStart = n3;
        selSearchNode.selEnd = n4;
        return selSearchNode;
    }

    protected SelSearchNode getSelection(ITextSelection iTextSelection) {
        if (iTextSelection == null) {
            return null;
        }
        String string = iTextSelection.getText();
        SelSearchNode selSearchNode = null;
        if (string == null || string.length() == 0) {
            int n = iTextSelection.getOffset();
            selSearchNode = this.getSelection(n);
        } else {
            selSearchNode = new SelSearchNode();
            selSearchNode.selText = string;
            selSearchNode.selStart = iTextSelection.getOffset();
            selSearchNode.selEnd = iTextSelection.getOffset() + iTextSelection.getLength();
        }
        return selSearchNode;
    }

    protected ISelection getSelection() {
        ISelection iSelection = null;
        if (this.fSite != null && this.fSite.getSelectionProvider() != null) {
            iSelection = this.fSite.getSelectionProvider().getSelection();
        }
        return iSelection;
    }

    class SelSearchNode {
        protected String selText;
        protected int selStart;
        protected int selEnd;

        SelSearchNode() {
        }
    }
}

