/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.search.actions.DeclarationsSearchGroup;
import org.eclipse.cdt.internal.ui.search.actions.ReferencesSearchGroup;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;

public class SelectionSearchGroup
extends ActionGroup {
    private CEditor fEditor;
    private DeclarationsSearchGroup fDeclarationsSearchGroup;
    private ReferencesSearchGroup fRefSearchGroup;

    public SelectionSearchGroup(CEditor cEditor) {
        this.fEditor = cEditor;
        this.fDeclarationsSearchGroup = new DeclarationsSearchGroup(this.fEditor);
        this.fRefSearchGroup = new ReferencesSearchGroup(this.fEditor);
    }

    public SelectionSearchGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    public SelectionSearchGroup(IWorkbenchSite iWorkbenchSite) {
        this.fDeclarationsSearchGroup = new DeclarationsSearchGroup(iWorkbenchSite);
        this.fRefSearchGroup = new ReferencesSearchGroup(iWorkbenchSite);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        this.fDeclarationsSearchGroup.fillContextMenu(iMenuManager);
        this.fRefSearchGroup.fillContextMenu(iMenuManager);
    }

    public static boolean canActionBeAdded(ISelection iSelection) {
        if (iSelection instanceof ITextSelection) {
            return ((ITextSelection)iSelection).getLength() > 0;
        }
        return SelectionSearchGroup.getElement(iSelection) != null;
    }

    private static ICElement getElement(ISelection iSelection) {
        Object e;
        List list;
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection && (list = ((IStructuredSelection)iSelection).toList()).size() == 1 && (e = list.get(0)) instanceof ICElement) {
            return (ICElement)e;
        }
        return null;
    }

    public void dispose() {
        if (this.fDeclarationsSearchGroup != null) {
            this.fDeclarationsSearchGroup.dispose();
            this.fDeclarationsSearchGroup = null;
        }
        if (this.fRefSearchGroup != null) {
            this.fRefSearchGroup.dispose();
            this.fRefSearchGroup = null;
        }
        this.fEditor = null;
        super.dispose();
    }
}

